/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.injection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.jetbrains.php.joomla.injection.builder.JDatabaseQuery;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class JoomlaSQLCaches
implements Disposable {
    private final LowMemoryWatcher myLowMemoryWatcher;
    public Map<PsiElement, JDatabaseQuery> SQL_CACHE = Collections.synchronizedMap(new HashMap());
    final Project myProject;

    public JoomlaSQLCaches(Project project) {
        this.myProject = project;
        this.myLowMemoryWatcher = LowMemoryWatcher.register(this::clearCaches);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(PsiModificationTracker.TOPIC, this::clearCaches);
    }

    public void dispose() {
        this.myLowMemoryWatcher.stop();
        this.clearCaches();
    }

    private void clearCaches() {
        Map<PsiElement, JDatabaseQuery> type_cache = this.SQL_CACHE;
        if (this.SQL_CACHE.size() > 0) {
            this.SQL_CACHE = Collections.synchronizedMap(new HashMap());
            type_cache.clear();
        }
    }

    public static JoomlaSQLCaches getInstance(Project project) {
        return (JoomlaSQLCaches)ServiceManager.getService((Project)project, JoomlaSQLCaches.class);
    }
}

