/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.init;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.jetbrains.php.frameworks.IntegrationUtil;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.JoomlaUtil;
import com.jetbrains.php.joomla.codeStyle.JoomlaPredefinedCodeStyle;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class JoomlaFormattingManager {
    private static final Class<JoomlaPredefinedCodeStyle> CODE_STYLE = JoomlaPredefinedCodeStyle.class;

    private JoomlaFormattingManager() {
    }

    public static void offerJoomlaFormatting(JoomlaDataService.State newState, JoomlaDataService.State oldState, final Project project) {
        if (!newState.isEnabled() || oldState.isEnabled() || JoomlaFormattingManager.getJoomlaCodeStyle(project) == null) {
            return;
        }
        Function<Notification, AnAction> setAction = notification -> new AnAction(CommonBundle.message((String)"button.set", (Object[])new Object[0]), (Notification)notification){
            final /* synthetic */ Notification val$notification;
            {
                this.val$notification = notification;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                PredefinedCodeStyle codeStyle;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((codeStyle = JoomlaFormattingManager.getJoomlaCodeStyle(project)) != null) {
                    IntegrationUtil.setPredefinedCodeStyleToProject((Project)project, (PredefinedCodeStyle[])new PredefinedCodeStyle[]{codeStyle});
                }
                this.val$notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/init/JoomlaFormattingManager$1", "actionPerformed"));
            }
        };
        JoomlaUtil.notifyGlobally(project, JoomlaBundle.message("joomla.plugin.title", new Object[0]), JoomlaBundle.message("joomla.offer.formatting", new Object[0]), NotificationType.INFORMATION, setAction);
    }

    private static PredefinedCodeStyle getJoomlaCodeStyle(@NotNull Project project) {
        PredefinedCodeStyle codeStyle;
        if (project == null) {
            JoomlaFormattingManager.$$$reportNull$$$0(0);
        }
        if ((codeStyle = (PredefinedCodeStyle)PredefinedCodeStyle.EP_NAME.findExtension(CODE_STYLE)) == null) {
            return null;
        }
        return IntegrationUtil.isFormattingStyleSet((Project)project, (PredefinedCodeStyle)codeStyle) ? null : codeStyle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/joomla/init/JoomlaFormattingManager", "getJoomlaCodeStyle"));
    }
}

