/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.init;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.JoomlaUtil;
import com.jetbrains.php.joomla.settings.JoomlaConfigurable;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JoomlaDetectionManager {
    @NonNls
    private static final String ENABLE_SUPPORT_DESCRIPTION = "enableSupport";
    @NonNls
    private static final String DO_NOT_ASK_AGAIN_DESCRIPTION = "doNotAskAgain";
    public static final String EXTENSION_TAG = "extension";
    public static final String JEXEC_CONSTANT = "_JEXEC";

    private JoomlaDetectionManager() {
    }

    public static void offerIntegrationSetup(final Project project) {
        if (project == null || project.isDefault()) {
            return;
        }
        JoomlaDataService dataService = JoomlaDataService.getInstance(project);
        if (dataService.isEnabled() || dataService.doNotAskAgain()) {
            return;
        }
        VirtualFile baseDir = project.getBaseDir();
        String message = null;
        Function<Notification, AnAction> enableAction = notification -> new AnAction(JoomlaBundle.message("action.enable.support.text", new Object[0]), (Notification)notification){
            final /* synthetic */ Notification val$notification;
            {
                this.val$notification = notification;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpUiUtil.editConfigurable((Project)project, (Configurable)new JoomlaConfigurable(project){

                    @Override
                    public void reset() {
                        this.myEnableJoomlaIntegrationJBCheckBox.setSelected(true);
                        this.updateSettingsPanelEnabled();
                    }
                });
                this.val$notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/init/JoomlaDetectionManager$1", "actionPerformed"));
            }
        };
        Function<Notification, AnAction> doNotAskAgain = notification -> new AnAction(JoomlaBundle.message("action.do.not.ask.again.text", new Object[0]), (Notification)notification){
            final /* synthetic */ Notification val$notification;
            {
                this.val$notification = notification;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                JoomlaDataService.getInstance(project).setDoNotAskAgain(true);
                this.val$notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/init/JoomlaDetectionManager$2", "actionPerformed"));
            }
        };
        if (JoomlaDetectionManager.isJoomlaExtension(project, baseDir)) {
            message = JoomlaBundle.message("joomla.set.up.integration.popup.extension", ENABLE_SUPPORT_DESCRIPTION, DO_NOT_ASK_AGAIN_DESCRIPTION);
        }
        if (JoomlaDetectionManager.isJoomlaFramework(project)) {
            message = JoomlaBundle.message("joomla.set.up.integration.popup.framework", ENABLE_SUPPORT_DESCRIPTION, DO_NOT_ASK_AGAIN_DESCRIPTION);
        }
        if (message != null) {
            JoomlaUtil.notifyGlobally(project, JoomlaBundle.message("joomla.plugin.title", new Object[0]), message, NotificationType.INFORMATION, enableAction, doNotAskAgain);
        }
    }

    public static boolean isJoomlaFramework(Project project) {
        PhpIndex instance = PhpIndex.getInstance((Project)project);
        Collection constantsByName = instance.getConstantsByName(JEXEC_CONSTANT);
        for (Constant it : constantsByName) {
            PsiElement itValue = it.getValue();
            if (itValue == null || itValue.getText().equals("1")) continue;
            return false;
        }
        return constantsByName.size() > 0;
    }

    public static boolean isJoomlaExtension(Project project, @Nullable VirtualFile baseDir) {
        if (baseDir == null) {
            return false;
        }
        for (VirtualFile it : baseDir.getChildren()) {
            if (!FileTypeRegistry.getInstance().isFileOfType(it, (FileType)XmlFileType.INSTANCE)) continue;
            return JoomlaDetectionManager.isJoomlaManifest(project, it);
        }
        return false;
    }

    private static boolean isJoomlaManifest(Project project, VirtualFile vf) {
        PsiFile psifile = PsiManager.getInstance((Project)project).findFile(vf);
        if (psifile instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psifile;
            XmlTag rootTag = xmlFile.getRootTag();
            return rootTag != null && EXTENSION_TAG.equals(rootTag.getName());
        }
        return false;
    }
}

