/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.init;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.JoomlaUtil;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JoomlaContentConfigurationManager {
    private static final JoomlaContentConfigurationManager INSTANCE = new JoomlaContentConfigurationManager();
    @Nullable
    private VirtualFile myJoomlaConfigFile;

    public static JoomlaContentConfigurationManager getInstance() {
        return INSTANCE;
    }

    private JoomlaContentConfigurationManager() {
    }

    public void refreshIncludePaths(JoomlaDataService.State newState, Project project) {
        if (!project.isDefault() && newState.isEnabled() && !newState.isDoNotAskContentConfigAgain()) {
            VirtualFile joomlaDirectory = this.getVirtualFileFile(newState.getJoomlaPath(), true);
            if (joomlaDirectory == null) {
                return;
            }
            boolean isPluginInsideJoomla = JoomlaContentConfigurationManager.isProjectInsideJoomla(joomlaDirectory, project);
            if (isPluginInsideJoomla) {
                Module module;
                Module[] modules = ModuleManager.getInstance((Project)project).getModules();
                if (modules.length == 1 && !JoomlaContentConfigurationManager.isFileInsideModule(joomlaDirectory, module = modules[0])) {
                    JoomlaContentConfigurationManager.suggestToChangeContentRoots(joomlaDirectory, project, module);
                }
            } else if (!JoomlaContentConfigurationManager.isInProject(project, joomlaDirectory)) {
                JoomlaContentConfigurationManager.addToIncludeFiles(project, joomlaDirectory);
            }
            VirtualFile configFile = this.getVirtualFileFile(newState.getJoomlaConfigPath(), false);
            if (configFile != null && this.shouldAddConfigurationFile(project, joomlaDirectory, configFile)) {
                JoomlaContentConfigurationManager.addToIncludeFiles(project, configFile);
            }
        }
    }

    public boolean shouldAddConfigurationFile(@NotNull Project project, @NotNull VirtualFile joomlaDirectory, @NotNull VirtualFile configFile) {
        if (project == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(0);
        }
        if (joomlaDirectory == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(1);
        }
        if (configFile == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(2);
        }
        return !VfsUtilCore.isAncestor((VirtualFile)joomlaDirectory, (VirtualFile)configFile, (boolean)false) && !JoomlaContentConfigurationManager.isInProject(project, configFile);
    }

    private static void suggestToChangeContentRoots(final @NotNull VirtualFile JoomlaFile, final @NotNull Project project, final @NotNull Module module) {
        if (JoomlaFile == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(4);
        }
        if (module == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(5);
        }
        String message = JoomlaBundle.message("joomla.suggestion.content.roots", new Object[0]);
        Function<Notification, AnAction> fixAction = notification -> new AnAction(JoomlaBundle.message("action.fix.text", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ModuleRootModificationUtil.updateModel((Module)module, model -> {
                    ContentEntry[] contentEntries = model.getContentEntries();
                    ContentEntry rootEntry = null;
                    for (ContentEntry entry : contentEntries) {
                        VirtualFile entryFile = entry.getFile();
                        VirtualFile baseDir = project.getBaseDir();
                        if (entryFile == null || baseDir == null || !VfsUtilCore.isAncestor((VirtualFile)entryFile, (VirtualFile)baseDir, (boolean)false)) continue;
                        rootEntry = entry;
                        break;
                    }
                    model.addContentEntry(JoomlaFile);
                    if (rootEntry != null) {
                        model.removeContentEntry(rootEntry);
                    }
                });
                if (PlatformUtils.isPhpStorm()) {
                    Runnable runnable = () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, JoomlaBundle.message("configurable.name.directories", new Object[0]));
                    ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/init/JoomlaContentConfigurationManager$1", "actionPerformed"));
            }
        };
        Function<Notification, AnAction> ignoreAction = notification -> new AnAction(JoomlaBundle.message("action.ignore.text", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                JoomlaDataService.getInstance(project).setDoNotAskContentConfigurationAgain(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/init/JoomlaContentConfigurationManager$2", "actionPerformed"));
            }
        };
        JoomlaContentConfigurationManager.showPopup(project, message, fixAction, ignoreAction);
    }

    private static void addToIncludeFiles(@NotNull Project project, @NotNull VirtualFile joomlaFile) {
        if (project == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(6);
        }
        if (joomlaFile == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(7);
        }
        Runnable runnable = () -> {
            PhpIncludePathManager facade = PhpIncludePathManager.getInstance((Project)project);
            List includePaths = facade.getIncludePath();
            ArrayList<String> newIncludePaths = new ArrayList<String>(includePaths.size() + 1);
            newIncludePaths.addAll(includePaths);
            String path = joomlaFile.getPath();
            newIncludePaths.add(path);
            facade.setIncludePath(newIncludePaths);
        };
        ApplicationManager.getApplication().runWriteAction(runnable);
    }

    @Nullable
    public PhpFile getConfigurationFile(Project project) {
        String joomlaConfigPath = JoomlaDataService.getInstance(project).getJoomlaConfigPath();
        if (joomlaConfigPath != null && !joomlaConfigPath.isEmpty()) {
            this.myJoomlaConfigFile = LocalFileSystem.getInstance().findFileByPath(joomlaConfigPath);
        } else {
            VirtualFile joomlaDirectoryPath;
            String joomlaPath = JoomlaDataService.getInstance(project).getJoomlaPath();
            if (joomlaPath != null && (joomlaDirectoryPath = LocalFileSystem.getInstance().findFileByPath(joomlaPath)) != null) {
                this.myJoomlaConfigFile = joomlaDirectoryPath.findFileByRelativePath("configuration.php");
            }
        }
        if (this.myJoomlaConfigFile != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiFile psiManagerFile = psiManager.findFile(this.myJoomlaConfigFile);
            return psiManagerFile instanceof PhpFile ? (PhpFile)psiManagerFile : null;
        }
        return null;
    }

    @Nullable
    public PhpClass getConfigurationClass(Project project) {
        PhpIndex index = PhpIndex.getInstance((Project)project);
        Collection configClasses = index.getClassesByName("JConfig");
        PhpFile file = this.getConfigurationFile(project);
        if (file != null) {
            for (PhpClass it : configClasses) {
                if (!it.getContainingFile().getVirtualFile().equals(file.getVirtualFile())) continue;
                return it;
            }
        }
        return null;
    }

    @Nullable
    public String getProperty(Project project, String propertyName) {
        PsiElement defaultValue;
        Field fieldByName;
        PhpClass configurationClass = this.getConfigurationClass(project);
        if (configurationClass != null && (fieldByName = configurationClass.findFieldByName((CharSequence)propertyName, false)) != null && (defaultValue = fieldByName.getDefaultValue()) != null) {
            return PhpCodeInsightUtil.toString((PsiElement)defaultValue);
        }
        return null;
    }

    private static boolean isInProject(@NotNull Project project, VirtualFile fileToCheck) {
        if (project == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(8);
        }
        return PhpIncludePathManager.isInProject((VirtualFile)fileToCheck, (ProjectFileIndex)ProjectFileIndex.getInstance((Project)project), (List)PhpIncludePathManager.getInstance((Project)project).getRoots());
    }

    @Nullable
    private VirtualFile getVirtualFileFile(String path, boolean isDirectory) {
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file != null && file.isDirectory() == isDirectory) {
            this.myJoomlaConfigFile = file;
            return file;
        }
        this.myJoomlaConfigFile = null;
        return null;
    }

    private static boolean isProjectInsideJoomla(@NotNull VirtualFile joomlaFile, @NotNull Project project) {
        if (joomlaFile == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(9);
        }
        if (project == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(10);
        }
        return VfsUtilCore.isAncestor((VirtualFile)joomlaFile, (VirtualFile)project.getBaseDir(), (boolean)false);
    }

    private static boolean isFileInsideModule(@NotNull VirtualFile joomlaFile, @NotNull Module module) {
        VirtualFile[] contentRoots;
        if (joomlaFile == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(11);
        }
        if (module == null) {
            JoomlaContentConfigurationManager.$$$reportNull$$$0(12);
        }
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)joomlaFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static void showPopup(Project project, @NlsContexts.NotificationContent String message, Function<Notification, AnAction> ... actions) {
        Runnable runnable = () -> JoomlaUtil.notifyGlobally(project, JoomlaBundle.message("joomla.plugin.title", new Object[0]), message, NotificationType.INFORMATION, actions);
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joomlaDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "JoomlaFile";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joomlaFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/joomla/init/JoomlaContentConfigurationManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldAddConfigurationFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestToChangeContentRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addToIncludeFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isInProject";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectInsideJoomla";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileInsideModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

