/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.joomla.JoomlaBundle;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class JoomlaUtil {
    @NlsContexts.DialogMessage
    public static String validateJoomlaConfigFile(@Nullable Project project, String myConfigPathFieldText) {
        if (StringUtil.isEmptyOrSpaces((String)myConfigPathFieldText)) {
            return JoomlaBundle.message("joomla.validate.config.message", new Object[0]);
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(myConfigPathFieldText);
        if (file == null || file.isDirectory()) {
            return JoomlaBundle.message("joomla.validate.config.message", new Object[0]);
        }
        if (project != null && !PhpIncludePathManager.isInProject((VirtualFile)file, (ProjectFileIndex)ProjectFileIndex.getInstance((Project)project), (List)PhpIncludePathManager.getInstance((Project)project).getRoots())) {
            return JoomlaBundle.message("joomla.validate.config.new.config.file.will.be.added.to.project", new Object[0]);
        }
        return null;
    }

    public static void notifyGlobally(@Nullable Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message, NotificationType notificationType, Function<Notification, AnAction> ... actions) {
        Notification notification = new Notification("Joomla", title, message, notificationType, null);
        for (Function<Notification, AnAction> actionGenerator : actions) {
            notification.addAction(actionGenerator.apply(notification));
        }
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    @Nullable
    @NlsContexts.DialogMessage
    public static String validateJoomlaFolder(String path) {
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return JoomlaBundle.message("joomla.validate.directory.message", new Object[0]);
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null || !file.isDirectory()) {
            return JoomlaBundle.message("joomla.validate.directory.message", new Object[0]);
        }
        return null;
    }
}

