/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.wsl.mapping;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PhpWslPathHelpers {
    public static boolean isWsl2Path(@NotNull String path) {
        if (path == null) {
            PhpWslPathHelpers.$$$reportNull$$$0(0);
        }
        if (path.isEmpty()) {
            return false;
        }
        int start = PhpWslPathHelpers.findFirstNotSlash(path);
        if (start >= 0 && start + 4 <= path.length()) {
            String wslPrefix = path.substring(start, start + 4);
            return "wsl$".equals(wslPrefix);
        }
        return false;
    }

    private static int findFirstNotSlash(String path) {
        return StringUtil.findFirst((CharSequence)path, ch -> !PhpWslPathHelpers.isSlash(ch));
    }

    private static boolean isSlash(char first) {
        return first == '/' || first == '\\';
    }

    public static String toLocalWsl2Path(@NotNull String path) {
        if (path == null) {
            PhpWslPathHelpers.$$$reportNull$$$0(1);
        }
        if (!PhpWslPathHelpers.isWsl2Path(path)) {
            return path;
        }
        path = PhpWslPathHelpers.trimLeadingSlashes(path);
        return "\\\\" + FileUtilRt.toSystemDependentName((String)path, (char)'\\');
    }

    @NotNull
    private static String trimLeadingSlashes(@NotNull String path) {
        int start;
        if (path == null) {
            PhpWslPathHelpers.$$$reportNull$$$0(2);
        }
        if ((start = PhpWslPathHelpers.findFirstNotSlash(path)) > 0) {
            path = path.substring(start);
        }
        String string = start < 0 ? "" : path;
        if (string == null) {
            PhpWslPathHelpers.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static String toRemoteWsl2PathWithoutPrefix(@NotNull String path) {
        if (path == null) {
            PhpWslPathHelpers.$$$reportNull$$$0(4);
        }
        if (!PhpWslPathHelpers.isWsl2Path(path)) {
            return path;
        }
        path = PhpWslPathHelpers.trimLeadingSlashes(path);
        path = FileUtilRt.toSystemIndependentName((String)path);
        int nextSeparator = (path = StringUtil.trimStart((String)path, (String)"wsl$/")).indexOf("/");
        path = nextSeparator < 0 ? "" : path.substring(nextSeparator);
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/wsl/mapping/PhpWslPathHelpers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/wsl/mapping/PhpWslPathHelpers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeadingSlashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isWsl2Path";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toLocalWsl2Path";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "trimLeadingSlashes";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toRemoteWsl2PathWithoutPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

