/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import com.intellij.wsl.WSLCredentialsHolder;
import com.jetbrains.php.remote.PhpRemoteProcessRunner;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.wsl.PhpWslListener;
import com.jetbrains.php.remote.wsl.PhpWslProcessHandler;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpWslRemoteProcessRunner
extends PhpRemoteProcessRunner {
    private static final int PTY_COLUMNS_AMOUNT = 2500;
    private final WSLDistribution myWSLDistribution;

    @NotNull
    public static PhpWslRemoteProcessRunner getInstance(PhpRemoteSdkAdditionalData data) {
        try {
            WSLDistribution distribution = WSLCredentialsHolder.get((RemoteSdkAdditionalData)data).getDistribution();
            return new PhpWslRemoteProcessRunner(distribution);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected PhpWslRemoteProcessRunner(WSLDistribution WSLDistribution2) {
        this.myWSLDistribution = WSLDistribution2;
    }

    @NotNull
    public ProcessOutput getProcessOutput(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, @NotNull String title, @Nullable JComponent component) throws ExecutionException {
        if (project == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(1);
        }
        if (commandLine == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(2);
        }
        if (title == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(3);
        }
        GeneralCommandLine patchedCommandLine = this.patchCommandLine(project, commandLine);
        PhpWslProcessHandler processHandler = this.createRemoteProcessHandler(patchedCommandLine);
        PhpWslListener outputListener = new PhpWslListener(2500);
        processHandler.addProcessListener((ProcessListener)outputListener);
        ExecutionMode executionMode = new ExecutionMode(false, null, null, false, false, null);
        processHandler.startNotify();
        ExecutionHelper.executeExternalProcess((Project)project, (ProcessHandler)processHandler, (ExecutionMode)executionMode, (GeneralCommandLine)patchedCommandLine);
        ProcessOutput processOutput = outputListener.getOutput();
        if (processOutput == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(4);
        }
        return processOutput;
    }

    @NotNull
    public Process getRemoteProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(5);
        }
        if (data == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(7);
        }
        if (additionalMappings == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(8);
        }
        return this.startAndGetProcess(project, commandLine);
    }

    @NotNull
    private Process startAndGetProcess(@NotNull Project project, @NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (project == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(9);
        }
        if (commandLine == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(10);
        }
        GeneralCommandLine patchedCommandLine = this.patchCommandLine(project, commandLine);
        Process process = patchedCommandLine.createProcess();
        if (process == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(11);
        }
        return process;
    }

    @NotNull
    protected GeneralCommandLine patchCommandLine(@NotNull Project project, @NotNull GeneralCommandLine commandLine) throws ExecutionException {
        PtyCommandLine ptyCommandLine;
        File workDirectory;
        if (project == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(12);
        }
        if (commandLine == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(13);
        }
        if ((workDirectory = (ptyCommandLine = new PtyCommandLine(commandLine).withConsoleMode(true).withInitialColumns(2500)).getWorkDirectory()) != null) {
            ptyCommandLine.setWorkDirectory((File)null);
        }
        String wslWorkingDir = this.getWslWorkingDirectory(workDirectory);
        GeneralCommandLine generalCommandLine = this.myWSLDistribution.patchCommandLine((GeneralCommandLine)ptyCommandLine, project, new WSLCommandLineOptions().setRemoteWorkingDirectory(wslWorkingDir).setLaunchWithWslExe(false));
        if (generalCommandLine == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(14);
        }
        return generalCommandLine;
    }

    private String getWslWorkingDirectory(File workingDirectory) {
        if (workingDirectory == null) {
            return null;
        }
        String remoteWorkingDir = FileUtil.toSystemIndependentName((String)workingDirectory.getPath());
        String wslWorkingDir = this.myWSLDistribution.getWslPath(remoteWorkingDir);
        return wslWorkingDir == null ? remoteWorkingDir : wslWorkingDir;
    }

    @NotNull
    public Process getRemoteBackgroundProcess(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data, @NotNull GeneralCommandLine commandLine, PathMappingSettings.PathMapping ... additionalMappings) throws ExecutionException {
        if (project == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(15);
        }
        if (data == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(16);
        }
        if (commandLine == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(17);
        }
        if (additionalMappings == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(18);
        }
        return this.startAndGetProcess(project, commandLine);
    }

    @NotNull
    public Process startRemoteProcessWithoutHelpers(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data, @NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (project == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(19);
        }
        if (data == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(20);
        }
        if (commandLine == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(21);
        }
        return this.startAndGetProcess(project, commandLine);
    }

    @NotNull
    public ProcessHandler createRemoteProcessHandler(@NotNull Process process, @NotNull String commandTitle, @NotNull Charset charset, @NotNull PhpRemoteSdkAdditionalData remoteData, boolean verbose) {
        if (process == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(22);
        }
        if (commandTitle == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(23);
        }
        if (charset == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(24);
        }
        if (remoteData == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(25);
        }
        return new PhpWslProcessHandler(process, commandTitle, charset);
    }

    @NotNull
    public PhpWslProcessHandler createRemoteProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            PhpWslRemoteProcessRunner.$$$reportNull$$$0(26);
        }
        return new PhpWslProcessHandler(commandLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/wsl/PhpWslRemoteProcessRunner";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalMappings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandTitle";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/wsl/PhpWslRemoteProcessRunner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "startAndGetProcess";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 4: 
            case 11: 
            case 14: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteProcess";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startAndGetProcess";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteBackgroundProcess";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startRemoteProcessWithoutHelpers";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteProcessHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

