/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.wsl;

import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class PhpWslListener
extends CapturingProcessAdapter {
    private final List<PhpWslOutputHandler> myStdoutHandlers;

    PhpWslListener(int columnsAmount) {
        this.myStdoutHandlers = Arrays.asList(new UnknownSequenceFilter(), new ExtraWhitespacesInserter(columnsAmount));
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        if (event == null) {
            PhpWslListener.$$$reportNull$$$0(0);
        }
        if (outputType == null) {
            PhpWslListener.$$$reportNull$$$0(1);
        }
        String text = event.getText();
        if (outputType.equals((Object)ProcessOutputTypes.STDOUT)) {
            for (PhpWslOutputHandler handler : this.myStdoutHandlers) {
                text = handler.handleText(text);
            }
        }
        super.addToOutput(text, outputType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "event";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "outputType";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/remote/wsl/PhpWslListener";
        objectArray[2] = "onTextAvailable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class ExtraWhitespacesInserter
    implements PhpWslOutputHandler {
        private final int myColumnsAmount;
        protected boolean myIsLastLineSpotted = false;

        ExtraWhitespacesInserter(int amount) {
            this.myColumnsAmount = amount;
        }

        @Override
        @NotNull
        public String handleText(@NotNull String text) {
            if (text == null) {
                ExtraWhitespacesInserter.$$$reportNull$$$0(0);
            }
            if (StringUtil.endsWith((CharSequence)text, (CharSequence)"\n")) {
                text = StringUtil.trimEnd((String)text, (char)'\n');
                text = (String)text + StringUtil.repeatSymbol((char)' ', (int)(this.myColumnsAmount - ((String)text).length()));
                text = (String)text + "\n";
            } else {
                if (StringUtil.isEmpty((String)text)) {
                    String string = text;
                    if (string == null) {
                        ExtraWhitespacesInserter.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                if (this.myIsLastLineSpotted) {
                    throw new IllegalArgumentException("Each line here must end with EOL, but this does not: " + (String)text);
                }
                this.myIsLastLineSpotted = true;
            }
            String string = text;
            if (string == null) {
                ExtraWhitespacesInserter.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/remote/wsl/PhpWslListener$ExtraWhitespacesInserter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/remote/wsl/PhpWslListener$ExtraWhitespacesInserter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handleText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleText";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class UnknownSequenceFilter
    implements PhpWslOutputHandler {
        private static final String UNKNOWN_SEQUENCE = "^Z\n";
        private boolean canMeetUnknownSequence = true;

        protected UnknownSequenceFilter() {
        }

        @Override
        @NotNull
        public String handleText(@NotNull String text) {
            if (text == null) {
                UnknownSequenceFilter.$$$reportNull$$$0(0);
            }
            if (this.canMeetUnknownSequence) {
                if (text.contains(UNKNOWN_SEQUENCE)) {
                    text = text.replace(UNKNOWN_SEQUENCE, "");
                }
                this.canMeetUnknownSequence = false;
            }
            String string = text;
            if (string == null) {
                UnknownSequenceFilter.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/remote/wsl/PhpWslListener$UnknownSequenceFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/remote/wsl/PhpWslListener$UnknownSequenceFilter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handleText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleText";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static interface PhpWslOutputHandler {
        @NotNull
        public String handleText(@NotNull String var1);
    }
}

