/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.impl.httpclient.TaskResponseUtil;
import com.intellij.tasks.youtrack.YouTrackRepository;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jetbrains.annotations.NotNull;

public class YouTrackIntellisense {
    public static final Key<YouTrackIntellisense> INTELLISENSE_KEY = Key.create((String)"youtrack.intellisense");
    private static final Logger LOG = Logger.getInstance(YouTrackIntellisense.class);
    private static final Map<String, TextAttributes> TEXT_ATTRIBUTES = ContainerUtil.newHashMap((Pair)Pair.create((Object)"field-value", (Object)DefaultLanguageHighlighterColors.CONSTANT.getDefaultAttributes()), (Pair[])new Pair[]{Pair.create((Object)"field-name", (Object)DefaultLanguageHighlighterColors.KEYWORD.getDefaultAttributes()), Pair.create((Object)"text", (Object)DefaultLanguageHighlighterColors.STRING.getDefaultAttributes()), Pair.create((Object)"error", (Object)HighlighterColors.BAD_CHARACTER.getDefaultAttributes())});
    private static final int CACHE_SIZE = 30;
    private static final Map<Pair<String, Integer>, Response> ourCache = Collections.synchronizedMap(new SizeLimitedCache(30));
    private final YouTrackRepository myRepository;

    @NotNull
    private static TextAttributes getAttributeByStyleClass(@NotNull String styleClass) {
        TextAttributes attr;
        if (styleClass == null) {
            YouTrackIntellisense.$$$reportNull$$$0(0);
        }
        TextAttributes textAttributes = (attr = TEXT_ATTRIBUTES.get(styleClass)) == null ? HighlighterColors.TEXT.getDefaultAttributes() : attr;
        if (textAttributes == null) {
            YouTrackIntellisense.$$$reportNull$$$0(1);
        }
        return textAttributes;
    }

    @NotNull
    public List<HighlightRange> fetchHighlighting(@NotNull String query, int caret) throws Exception {
        if (query == null) {
            YouTrackIntellisense.$$$reportNull$$$0(2);
        }
        LOG.debug("Requesting highlighting");
        List<HighlightRange> list = this.fetch(query, caret, true).getHighlightRanges();
        if (list == null) {
            YouTrackIntellisense.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<CompletionItem> fetchCompletion(@NotNull String query, int caret) throws Exception {
        if (query == null) {
            YouTrackIntellisense.$$$reportNull$$$0(4);
        }
        LOG.debug("Requesting completion");
        List<CompletionItem> list = this.fetch(query, caret, false).getCompletionItems();
        if (list == null) {
            YouTrackIntellisense.$$$reportNull$$$0(5);
        }
        return list;
    }

    public YouTrackIntellisense(@NotNull YouTrackRepository repository) {
        if (repository == null) {
            YouTrackIntellisense.$$$reportNull$$$0(6);
        }
        this.myRepository = repository;
    }

    @NotNull
    private Response fetch(@NotNull String query, int caret, boolean ignoreCaret) throws Exception {
        if (query == null) {
            YouTrackIntellisense.$$$reportNull$$$0(7);
        }
        LOG.debug("Query: '" + query + "' caret at: " + caret);
        Pair lookup = Pair.create((Object)query, (Object)caret);
        Response response = null;
        if (ignoreCaret) {
            for (Pair<String, Integer> pair : ourCache.keySet()) {
                if (!((String)pair.getFirst()).equals(query)) continue;
                response = ourCache.get(pair);
                break;
            }
        } else {
            response = ourCache.get(lookup);
        }
        LOG.debug("Cache " + (response != null ? "hit" : "miss"));
        if (response == null) {
            long startTime = System.currentTimeMillis();
            URI endpoint = new URIBuilder(this.myRepository.getRestApiUrl("api", "search", "assist")).addParameter("fields", "styleRanges(length,start,style),suggestions(completionEnd,completionStart,description,matchingEnd,matchingStart,option,prefix,suffix)").build();
            HttpPost request = new HttpPost(endpoint);
            Gson gson = TaskGsonUtil.createDefaultBuilder().create();
            Map<String, Integer> payload = Map.of("query", query, "caret", caret);
            request.setEntity((HttpEntity)new StringEntity(gson.toJson(payload), ContentType.APPLICATION_JSON));
            response = (Response)this.myRepository.getHttpClient().execute((HttpUriRequest)request, new TaskResponseUtil.GsonSingleObjectDeserializer<Response>(gson, Response.class));
            LOG.debug(String.format("Intellisense request to YouTrack took %d ms to complete", System.currentTimeMillis() - startTime));
            ourCache.put((Pair<String, Integer>)lookup, response);
        }
        Response response2 = response;
        if (response2 == null) {
            YouTrackIntellisense.$$$reportNull$$$0(8);
        }
        return response2;
    }

    public YouTrackRepository getRepository() {
        return this.myRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/youtrack/YouTrackIntellisense";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/youtrack/YouTrackIntellisense";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeByStyleClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchHighlighting";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCompletion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fetch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeByStyleClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fetchHighlighting";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchCompletion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CompletionItem {
        private int completionStart;
        private int completionEnd;
        private int matchingStart;
        private int matchingEnd;
        private String prefix;
        private String suffix;
        private String description;
        private String option;

        @NotNull
        public TextRange getMatchRange() {
            TextRange textRange = TextRange.create((int)this.matchingStart, (int)this.matchingEnd);
            if (textRange == null) {
                CompletionItem.$$$reportNull$$$0(0);
            }
            return textRange;
        }

        @NotNull
        public TextRange getCompletionRange() {
            TextRange textRange = TextRange.create((int)this.completionStart, (int)this.completionEnd);
            if (textRange == null) {
                CompletionItem.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        @NotNull
        public String getDescription() {
            String string = this.description;
            if (string == null) {
                CompletionItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getSuffix() {
            String string = StringUtil.notNullize((String)this.suffix);
            if (string == null) {
                CompletionItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getPrefix() {
            String string = StringUtil.notNullize((String)this.prefix);
            if (string == null) {
                CompletionItem.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getOption() {
            String string = this.option;
            if (string == null) {
                CompletionItem.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/tasks/youtrack/YouTrackIntellisense$CompletionItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatchRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletionRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuffix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOption";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class HighlightRange {
        private int start;
        private int length;
        private String style;

        @NotNull
        public String getStyleClass() {
            String string = StringUtil.notNullize((String)this.style);
            if (string == null) {
                HighlightRange.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = TextRange.from((int)this.start, (int)this.length);
            if (textRange == null) {
                HighlightRange.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        @NotNull
        public TextAttributes getTextAttributes() {
            TextAttributes textAttributes = YouTrackIntellisense.getAttributeByStyleClass(this.style);
            if (textAttributes == null) {
                HighlightRange.$$$reportNull$$$0(2);
            }
            return textAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/tasks/youtrack/YouTrackIntellisense$HighlightRange";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStyleClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Response {
        private static final String DEFAULT_FIELDS = "styleRanges(length,start,style),suggestions(completionEnd,completionStart,description,matchingEnd,matchingStart,option,prefix,suffix)";
        private List<HighlightRange> styleRanges;
        private List<CompletionItem> suggestions;

        @NotNull
        public List<HighlightRange> getHighlightRanges() {
            List<HighlightRange> list = this.styleRanges;
            if (list == null) {
                Response.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public List<CompletionItem> getCompletionItems() {
            List<CompletionItem> list = this.suggestions;
            if (list == null) {
                Response.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/tasks/youtrack/YouTrackIntellisense$Response";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightRanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletionItems";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class SizeLimitedCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int myMaxSize;

        private SizeLimitedCache(int max) {
            super((int)((double)max / 0.75) + 1, true);
            this.myMaxSize = max;
        }

        protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
            return this.size() > this.myMaxSize;
        }
    }
}

