/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.gitlab.GitlabTask;
import com.intellij.tasks.gitlab.model.GitlabIssue;
import com.intellij.tasks.gitlab.model.GitlabProject;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.TaskResponseUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Tag(value="Gitlab")
public class GitlabRepository
extends NewBaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(GitlabRepository.class);
    @NonNls
    private static final String TOKEN_HEADER = "PRIVATE-TOKEN";
    private static final Pattern ID_PATTERN = Pattern.compile("\\d+");
    private static final Gson GSON = TaskGsonUtil.createDefaultBuilder().create();
    private static final TypeToken<List<GitlabProject>> LIST_OF_PROJECTS_TYPE = new TypeToken<List<GitlabProject>>(){};
    private static final TypeToken<List<GitlabIssue>> LIST_OF_ISSUES_TYPE = new TypeToken<List<GitlabIssue>>(){};
    public static final GitlabProject UNSPECIFIED_PROJECT = GitlabRepository.createUnspecifiedProject();
    private GitlabProject myCurrentProject;
    private List<GitlabProject> myProjects = null;
    private ApiVersion myApiVersion = null;

    @NotNull
    private static GitlabProject createUnspecifiedProject() {
        GitlabProject unspecified = new GitlabProject(){

            @Override
            public String getName() {
                return "-- all issues created by you --";
            }
        };
        unspecified.setId(-1);
        GitlabProject gitlabProject = unspecified;
        if (gitlabProject == null) {
            GitlabRepository.$$$reportNull$$$0(0);
        }
        return gitlabProject;
    }

    public GitlabRepository() {
    }

    public GitlabRepository(TaskRepositoryType type) {
        super(type);
    }

    public GitlabRepository(GitlabRepository other) {
        super(other);
        this.myCurrentProject = other.myCurrentProject;
        this.myApiVersion = other.myApiVersion;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GitlabRepository repository = (GitlabRepository)((Object)o);
        if (!Comparing.equal((Object)this.myCurrentProject, (Object)repository.myCurrentProject)) {
            return false;
        }
        return Comparing.equal((Object)((Object)this.myApiVersion), (Object)((Object)repository.myApiVersion));
    }

    @NotNull
    public GitlabRepository clone() {
        return new GitlabRepository(this);
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        List<GitlabIssue> issues = this.fetchIssues(offset / limit + 1, limit, !withClosed);
        return (Task[])ContainerUtil.map2Array(issues, GitlabTask.class, issue -> new GitlabTask(this, (GitlabIssue)issue));
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            GitlabRepository.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet()){

            @Override
            protected void test() throws Exception {
                this.myCurrentRequest = GitlabRepository.this.getApiVersionRequest();
                GitlabRepository.this.myApiVersion = GitlabRepository.this.fetchApiVersion((HttpGet)this.myCurrentRequest);
                this.myCurrentRequest = new HttpGet(GitlabRepository.this.getIssuesUrl());
                super.test();
            }
        };
    }

    @NotNull
    public List<GitlabProject> fetchProjects() throws Exception {
        this.ensureApiVersionDiscovered();
        TaskResponseUtil.GsonMultipleObjectsDeserializer<GitlabProject> handler = new TaskResponseUtil.GsonMultipleObjectsDeserializer<GitlabProject>(GSON, LIST_OF_PROJECTS_TYPE);
        String projectUrl = this.getRestApiUrl("projects");
        ArrayList<GitlabProject> result = new ArrayList<GitlabProject>();
        int pageNum = 1;
        while (true) {
            List page;
            URIBuilder paginatedProjectsUrl = new URIBuilder(projectUrl).addParameter("page", String.valueOf(pageNum)).addParameter("per_page", "30");
            if (this.myApiVersion == ApiVersion.V4) {
                paginatedProjectsUrl.addParameter("membership", "true");
            }
            if ((page = (List)this.getHttpClient().execute((HttpUriRequest)new HttpGet(paginatedProjectsUrl.build()), handler)).isEmpty()) break;
            result.addAll(page);
            ++pageNum;
        }
        this.myProjects = result;
        List<GitlabProject> list = Collections.unmodifiableList(this.myProjects);
        if (list == null) {
            GitlabRepository.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public GitlabProject fetchProject(int id) throws Exception {
        this.ensureApiVersionDiscovered();
        HttpGet request = new HttpGet(this.getRestApiUrl("project", id));
        GitlabProject gitlabProject = (GitlabProject)this.getHttpClient().execute((HttpUriRequest)request, new TaskResponseUtil.GsonSingleObjectDeserializer<GitlabProject>(GSON, GitlabProject.class));
        if (gitlabProject == null) {
            GitlabRepository.$$$reportNull$$$0(3);
        }
        return gitlabProject;
    }

    @NotNull
    public List<GitlabIssue> fetchIssues(int pageNumber, int pageSize, boolean openedOnly) throws Exception {
        this.ensureApiVersionDiscovered();
        this.ensureProjectsDiscovered();
        URIBuilder uriBuilder = new URIBuilder(this.getIssuesUrl()).addParameter("page", String.valueOf(pageNumber)).addParameter("per_page", String.valueOf(pageSize)).addParameter("order_by", "updated_at");
        if (openedOnly) {
            uriBuilder.addParameter("state", "opened");
        }
        TaskResponseUtil.GsonMultipleObjectsDeserializer<GitlabIssue> handler = new TaskResponseUtil.GsonMultipleObjectsDeserializer<GitlabIssue>(GSON, LIST_OF_ISSUES_TYPE);
        List list = (List)this.getHttpClient().execute((HttpUriRequest)new HttpGet(uriBuilder.build()), handler);
        if (list == null) {
            GitlabRepository.$$$reportNull$$$0(4);
        }
        return list;
    }

    private String getIssuesUrl() {
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            return this.getRestApiUrl("projects", this.myCurrentProject.getId(), "issues");
        }
        return this.getRestApiUrl("issues");
    }

    @Nullable
    public GitlabIssue fetchIssue(int projectId, int issueId) throws Exception {
        this.ensureApiVersionDiscovered();
        this.ensureProjectsDiscovered();
        HttpGet request = new HttpGet(this.getRestApiUrl("projects", projectId, "issues", issueId));
        TaskResponseUtil.GsonSingleObjectDeserializer<GitlabIssue> handler = new TaskResponseUtil.GsonSingleObjectDeserializer<GitlabIssue>(GSON, GitlabIssue.class, true);
        return (GitlabIssue)this.getHttpClient().execute((HttpUriRequest)request, handler);
    }

    public String getPresentableName() {
        Object name = this.getUrl();
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            name = (String)name + "/" + this.myCurrentProject.getName();
        }
        return name;
    }

    @Nullable
    public String extractId(@NotNull String taskName) {
        if (taskName == null) {
            GitlabRepository.$$$reportNull$$$0(5);
        }
        return ID_PATTERN.matcher(taskName).matches() ? taskName : null;
    }

    public boolean isConfigured() {
        return super.isConfigured() && !this.myPassword.isEmpty();
    }

    @Override
    @NotNull
    public String getRestApiPathPrefix() {
        String string = "/api/" + (this.myApiVersion == ApiVersion.V4 ? "v4" : "v3") + "/";
        if (string == null) {
            GitlabRepository.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    protected HttpRequestInterceptor createRequestInterceptor() {
        return new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader(GitlabRepository.TOKEN_HEADER, GitlabRepository.this.myPassword);
            }
        };
    }

    public void setCurrentProject(@Nullable GitlabProject project) {
        this.myCurrentProject = project != null && project.getId() == -1 ? UNSPECIFIED_PROJECT : project;
    }

    public GitlabProject getCurrentProject() {
        return this.myCurrentProject;
    }

    @NotNull
    public List<GitlabProject> getProjects() {
        try {
            this.ensureProjectsDiscovered();
        }
        catch (Exception ignored) {
            List<GitlabProject> list = Collections.emptyList();
            if (list == null) {
                GitlabRepository.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<GitlabProject> list = Collections.unmodifiableList(this.myProjects);
        if (list == null) {
            GitlabRepository.$$$reportNull$$$0(8);
        }
        return list;
    }

    private void ensureProjectsDiscovered() throws Exception {
        if (this.myProjects == null) {
            this.fetchProjects();
        }
    }

    private void ensureApiVersionDiscovered() throws Exception {
        if (this.myApiVersion == null) {
            this.myApiVersion = this.fetchApiVersion(this.getApiVersionRequest());
        }
    }

    @NotNull
    private ApiVersion fetchApiVersion(@NotNull HttpGet request) throws IOException {
        HttpResponse response;
        if (request == null) {
            GitlabRepository.$$$reportNull$$$0(9);
        }
        ApiVersion version = (response = this.getHttpClient().execute((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 ? ApiVersion.V4 : ApiVersion.V3;
        LOG.debug("Version " + version + " of Gitlab API is discovered at " + this.getUrl());
        ApiVersion apiVersion = version;
        if (apiVersion == null) {
            GitlabRepository.$$$reportNull$$$0(10);
        }
        return apiVersion;
    }

    @NotNull
    private HttpGet getApiVersionRequest() {
        return new HttpGet(StringUtil.trimEnd((String)this.getUrl(), (String)"/") + "/api/v4/version");
    }

    @Transient
    @TestOnly
    public void setProjects(@NotNull List<GitlabProject> projects) {
        if (projects == null) {
            GitlabRepository.$$$reportNull$$$0(11);
        }
        this.myProjects = projects;
    }

    protected int getFeatures() {
        int features = super.getFeatures();
        if (this.myApiVersion == ApiVersion.V4) {
            return features | 4;
        }
        return features;
    }

    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        if (task == null) {
            GitlabRepository.$$$reportNull$$$0(12);
        }
        if (timeSpent == null) {
            GitlabRepository.$$$reportNull$$$0(13);
        }
        if (comment == null) {
            GitlabRepository.$$$reportNull$$$0(14);
        }
        this.ensureApiVersionDiscovered();
        Pattern issueURLPattern = Pattern.compile("https?://.*/([^/]*/[^/]*)/issues/\\d+");
        String issueURL = task.getIssueUrl();
        if (issueURL == null) {
            throw new IllegalArgumentException("A GitLab-bound LocalTask should not have a null issue url.");
        }
        Matcher issueURLMatcher = issueURLPattern.matcher(issueURL);
        if (!issueURLMatcher.matches()) {
            throw new IllegalStateException("Could not find project namespace from issue URL.");
        }
        String projectNamespace = issueURLMatcher.group(1);
        URI timeUpdateURI = new URIBuilder(this.getRestApiUrl("projects", projectNamespace, "issues", task.getNumber(), "add_spent_time")).addParameter("duration", timeSpent).build();
        LOG.debug("Sending POST request to " + timeUpdateURI);
        HttpPost timeUpdateRequest = new HttpPost(timeUpdateURI);
        HttpResponse timeUpdateResponse = this.getHttpClient().execute((HttpUriRequest)timeUpdateRequest);
        if (timeUpdateResponse.getStatusLine().getStatusCode() != 201) {
            LOG.error("Failed adding time spent to GitLab. Received error code: " + timeUpdateResponse.getStatusLine().getStatusCode());
            throw new RuntimeException("Could not add time to the remote task.");
        }
        if (!StringUtil.isEmptyOrSpaces((String)comment)) {
            URI addCommentURI = new URIBuilder(this.getRestApiUrl("projects", projectNamespace, "issues", task.getNumber(), "notes")).addParameter("body", comment).build();
            HttpPost addCommentRequest = new HttpPost(addCommentURI);
            HttpResponse addCommentResponse = this.getHttpClient().execute((HttpUriRequest)addCommentRequest);
            if (addCommentResponse.getStatusLine().getStatusCode() != 201) {
                LOG.error("Failed adding a comment to GitLab. Received error code: " + addCommentResponse.getStatusLine().getStatusCode());
                throw new RuntimeException("Could not add a comment to the remote task.");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/gitlab/GitlabRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeSpent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnspecifiedProject";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/gitlab/GitlabRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchProjects";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchIssues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRestApiPathPrefix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjects";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchApiVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractId";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fetchApiVersion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setProjects";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateTimeSpent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum ApiVersion {
        V3,
        V4;

    }
}

