/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.binding.BindControl;
import com.intellij.openapi.options.binding.ControlBinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.actions.AnalyzeTaskStacktraceAction;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.impl.TaskStateCombo;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.ui.TaskDialogPanel;
import com.intellij.tasks.ui.TaskDialogPanelProvider;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenTaskDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(OpenTaskDialog.class);
    private static final String UPDATE_STATE_ENABLED = "tasks.open.task.update.state.enabled";
    private JPanel myPanel;
    @BindControl(value="clearContext", instant=true)
    private JCheckBox myClearContext;
    private JBCheckBox myUpdateState;
    private TaskStateCombo myTaskStateCombo;
    private JPanel myAdditionalPanel;
    private JBTextField myNameField;
    private final Project myProject;
    private final LocalTaskImpl myTask;
    private final List<TaskDialogPanel> myPanels;

    public OpenTaskDialog(final @NotNull Project project, @NotNull Task task) {
        if (project == null) {
            OpenTaskDialog.$$$reportNull$$$0(0);
        }
        if (task == null) {
            OpenTaskDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myTask = new LocalTaskImpl(task);
        this.myTaskStateCombo.setProject(this.myProject);
        this.myTaskStateCombo.setTask((Task)this.myTask);
        this.setTitle(TaskBundle.message((String)"dialog.title.open.task", (Object[])new Object[0]));
        this.myNameField.setText(TaskUtil.getTrimmedSummary((Task)task));
        this.myNameField.setEnabled(!task.isIssue());
        TaskManagerImpl taskManager = (TaskManagerImpl)TaskManager.getManager((Project)this.myProject);
        ControlBinder binder = new ControlBinder((Object)taskManager.getState());
        binder.bindAnnotations((Object)this);
        binder.reset();
        if (!TaskStateCombo.stateUpdatesSupportedFor(task)) {
            this.myUpdateState.setVisible(false);
            this.myTaskStateCombo.setVisible(false);
        }
        boolean stateUpdatesEnabled = PropertiesComponent.getInstance((Project)project).getBoolean(UPDATE_STATE_ENABLED, false);
        this.myUpdateState.setSelected(stateUpdatesEnabled);
        this.myUpdateState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = OpenTaskDialog.this.myUpdateState.isSelected();
                PropertiesComponent.getInstance((Project)project).setValue(OpenTaskDialog.UPDATE_STATE_ENABLED, String.valueOf(selected));
                OpenTaskDialog.this.updateFields();
                if (selected) {
                    OpenTaskDialog.this.myTaskStateCombo.scheduleUpdateOnce();
                }
            }
        });
        TaskManagerImpl.Config state = taskManager.getState();
        this.myClearContext.setSelected(state.clearContext);
        this.updateFields();
        if (this.myUpdateState.isSelected()) {
            this.myTaskStateCombo.scheduleUpdateOnce();
        }
        this.myAdditionalPanel.setLayout(new BoxLayout(this.myAdditionalPanel, 1));
        this.myPanels = TaskDialogPanelProvider.getOpenTaskPanels((Project)project, (LocalTask)this.myTask);
        for (TaskDialogPanel panel : this.myPanels) {
            this.myAdditionalPanel.add(panel.getPanel());
        }
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                LocalTaskImpl oldTask = new LocalTaskImpl((Task)OpenTaskDialog.this.myTask);
                OpenTaskDialog.this.myTask.setSummary(OpenTaskDialog.this.myNameField.getText());
                for (TaskDialogPanel panel : OpenTaskDialog.this.myPanels) {
                    panel.taskNameChanged((Task)oldTask, (Task)OpenTaskDialog.this.myTask);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/actions/OpenTaskDialog$2", "textChanged"));
            }
        });
        this.init();
    }

    private void updateFields() {
        this.myTaskStateCombo.setEnabled(this.myUpdateState.isSelected());
    }

    protected void doOKAction() {
        this.createTask();
        super.doOKAction();
    }

    public void createTask() {
        TaskManagerImpl taskManager = (TaskManagerImpl)TaskManager.getManager((Project)this.myProject);
        if (this.myUpdateState.isSelected()) {
            CustomTaskState taskState = this.myTaskStateCombo.getSelectedState();
            TaskRepository repository = this.myTask.getRepository();
            if (repository != null && taskState != null) {
                try {
                    repository.setTaskState((Task)this.myTask, taskState);
                    repository.setPreferredOpenTaskState(taskState);
                }
                catch (Exception ex) {
                    Messages.showErrorDialog((Project)this.myProject, (String)ex.getMessage(), (String)TaskBundle.message((String)"dialog.title.cannot.set.state.for.issue", (Object[])new Object[0]));
                    LOG.warn((Throwable)ex);
                }
            }
        }
        for (TaskDialogPanel panel : this.myPanels) {
            panel.commit();
        }
        taskManager.activateTask((Task)this.myTask, this.isClearContext(), true);
        if (this.myTask.getType() == TaskType.EXCEPTION && AnalyzeTaskStacktraceAction.hasTexts((Task)this.myTask)) {
            AnalyzeTaskStacktraceAction.analyzeStacktrace((Task)this.myTask, this.myProject);
        }
    }

    private boolean isClearContext() {
        return this.myClearContext.isSelected();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "SimpleOpenTaskDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myNameField.getText().trim().isEmpty()) {
            return this.myNameField;
        }
        for (TaskDialogPanel panel : this.myPanels) {
            JComponent component = panel.getPreferredFocusedComponent();
            if (component == null) continue;
            return component;
        }
        if (this.myTaskStateCombo.isVisible() && this.myTaskStateCombo.isEnabled()) {
            return this.myTaskStateCombo.getComboBox();
        }
        return null;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String taskName = this.myNameField.getText().trim();
        if (taskName.isEmpty()) {
            return new ValidationInfo(TaskBundle.message((String)"dialog.message.task.name.should.not.be.empty", (Object[])new Object[0]), (JComponent)this.myNameField);
        }
        for (TaskDialogPanel panel : this.myPanels) {
            ValidationInfo validate = panel.validate();
            if (validate == null) continue;
            return validate;
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myTaskStateCombo = new TaskStateCombo(){

            @Override
            @Nullable
            protected CustomTaskState getPreferredState(@NotNull TaskRepository repository, @NotNull Collection<CustomTaskState> available) {
                if (repository == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (available == null) {
                    3.$$$reportNull$$$0(1);
                }
                return repository.getPreferredOpenTaskState();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "repository";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "available";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/tasks/actions/OpenTaskDialog$3";
                objectArray[2] = "getPreferredState";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "task";
                break;
            }
        }
        objectArray[1] = "com/intellij/tasks/actions/OpenTaskDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBTextField jBTextField;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(5, 0, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/TaskBundle", OpenTaskDialog.class).getString("name"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jBTextField = new JBTextField();
        jPanel3.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myAdditionalPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        TaskStateCombo taskStateCombo = this.myTaskStateCombo;
        jPanel4.add((Component)taskStateCombo, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myUpdateState = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/TaskBundle", OpenTaskDialog.class).getString("update.issue.state1"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(149, 24), null));
        this.myClearContext = jCheckBox = new JCheckBox();
        jCheckBox.setFocusable(true);
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/TaskBundle", OpenTaskDialog.class).getString("clear.current.context"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(149, 24), null));
        jLabel.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

