/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.DataProviderFactory;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.ComponentLayouter;
import com.intellij.openapi.graph.layout.CompositeLayoutStage;
import com.intellij.openapi.graph.layout.EdgeBundleDescriptor;
import com.intellij.openapi.graph.layout.EdgeBundling;
import com.intellij.openapi.graph.layout.LayoutOrientation;
import com.intellij.openapi.graph.layout.LayoutStage;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.PortConstraintKeys;
import com.intellij.openapi.graph.layout.circular.CircularLayouter;
import com.intellij.openapi.graph.layout.circular.SingleCycleLayouter;
import com.intellij.openapi.graph.layout.genealogy.FamilyTreeLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicLayouter;
import com.intellij.openapi.graph.layout.hierarchic.IncrementalHierarchicLayouter;
import com.intellij.openapi.graph.layout.hierarchic.incremental.SimplexNodePlacer;
import com.intellij.openapi.graph.layout.organic.SmartOrganicLayouter;
import com.intellij.openapi.graph.layout.orthogonal.CompactOrthogonalLayouter;
import com.intellij.openapi.graph.layout.orthogonal.DirectedOrthogonalLayouter;
import com.intellij.openapi.graph.layout.orthogonal.OrthogonalLayouter;
import com.intellij.openapi.graph.layout.radial.RadialLayouter;
import com.intellij.openapi.graph.layout.random.RandomLayouter;
import com.intellij.openapi.graph.layout.router.BusRouter;
import com.intellij.openapi.graph.layout.router.ChannelEdgeRouter;
import com.intellij.openapi.graph.layout.router.OrganicEdgeRouter;
import com.intellij.openapi.graph.layout.router.polyline.EdgeRouter;
import com.intellij.openapi.graph.layout.seriesparallel.SeriesParallelLayouter;
import com.intellij.openapi.graph.layout.tree.ARTreeLayouter;
import com.intellij.openapi.graph.layout.tree.BalloonLayouter;
import com.intellij.openapi.graph.layout.tree.GenericTreeLayouter;
import com.intellij.openapi.graph.layout.tree.HVTreeLayouter;
import com.intellij.openapi.graph.layout.tree.TreeReductionStage;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public final class GraphSettings {
    @NotNull
    @NonNls
    private static final String DO_MERGE_EDGES_REGKEY = "graphs.merge.edges";
    @NotNull
    private final CompactOrthogonalLayouter myCompactOrthogonalLayouter = GraphManager.getGraphManager().createCompactOrthogonalLayouter();
    @NotNull
    private final ComponentLayouter myComponentLayouter = GraphManager.getGraphManager().createComponentLayouter();
    @NotNull
    private final DirectedOrthogonalLayouter myDirectedOrthogonalLayouter = GraphManager.getGraphManager().createDirectedOrthogonalLayouter();
    @NotNull
    private final HierarchicGroupLayouter myGroupLayouter = GraphManager.getGraphManager().createHierarchicGroupLayouter();
    @NotNull
    private final IncrementalHierarchicLayouter myHierarchicLayouter = GraphManager.getGraphManager().createIncrementalHierarchicLayouter();
    @NotNull
    private final ChannelEdgeRouter myChannelLayouter = GraphManager.getGraphManager().createChannelEdgeRouter();
    @NotNull
    private final SeriesParallelLayouter mySeriesParallelLayouter = GraphManager.getGraphManager().createSeriesParallelLayouter();
    @NotNull
    private final CircularLayouter myCircularLayouter = GraphManager.getGraphManager().createCircularLayouter();
    @NotNull
    private final CircularLayouter myEdgeBundledCircularLayouter = GraphManager.getGraphManager().createCircularLayouter();
    @NotNull
    private final RadialLayouter myRadialLayouter = GraphManager.getGraphManager().createRadialLayouter();
    @NotNull
    private final RadialLayouter myEdgeBundledRadialLayouter = GraphManager.getGraphManager().createRadialLayouter();
    @NotNull
    private final SingleCycleLayouter mySingleCycleLayouter = GraphManager.getGraphManager().createSingleCycleLayouter();
    @NotNull
    private final ARTreeLayouter myARTreeLayouter = GraphManager.getGraphManager().createARTreeLayouter();
    @NotNull
    private final BalloonLayouter myBalloonLayouter = GraphManager.getGraphManager().createBalloonLayouter();
    @NotNull
    private final BalloonLayouter myEdgeBundledBalloonLayouter = GraphManager.getGraphManager().createBalloonLayouter();
    @NotNull
    private final FamilyTreeLayouter myFamilyTreeLayouter = GraphManager.getGraphManager().createFamilyTreeLayouter();
    @NotNull
    private final GenericTreeLayouter myGenericTreeLayouter = GraphManager.getGraphManager().createGenericTreeLayouter();
    @NotNull
    private final HVTreeLayouter myHVTreeLayouter = GraphManager.getGraphManager().createHVTreeLayouter();
    @NotNull
    private final RandomLayouter myRandomLayouter = GraphManager.getGraphManager().createRandomLayouter();
    @NotNull
    private final SmartOrganicLayouter myOrganicLayouter = GraphManager.getGraphManager().createSmartOrganicLayouter();
    @NotNull
    private final OrganicEdgeRouter myEdgeBundledOrganicLayouter = GraphManager.getGraphManager().createOrganicEdgeRouter();
    @NotNull
    private final EdgeRouter myOrthogonalEdgeRouter = GraphManager.getGraphManager().createEdgeRouter();
    @NotNull
    private final BusRouter myBusOrthogonalEdgeRouter = GraphManager.getGraphManager().createBusRouter();
    @NotNull
    private final OrganicEdgeRouter myOrganicEdgeRouter = GraphManager.getGraphManager().createOrganicEdgeRouter();
    @NotNull
    private volatile Layouter myCurrentLayouter;
    private volatile boolean myFitContentAfterLayout = true;
    @NotNull
    public static final GraphSettings DEFAULT = new GraphSettings();

    @NotNull
    public static GraphSettings create() {
        return new GraphSettings();
    }

    private GraphSettings() {
        GraphSettings.setupCompactOrthogonalLayouter(this.myCompactOrthogonalLayouter);
        GraphSettings.setupComponentLayouter(this.myComponentLayouter);
        GraphSettings.setupDirectedOrthogonalLayouter(this.myDirectedOrthogonalLayouter);
        GraphSettings.setupGroupLayouter(this.myGroupLayouter);
        GraphSettings.setupHierarchicLayouter(this.myHierarchicLayouter);
        GraphSettings.setupChannelLayouter(this.myChannelLayouter);
        GraphSettings.setupSeriesParallelLayouter(this.mySeriesParallelLayouter);
        GraphSettings.setupCircularLayouter(this.myCircularLayouter);
        GraphSettings.setupEdgeBundledCircularLayouter(this.myEdgeBundledCircularLayouter);
        GraphSettings.setupRadialLayouter(this.myRadialLayouter);
        GraphSettings.setupEdgeBundledRadialLayouter(this.myEdgeBundledRadialLayouter);
        GraphSettings.setupSingleCycleLayouter(this.mySingleCycleLayouter);
        GraphSettings.setupARTreeLayouter(this.myARTreeLayouter);
        GraphSettings.setupBalloonLayouter(this.myBalloonLayouter);
        GraphSettings.setupEdgeBundledBalloonLayouter(this.myEdgeBundledBalloonLayouter);
        GraphSettings.setupFamilyTreeLayouter(this.myFamilyTreeLayouter);
        GraphSettings.setupGenericTreeLayouter(this.myGenericTreeLayouter);
        GraphSettings.setupHVTreeLayouter(this.myHVTreeLayouter);
        GraphSettings.setupRandomLayouter(this.myRandomLayouter);
        GraphSettings.setupOrganicLayouter(this.myOrganicLayouter);
        GraphSettings.setupEdgeBundledOrganicLayouter(this.myEdgeBundledOrganicLayouter);
        GraphSettings.setupOrthogonalEdgeRouter(this.myOrthogonalEdgeRouter);
        GraphSettings.setupBusOrthogonalEdgeRouter(this.myBusOrthogonalEdgeRouter);
        GraphSettings.setupOrganicEdgeRouter(this.myOrganicEdgeRouter);
        this.myCurrentLayouter = this.myGroupLayouter;
    }

    @NotNull
    public Layouter getCurrentLayouter() {
        Layouter layouter = this.myCurrentLayouter;
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(0);
        }
        return layouter;
    }

    public void setCurrentLayouter(@NotNull Layouter currentLayouter) {
        if (currentLayouter == null) {
            GraphSettings.$$$reportNull$$$0(1);
        }
        this.myCurrentLayouter = currentLayouter;
    }

    public boolean isFitContentAfterLayout() {
        return this.myFitContentAfterLayout;
    }

    public void setFitContentAfterLayout(boolean fitContentAfterLayout) {
        this.myFitContentAfterLayout = fitContentAfterLayout;
    }

    public static void setupDataProvidersForEdgesMerging(final @NotNull Graph2D graph) {
        if (graph == null) {
            GraphSettings.$$$reportNull$$$0(2);
        }
        DataProviderFactory.ProviderAdapter directedDP = new DataProviderFactory.ProviderAdapter(){

            @Override
            public boolean getBool(Object obj) {
                return graph.getRealizer((Edge)obj).getTargetArrow() != Arrow.NONE;
            }
        };
        graph.addDataProvider(DirectedOrthogonalLayouter.DIRECTED_EDGE_DPKEY, directedDP);
        if (Registry.is((String)DO_MERGE_EDGES_REGKEY)) {
            DataProviderFactory.ProviderAdapter targetGroupDP = new DataProviderFactory.ProviderAdapter(){

                @Override
                public Object get(Object obj) {
                    Edge edge = (Edge)obj;
                    EdgeRealizer er = graph.getRealizer(edge);
                    if (er.getTargetArrow() == Arrow.NONE) {
                        return null;
                    }
                    return GraphManager.getGraphManager().createBusDescriptor(new EdgeMergeIdentity(edge.target(), er.getLineType(), er.getLineColor(), er.getLabel()));
                }
            };
            graph.addDataProvider(PortConstraintKeys.TARGET_GROUPID_KEY, targetGroupDP);
            graph.addDataProvider(BusRouter.EDGE_DESCRIPTOR_DPKEY, targetGroupDP);
        }
    }

    public static boolean doesImplyOrthogonalEdgeRouting(@NotNull Layouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(3);
        }
        return layouter instanceof CompactOrthogonalLayouter || layouter instanceof ComponentLayouter || layouter instanceof DirectedOrthogonalLayouter || layouter instanceof HierarchicGroupLayouter || layouter instanceof IncrementalHierarchicLayouter || layouter instanceof ChannelEdgeRouter || layouter instanceof SeriesParallelLayouter || layouter instanceof ARTreeLayouter || layouter instanceof FamilyTreeLayouter || layouter instanceof HVTreeLayouter;
    }

    public static boolean doesImplyOrganicEdgeRouting(@NotNull Layouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(4);
        }
        if (layouter instanceof OrganicEdgeRouter || layouter instanceof SmartOrganicLayouter || layouter instanceof RandomLayouter || layouter instanceof SingleCycleLayouter) {
            return true;
        }
        if (layouter instanceof CircularLayouter) {
            return !((CircularLayouter)layouter).getEdgeBundling().getDefaultBundleDescriptor().isBundled();
        }
        if (layouter instanceof RadialLayouter) {
            return !((RadialLayouter)layouter).getEdgeBundling().getDefaultBundleDescriptor().isBundled();
        }
        return false;
    }

    @Nullable
    public Layouter getEdgeRouterForLayouter(@NotNull Layouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(5);
        }
        if (GraphSettings.doesImplyOrthogonalEdgeRouting(layouter)) {
            return this.myBusOrthogonalEdgeRouter;
        }
        if (GraphSettings.doesImplyOrganicEdgeRouting(layouter)) {
            return this.myOrganicEdgeRouter;
        }
        return null;
    }

    public static void setupDataProvidersForEdgeRouter(@NotNull Layouter router, @NotNull GraphBuilder<?, ?> builder) {
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            GraphSettings.$$$reportNull$$$0(7);
        }
        if (router instanceof EdgeRouter) {
            GraphSettings.setupDataProvidersForOrthogonalEdgeRouter((EdgeRouter)router, builder);
            return;
        }
        if (router instanceof BusRouter) {
            GraphSettings.setupDataProvidersForBusOrthogonalEdgeRouter((BusRouter)router, builder);
            return;
        }
        if (router instanceof OrganicEdgeRouter) {
            GraphSettings.setupDataProvidersForOrganicEdgeRouter((OrganicEdgeRouter)router, builder);
            return;
        }
        Logger.getInstance(GraphSettings.class).error("Unknown edge router");
    }

    public static void removeDataProvidersForEdgeRouter(@NotNull Layouter router, @NotNull GraphBuilder<?, ?> builder) {
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            GraphSettings.$$$reportNull$$$0(9);
        }
        if (router instanceof EdgeRouter) {
            GraphSettings.removeDataProvidersForOrthogonalEdgeRouter((EdgeRouter)router, builder);
            return;
        }
        if (router instanceof BusRouter) {
            GraphSettings.removeDataProvidersForBusOrthogonalEdgeRouter((BusRouter)router, builder);
            return;
        }
        if (router instanceof OrganicEdgeRouter) {
            GraphSettings.removeDataProvidersForOrganicEdgeRouter((OrganicEdgeRouter)router, builder);
            return;
        }
        Logger.getInstance(GraphSettings.class).error("Unknown edge router");
    }

    private static void setupDataProvidersForOrthogonalEdgeRouter(@NotNull EdgeRouter router, @NotNull GraphBuilder<?, ?> builder) {
        Graph2D graph;
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            GraphSettings.$$$reportNull$$$0(11);
        }
        if ((graph = builder.getGraph()).selectedNodes().ok()) {
            router.setSphereOfAction(EdgeRouter.ROUTE_EDGES_AT_SELECTED_NODES);
            final HashSet<Node> selectedNodes = new HashSet<Node>(GraphViewUtil.getSelectedNodes(graph));
            graph.addDataProvider(router.getSelectedNodesDpKey(), new DataProviderFactory.ProviderAdapter(){

                @Override
                public boolean getBool(Object dataHolder) {
                    return selectedNodes.contains(dataHolder);
                }
            });
        } else if (graph.selectedEdges().ok()) {
            router.setSphereOfAction(EdgeRouter.ROUTE_SELECTED_EDGES);
            final HashSet<Edge> selectedEdges = new HashSet<Edge>(GraphViewUtil.getSelectedEdges(graph));
            graph.addDataProvider(router.getSelectedEdgesDpKey(), new DataProviderFactory.ProviderAdapter(){

                @Override
                public boolean getBool(Object dataHolder) {
                    return selectedEdges.contains(dataHolder);
                }
            });
        } else {
            router.setSphereOfAction(EdgeRouter.ROUTE_ALL_EDGES);
        }
    }

    private static void setupDataProvidersForBusOrthogonalEdgeRouter(@NotNull BusRouter router, @NotNull GraphBuilder<?, ?> builder) {
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            GraphSettings.$$$reportNull$$$0(13);
        }
        Graph2D graph = builder.getGraph();
        final HashSet<Edge> selectedEdges = new HashSet<Edge>();
        if (graph.selectedNodes().ok()) {
            router.setScope(BusRouter.SCOPE_SUBSET);
            for (Edge edge : graph.getEdgeArray()) {
                if (!graph.isSelected(edge.source()) && !graph.isSelected(edge.target())) continue;
                selectedEdges.add(edge);
            }
        } else if (graph.selectedEdges().ok()) {
            router.setScope(BusRouter.SCOPE_SUBSET);
            ContainerUtil.addAll(selectedEdges, GraphViewUtil.getSelectedEdges(graph));
        } else {
            router.setScope(BusRouter.SCOPE_ALL);
        }
        if (!selectedEdges.isEmpty()) {
            graph.addDataProvider(router.getSelectedEdgesDpKey(), new DataProviderFactory.ProviderAdapter(){

                @Override
                public boolean getBool(Object dataHolder) {
                    return selectedEdges.contains(dataHolder);
                }
            });
        }
    }

    private static void setupDataProvidersForOrganicEdgeRouter(@NotNull OrganicEdgeRouter router, @NotNull GraphBuilder<?, ?> builder) {
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(14);
        }
        if (builder == null) {
            GraphSettings.$$$reportNull$$$0(15);
        }
        Graph2D graph = builder.getGraph();
        final HashSet<Edge> selectedEdges = new HashSet<Edge>();
        if (graph.selectedNodes().ok()) {
            for (Edge edge : graph.getEdgeArray()) {
                if (!graph.isSelected(edge.source()) && !graph.isSelected(edge.target())) continue;
                selectedEdges.add(edge);
            }
        } else if (graph.selectedEdges().ok()) {
            ContainerUtil.addAll(selectedEdges, GraphViewUtil.getSelectedEdges(graph));
        }
        if (!selectedEdges.isEmpty()) {
            graph.addDataProvider(OrganicEdgeRouter.ROUTE_EDGE_DPKEY, new DataProviderFactory.ProviderAdapter(){

                @Override
                public boolean getBool(Object dataHolder) {
                    return selectedEdges.contains(dataHolder);
                }
            });
        }
    }

    private static void removeDataProvidersForOrthogonalEdgeRouter(@NotNull EdgeRouter router, @NotNull GraphBuilder<?, ?> builder) {
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(16);
        }
        if (builder == null) {
            GraphSettings.$$$reportNull$$$0(17);
        }
        Graph2D graph = builder.getGraph();
        graph.removeDataProvider(router.getSelectedNodesDpKey());
        graph.removeDataProvider(router.getSelectedEdgesDpKey());
    }

    private static void removeDataProvidersForBusOrthogonalEdgeRouter(@NotNull BusRouter router, @NotNull GraphBuilder<?, ?> builder) {
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(18);
        }
        if (builder == null) {
            GraphSettings.$$$reportNull$$$0(19);
        }
        builder.getGraph().removeDataProvider(router.getSelectedEdgesDpKey());
    }

    private static void removeDataProvidersForOrganicEdgeRouter(@NotNull OrganicEdgeRouter router, @NotNull GraphBuilder<?, ?> builder) {
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(20);
        }
        if (builder == null) {
            GraphSettings.$$$reportNull$$$0(21);
        }
        builder.getGraph().removeDataProvider(OrganicEdgeRouter.ROUTE_EDGE_DPKEY);
    }

    @NotNull
    public static CompactOrthogonalLayouter setupCompactOrthogonalLayouter(@NotNull CompactOrthogonalLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(22);
        }
        CompactOrthogonalLayouter compactOrthogonalLayouter = layouter;
        if (compactOrthogonalLayouter == null) {
            GraphSettings.$$$reportNull$$$0(23);
        }
        return compactOrthogonalLayouter;
    }

    @NotNull
    public static ComponentLayouter setupComponentLayouter(@NotNull ComponentLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(24);
        }
        ComponentLayouter componentLayouter = layouter;
        if (componentLayouter == null) {
            GraphSettings.$$$reportNull$$$0(25);
        }
        return componentLayouter;
    }

    @NotNull
    public static DirectedOrthogonalLayouter setupDirectedOrthogonalLayouter(@NotNull DirectedOrthogonalLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(26);
        }
        layouter.setGrid(20);
        layouter.setUsePostprocessing(true);
        layouter.setLayoutOrientation(LayoutOrientation.BOTTOM_TO_TOP);
        DirectedOrthogonalLayouter directedOrthogonalLayouter = layouter;
        if (directedOrthogonalLayouter == null) {
            GraphSettings.$$$reportNull$$$0(27);
        }
        return directedOrthogonalLayouter;
    }

    @NotNull
    public static HierarchicGroupLayouter setupGroupLayouter(@NotNull HierarchicGroupLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(28);
        }
        layouter.setOrientationLayouter(GraphManager.getGraphManager().createOrientationLayouter(LayoutOrientation.BOTTOM_TO_TOP));
        layouter.setMinimalNodeDistance(20.0);
        layouter.setMinimalLayerDistance(50.0);
        layouter.setRoutingStyle(HierarchicLayouter.ROUTE_ORTHOGONAL);
        HierarchicGroupLayouter hierarchicGroupLayouter = layouter;
        if (hierarchicGroupLayouter == null) {
            GraphSettings.$$$reportNull$$$0(29);
        }
        return hierarchicGroupLayouter;
    }

    @NotNull
    public static IncrementalHierarchicLayouter setupHierarchicLayouter(@NotNull IncrementalHierarchicLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(30);
        }
        layouter.setOrientationLayouter(GraphManager.getGraphManager().createOrientationLayouter(LayoutOrientation.BOTTOM_TO_TOP));
        layouter.setOrthogonallyRouted(true);
        layouter.setMinimumLayerDistance(50.0);
        layouter.getNodeLayoutDescriptor().setMinimumDistance(20.0);
        layouter.getEdgeLayoutDescriptor().setMinimumFirstSegmentLength(30.0);
        layouter.getEdgeLayoutDescriptor().setMinimumLastSegmentLength(30.0);
        ((SimplexNodePlacer)layouter.getNodePlacer()).setHorizontalCompactionEnabled(true);
        IncrementalHierarchicLayouter incrementalHierarchicLayouter = layouter;
        if (incrementalHierarchicLayouter == null) {
            GraphSettings.$$$reportNull$$$0(31);
        }
        return incrementalHierarchicLayouter;
    }

    @NotNull
    public static ChannelEdgeRouter setupChannelLayouter(@NotNull ChannelEdgeRouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(32);
        }
        OrthogonalLayouter orthogonalLayouter = GraphManager.getGraphManager().createOrthogonalLayouter();
        orthogonalLayouter.setGrid(20);
        orthogonalLayouter.setUseSpacePostprocessing(true);
        orthogonalLayouter.setUseCrossingPostprocessing(true);
        layouter.setCoreLayouter(orthogonalLayouter);
        ChannelEdgeRouter channelEdgeRouter = layouter;
        if (channelEdgeRouter == null) {
            GraphSettings.$$$reportNull$$$0(33);
        }
        return channelEdgeRouter;
    }

    @NotNull
    public static SeriesParallelLayouter setupSeriesParallelLayouter(@NotNull SeriesParallelLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(34);
        }
        SeriesParallelLayouter seriesParallelLayouter = layouter;
        if (seriesParallelLayouter == null) {
            GraphSettings.$$$reportNull$$$0(35);
        }
        return seriesParallelLayouter;
    }

    @NotNull
    public static CircularLayouter setupCircularLayouter(@NotNull CircularLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(36);
        }
        CircularLayouter circularLayouter = layouter;
        if (circularLayouter == null) {
            GraphSettings.$$$reportNull$$$0(37);
        }
        return circularLayouter;
    }

    @NotNull
    public static CircularLayouter setupEdgeBundledCircularLayouter(@NotNull CircularLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(38);
        }
        EdgeBundling ebc = layouter.getEdgeBundling();
        EdgeBundleDescriptor descriptor = GraphManager.getGraphManager().createEdgeBundleDescriptor();
        descriptor.setBundled(true);
        descriptor.setBezierFittingEnabled(false);
        ebc.setDefaultBundleDescriptor(descriptor);
        CircularLayouter circularLayouter = layouter;
        if (circularLayouter == null) {
            GraphSettings.$$$reportNull$$$0(39);
        }
        return circularLayouter;
    }

    @NotNull
    public static RadialLayouter setupRadialLayouter(@NotNull RadialLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(40);
        }
        RadialLayouter radialLayouter = layouter;
        if (radialLayouter == null) {
            GraphSettings.$$$reportNull$$$0(41);
        }
        return radialLayouter;
    }

    @NotNull
    public static RadialLayouter setupEdgeBundledRadialLayouter(@NotNull RadialLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(42);
        }
        EdgeBundling ebc = layouter.getEdgeBundling();
        EdgeBundleDescriptor descriptor = GraphManager.getGraphManager().createEdgeBundleDescriptor();
        descriptor.setBundled(true);
        descriptor.setBezierFittingEnabled(false);
        ebc.setDefaultBundleDescriptor(descriptor);
        RadialLayouter radialLayouter = layouter;
        if (radialLayouter == null) {
            GraphSettings.$$$reportNull$$$0(43);
        }
        return radialLayouter;
    }

    @NotNull
    public static SingleCycleLayouter setupSingleCycleLayouter(@NotNull SingleCycleLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(44);
        }
        SingleCycleLayouter singleCycleLayouter = layouter;
        if (singleCycleLayouter == null) {
            GraphSettings.$$$reportNull$$$0(45);
        }
        return singleCycleLayouter;
    }

    @NotNull
    public static ARTreeLayouter setupARTreeLayouter(@NotNull ARTreeLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(46);
        }
        ARTreeLayouter aRTreeLayouter = layouter;
        if (aRTreeLayouter == null) {
            GraphSettings.$$$reportNull$$$0(47);
        }
        return aRTreeLayouter;
    }

    @NotNull
    public static BalloonLayouter setupBalloonLayouter(@NotNull BalloonLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(48);
        }
        layouter.setMinimalEdgeLength(40);
        BalloonLayouter balloonLayouter = layouter;
        if (balloonLayouter == null) {
            GraphSettings.$$$reportNull$$$0(49);
        }
        return balloonLayouter;
    }

    @NotNull
    public static BalloonLayouter setupEdgeBundledBalloonLayouter(@NotNull BalloonLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(50);
        }
        TreeReductionStage trc = GraphManager.getGraphManager().createTreeReductionStage();
        EdgeBundling ebc = trc.getEdgeBundling();
        EdgeBundleDescriptor descriptor = GraphManager.getGraphManager().createEdgeBundleDescriptor();
        descriptor.setBundled(true);
        descriptor.setBezierFittingEnabled(false);
        ebc.setDefaultBundleDescriptor(descriptor);
        layouter.setMinimalEdgeLength(40);
        layouter.prependStage(trc);
        BalloonLayouter balloonLayouter = layouter;
        if (balloonLayouter == null) {
            GraphSettings.$$$reportNull$$$0(51);
        }
        return balloonLayouter;
    }

    @NotNull
    public static FamilyTreeLayouter setupFamilyTreeLayouter(@NotNull FamilyTreeLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(52);
        }
        FamilyTreeLayouter familyTreeLayouter = layouter;
        if (familyTreeLayouter == null) {
            GraphSettings.$$$reportNull$$$0(53);
        }
        return familyTreeLayouter;
    }

    @NotNull
    public static GenericTreeLayouter setupGenericTreeLayouter(@NotNull GenericTreeLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(54);
        }
        GenericTreeLayouter genericTreeLayouter = layouter;
        if (genericTreeLayouter == null) {
            GraphSettings.$$$reportNull$$$0(55);
        }
        return genericTreeLayouter;
    }

    @NotNull
    public static HVTreeLayouter setupHVTreeLayouter(@NotNull HVTreeLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(56);
        }
        layouter.setHorizontalSpace(40.0);
        layouter.setVerticalSpace(40.0);
        HVTreeLayouter hVTreeLayouter = layouter;
        if (hVTreeLayouter == null) {
            GraphSettings.$$$reportNull$$$0(57);
        }
        return hVTreeLayouter;
    }

    @NotNull
    public static RandomLayouter setupRandomLayouter(@NotNull RandomLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(58);
        }
        layouter.setLayoutBounds(new Rectangle(0, 0, 3000, 3000));
        RandomLayouter randomLayouter = layouter;
        if (randomLayouter == null) {
            GraphSettings.$$$reportNull$$$0(59);
        }
        return randomLayouter;
    }

    @NotNull
    public static SmartOrganicLayouter setupOrganicLayouter(@NotNull SmartOrganicLayouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(60);
        }
        layouter.setNodeSizeAware(true);
        layouter.setMinimalNodeDistance(40.0);
        layouter.setNodeOverlapsAllowed(false);
        SmartOrganicLayouter smartOrganicLayouter = layouter;
        if (smartOrganicLayouter == null) {
            GraphSettings.$$$reportNull$$$0(61);
        }
        return smartOrganicLayouter;
    }

    @NotNull
    public static OrganicEdgeRouter setupEdgeBundledOrganicLayouter(@NotNull OrganicEdgeRouter layouter) {
        if (layouter == null) {
            GraphSettings.$$$reportNull$$$0(62);
        }
        SmartOrganicLayouter organicLayouter = GraphManager.getGraphManager().createSmartOrganicLayouter();
        GraphSettings.setupOrganicLayouter(organicLayouter);
        LayoutStage nodeEnlarger = layouter.createNodeEnlargementStage();
        CompositeLayoutStage cls = GraphManager.getGraphManager().createCompositeLayoutStage();
        cls.appendStage(nodeEnlarger);
        cls.appendStage(GraphManager.getGraphManager().createBendConverter());
        cls.appendStage(GraphManager.getGraphManager().createRemoveOverlapsLayoutStage(0.0));
        cls.setCoreLayouter(organicLayouter);
        layouter.setCoreLayouter(cls);
        layouter.setRoutingAll(true);
        layouter.setUsingBends(false);
        layouter.setMinimalDistance(10.0);
        OrganicEdgeRouter organicEdgeRouter = layouter;
        if (organicEdgeRouter == null) {
            GraphSettings.$$$reportNull$$$0(63);
        }
        return organicEdgeRouter;
    }

    @NotNull
    public static EdgeRouter setupOrthogonalEdgeRouter(@NotNull EdgeRouter router) {
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(64);
        }
        router.setReroutingEnabled(true);
        router.getDefaultEdgeLayoutDescriptor().setMinimalEdgeToEdgeDistance(10.0);
        EdgeRouter edgeRouter = router;
        if (edgeRouter == null) {
            GraphSettings.$$$reportNull$$$0(65);
        }
        return edgeRouter;
    }

    @NotNull
    public static BusRouter setupBusOrthogonalEdgeRouter(@NotNull BusRouter router) {
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(66);
        }
        router.setReroutingEnabled(true);
        router.setMinimumDistanceToEdge(15);
        router.setGridSpacing(15);
        router.setMinimumBusConnectionsCount(2);
        router.setPreferredBackboneSegmentCount(3);
        BusRouter busRouter = router;
        if (busRouter == null) {
            GraphSettings.$$$reportNull$$$0(67);
        }
        return busRouter;
    }

    @NotNull
    public static OrganicEdgeRouter setupOrganicEdgeRouter(@NotNull OrganicEdgeRouter router) {
        if (router == null) {
            GraphSettings.$$$reportNull$$$0(68);
        }
        router.setRoutingAll(true);
        router.setUsingBends(false);
        router.setMinimalDistance(10.0);
        OrganicEdgeRouter organicEdgeRouter = router;
        if (organicEdgeRouter == null) {
            GraphSettings.$$$reportNull$$$0(69);
        }
        return organicEdgeRouter;
    }

    @NotNull
    public CompactOrthogonalLayouter getCompactOrthogonalLayouter() {
        CompactOrthogonalLayouter compactOrthogonalLayouter = this.myCompactOrthogonalLayouter;
        if (compactOrthogonalLayouter == null) {
            GraphSettings.$$$reportNull$$$0(70);
        }
        return compactOrthogonalLayouter;
    }

    @NotNull
    public ComponentLayouter getComponentLayouter() {
        ComponentLayouter componentLayouter = this.myComponentLayouter;
        if (componentLayouter == null) {
            GraphSettings.$$$reportNull$$$0(71);
        }
        return componentLayouter;
    }

    @NotNull
    public DirectedOrthogonalLayouter getDirectedOrthogonalLayouter() {
        DirectedOrthogonalLayouter directedOrthogonalLayouter = this.myDirectedOrthogonalLayouter;
        if (directedOrthogonalLayouter == null) {
            GraphSettings.$$$reportNull$$$0(72);
        }
        return directedOrthogonalLayouter;
    }

    @NotNull
    public HierarchicGroupLayouter getGroupLayouter() {
        HierarchicGroupLayouter hierarchicGroupLayouter = this.myGroupLayouter;
        if (hierarchicGroupLayouter == null) {
            GraphSettings.$$$reportNull$$$0(73);
        }
        return hierarchicGroupLayouter;
    }

    @NotNull
    public IncrementalHierarchicLayouter getHierarchicLayouter() {
        IncrementalHierarchicLayouter incrementalHierarchicLayouter = this.myHierarchicLayouter;
        if (incrementalHierarchicLayouter == null) {
            GraphSettings.$$$reportNull$$$0(74);
        }
        return incrementalHierarchicLayouter;
    }

    @NotNull
    public ChannelEdgeRouter getChannelLayouter() {
        ChannelEdgeRouter channelEdgeRouter = this.myChannelLayouter;
        if (channelEdgeRouter == null) {
            GraphSettings.$$$reportNull$$$0(75);
        }
        return channelEdgeRouter;
    }

    @NotNull
    public SeriesParallelLayouter getSeriesParallelLayouter() {
        SeriesParallelLayouter seriesParallelLayouter = this.mySeriesParallelLayouter;
        if (seriesParallelLayouter == null) {
            GraphSettings.$$$reportNull$$$0(76);
        }
        return seriesParallelLayouter;
    }

    @NotNull
    public CircularLayouter getCircularLayouter() {
        CircularLayouter circularLayouter = this.myCircularLayouter;
        if (circularLayouter == null) {
            GraphSettings.$$$reportNull$$$0(77);
        }
        return circularLayouter;
    }

    @NotNull
    public CircularLayouter getEdgeBundledCircularLayouter() {
        CircularLayouter circularLayouter = this.myEdgeBundledCircularLayouter;
        if (circularLayouter == null) {
            GraphSettings.$$$reportNull$$$0(78);
        }
        return circularLayouter;
    }

    @NotNull
    public RadialLayouter getRadialLayouter() {
        RadialLayouter radialLayouter = this.myRadialLayouter;
        if (radialLayouter == null) {
            GraphSettings.$$$reportNull$$$0(79);
        }
        return radialLayouter;
    }

    @NotNull
    public RadialLayouter getEdgeBundledRadialLayouter() {
        RadialLayouter radialLayouter = this.myEdgeBundledRadialLayouter;
        if (radialLayouter == null) {
            GraphSettings.$$$reportNull$$$0(80);
        }
        return radialLayouter;
    }

    @NotNull
    public SingleCycleLayouter getSingleCycleLayouter() {
        SingleCycleLayouter singleCycleLayouter = this.mySingleCycleLayouter;
        if (singleCycleLayouter == null) {
            GraphSettings.$$$reportNull$$$0(81);
        }
        return singleCycleLayouter;
    }

    @NotNull
    public ARTreeLayouter getARTreeLayouter() {
        ARTreeLayouter aRTreeLayouter = this.myARTreeLayouter;
        if (aRTreeLayouter == null) {
            GraphSettings.$$$reportNull$$$0(82);
        }
        return aRTreeLayouter;
    }

    @NotNull
    public BalloonLayouter getBalloonLayouter() {
        BalloonLayouter balloonLayouter = this.myBalloonLayouter;
        if (balloonLayouter == null) {
            GraphSettings.$$$reportNull$$$0(83);
        }
        return balloonLayouter;
    }

    @NotNull
    public BalloonLayouter getEdgeBundledBalloonLayouter() {
        BalloonLayouter balloonLayouter = this.myEdgeBundledBalloonLayouter;
        if (balloonLayouter == null) {
            GraphSettings.$$$reportNull$$$0(84);
        }
        return balloonLayouter;
    }

    @NotNull
    public FamilyTreeLayouter getFamilyTreeLayouter() {
        FamilyTreeLayouter familyTreeLayouter = this.myFamilyTreeLayouter;
        if (familyTreeLayouter == null) {
            GraphSettings.$$$reportNull$$$0(85);
        }
        return familyTreeLayouter;
    }

    @NotNull
    public GenericTreeLayouter getGenericTreeLayouter() {
        GenericTreeLayouter genericTreeLayouter = this.myGenericTreeLayouter;
        if (genericTreeLayouter == null) {
            GraphSettings.$$$reportNull$$$0(86);
        }
        return genericTreeLayouter;
    }

    @NotNull
    public HVTreeLayouter getHVTreeLayouter() {
        HVTreeLayouter hVTreeLayouter = this.myHVTreeLayouter;
        if (hVTreeLayouter == null) {
            GraphSettings.$$$reportNull$$$0(87);
        }
        return hVTreeLayouter;
    }

    @NotNull
    public RandomLayouter getRandomLayouter() {
        RandomLayouter randomLayouter = this.myRandomLayouter;
        if (randomLayouter == null) {
            GraphSettings.$$$reportNull$$$0(88);
        }
        return randomLayouter;
    }

    @NotNull
    public SmartOrganicLayouter getOrganicLayouter() {
        SmartOrganicLayouter smartOrganicLayouter = this.myOrganicLayouter;
        if (smartOrganicLayouter == null) {
            GraphSettings.$$$reportNull$$$0(89);
        }
        return smartOrganicLayouter;
    }

    @NotNull
    public OrganicEdgeRouter getEdgeBundledOrganicLayouter() {
        OrganicEdgeRouter organicEdgeRouter = this.myEdgeBundledOrganicLayouter;
        if (organicEdgeRouter == null) {
            GraphSettings.$$$reportNull$$$0(90);
        }
        return organicEdgeRouter;
    }

    @NotNull
    public EdgeRouter getOrthogonalEdgeRouter() {
        EdgeRouter edgeRouter = this.myOrthogonalEdgeRouter;
        if (edgeRouter == null) {
            GraphSettings.$$$reportNull$$$0(91);
        }
        return edgeRouter;
    }

    @NotNull
    public BusRouter getBusOrthogonalEdgeRouter() {
        BusRouter busRouter = this.myBusOrthogonalEdgeRouter;
        if (busRouter == null) {
            GraphSettings.$$$reportNull$$$0(92);
        }
        return busRouter;
    }

    @NotNull
    public OrganicEdgeRouter getOrganicEdgeRouter() {
        OrganicEdgeRouter organicEdgeRouter = this.myOrganicEdgeRouter;
        if (organicEdgeRouter == null) {
            GraphSettings.$$$reportNull$$$0(93);
        }
        return organicEdgeRouter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/settings/GraphSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLayouter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 64: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "router";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentLayouter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/settings/GraphSettings";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "setupCompactOrthogonalLayouter";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "setupComponentLayouter";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "setupDirectedOrthogonalLayouter";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "setupGroupLayouter";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "setupHierarchicLayouter";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "setupChannelLayouter";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "setupSeriesParallelLayouter";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "setupCircularLayouter";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "setupEdgeBundledCircularLayouter";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "setupRadialLayouter";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "setupEdgeBundledRadialLayouter";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "setupSingleCycleLayouter";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "setupARTreeLayouter";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "setupBalloonLayouter";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "setupEdgeBundledBalloonLayouter";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "setupFamilyTreeLayouter";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "setupGenericTreeLayouter";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "setupHVTreeLayouter";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "setupRandomLayouter";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "setupOrganicLayouter";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "setupEdgeBundledOrganicLayouter";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "setupOrthogonalEdgeRouter";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "setupBusOrthogonalEdgeRouter";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "setupOrganicEdgeRouter";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactOrthogonalLayouter";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentLayouter";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectedOrthogonalLayouter";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupLayouter";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchicLayouter";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getChannelLayouter";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeriesParallelLayouter";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getCircularLayouter";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeBundledCircularLayouter";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getRadialLayouter";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeBundledRadialLayouter";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleCycleLayouter";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getARTreeLayouter";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getBalloonLayouter";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeBundledBalloonLayouter";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyTreeLayouter";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericTreeLayouter";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getHVTreeLayouter";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getRandomLayouter";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrganicLayouter";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeBundledOrganicLayouter";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrthogonalEdgeRouter";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getBusOrthogonalEdgeRouter";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrganicEdgeRouter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentLayouter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupDataProvidersForEdgesMerging";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doesImplyOrthogonalEdgeRouting";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doesImplyOrganicEdgeRouting";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeRouterForLayouter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupDataProvidersForEdgeRouter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDataProvidersForEdgeRouter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupDataProvidersForOrthogonalEdgeRouter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupDataProvidersForBusOrthogonalEdgeRouter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setupDataProvidersForOrganicEdgeRouter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeDataProvidersForOrthogonalEdgeRouter";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeDataProvidersForBusOrthogonalEdgeRouter";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeDataProvidersForOrganicEdgeRouter";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setupCompactOrthogonalLayouter";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setupComponentLayouter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setupDirectedOrthogonalLayouter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setupGroupLayouter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setupHierarchicLayouter";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setupChannelLayouter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setupSeriesParallelLayouter";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setupCircularLayouter";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setupEdgeBundledCircularLayouter";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setupRadialLayouter";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setupEdgeBundledRadialLayouter";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setupSingleCycleLayouter";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setupARTreeLayouter";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setupBalloonLayouter";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setupEdgeBundledBalloonLayouter";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setupFamilyTreeLayouter";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setupGenericTreeLayouter";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setupHVTreeLayouter";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setupRandomLayouter";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "setupOrganicLayouter";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setupEdgeBundledOrganicLayouter";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "setupOrthogonalEdgeRouter";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setupBusOrthogonalEdgeRouter";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setupOrganicEdgeRouter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EdgeMergeIdentity {
        @NotNull
        private final Node myNode;
        @NotNull
        private final LineType myLineType;
        @NotNull
        private final Color myLineColor;
        @Nullable
        private final String myEdgeLabelText;

        private EdgeMergeIdentity(@NotNull Node node, @NotNull LineType lineType, @NotNull Color lineColor, @Nullable EdgeLabel edgeLabel) {
            if (node == null) {
                EdgeMergeIdentity.$$$reportNull$$$0(0);
            }
            if (lineType == null) {
                EdgeMergeIdentity.$$$reportNull$$$0(1);
            }
            if (lineColor == null) {
                EdgeMergeIdentity.$$$reportNull$$$0(2);
            }
            this.myNode = node;
            this.myLineType = lineType;
            this.myLineColor = lineColor;
            this.myEdgeLabelText = edgeLabel != null ? edgeLabel.getText() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdgeMergeIdentity identity = (EdgeMergeIdentity)o;
            return this.myNode.equals(identity.myNode) && this.myLineType.equals(identity.myLineType) && this.myLineColor.equals(identity.myLineColor) && Objects.equals(this.myEdgeLabelText, identity.myEdgeLabelText);
        }

        public int hashCode() {
            return Objects.hash(this.myNode, this.myLineType, this.myLineColor, this.myEdgeLabelText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lineType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lineColor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/graph/settings/GraphSettings$EdgeMergeIdentity";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

