/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.util;

import com.intellij.ide.DataManager;
import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.CompositeDataProvider;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphViewUtil {
    private static volatile boolean ourPrintMode = false;
    private static volatile boolean ourExportMode = false;
    public static final StructureViewModel MODEL = new DummyStructureViewModel();
    private static final StructureViewModel DUMMY_MODEL = new DummyStructureViewModel();

    public static boolean isPrintMode() {
        return ourPrintMode;
    }

    public static void setPrintMode(boolean printMode) {
        ourPrintMode = printMode;
    }

    public static boolean isExportMode() {
        return ourExportMode;
    }

    public static void setExportMode(boolean exportMode) {
        ourExportMode = exportMode;
    }

    @Nullable
    public static Object getData(Graph2DView view, String data) {
        DataProvider dataProvider = DataManager.getDataProvider((JComponent)view.getJComponent());
        if (dataProvider == null) {
            return null;
        }
        return dataProvider.getData(data);
    }

    public static Graph2DView createView(DataProvider dataProvider) {
        Graph2DView graph2DView = GraphManager.getGraphManager().createGraph2DView();
        GraphViewUtil.addDataProvider(graph2DView, dataProvider);
        return graph2DView;
    }

    public static void addDataProvider(Graph2DView graph2DView, @NotNull DataProvider dataProvider) {
        CompositeDataProvider compositeDataProvider;
        DataProvider oldDataProvider;
        if (dataProvider == null) {
            GraphViewUtil.$$$reportNull$$$0(0);
        }
        if ((oldDataProvider = DataManager.getDataProvider((JComponent)graph2DView.getJComponent())) == null) {
            compositeDataProvider = new CompositeDataProvider();
            compositeDataProvider.add(GraphViewUtil.createDefaultGraphDataProvider(graph2DView));
        } else if (oldDataProvider instanceof CompositeDataProvider) {
            compositeDataProvider = (CompositeDataProvider)oldDataProvider;
        } else {
            compositeDataProvider = new CompositeDataProvider();
            compositeDataProvider.add(oldDataProvider);
        }
        compositeDataProvider.add(dataProvider);
        DataManager.registerDataProvider((JComponent)graph2DView.getJComponent(), (DataProvider)compositeDataProvider);
    }

    private static DataProvider createDefaultGraphDataProvider(Graph2DView graph2DView) {
        return dataId -> GraphDataKeys.GRAPH.is(dataId) ? graph2DView.getGraph2D() : null;
    }

    public static void forEachSelectedNode(@NotNull Graph2D graph, @NotNull Consumer<Node> consumer) {
        if (graph == null) {
            GraphViewUtil.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            GraphViewUtil.$$$reportNull$$$0(2);
        }
        NodeCursor cursor = graph.selectedNodes();
        while (cursor.ok()) {
            consumer.accept(cursor.node());
            cursor.next();
        }
    }

    public static void forEachSelectedEdge(@NotNull Graph2D graph, @NotNull Consumer<Edge> consumer) {
        if (graph == null) {
            GraphViewUtil.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            GraphViewUtil.$$$reportNull$$$0(4);
        }
        EdgeCursor cursor = graph.selectedEdges();
        while (cursor.ok()) {
            consumer.accept(cursor.edge());
            cursor.next();
        }
    }

    @NotNull
    public static List<Node> getSelectedNodes(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphViewUtil.$$$reportNull$$$0(5);
        }
        ArrayList<Node> result = new ArrayList<Node>();
        NodeCursor cursor = graph.selectedNodes();
        while (cursor.ok()) {
            result.add(cursor.node());
            cursor.next();
        }
        ArrayList<Node> arrayList = result;
        if (arrayList == null) {
            GraphViewUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public static Node getSingleSelectedNode(@NotNull Graph2D graph) {
        NodeCursor cursor;
        if (graph == null) {
            GraphViewUtil.$$$reportNull$$$0(7);
        }
        if ((cursor = graph.selectedNodes()).ok()) {
            Node node = cursor.node();
            cursor.next();
            if (!cursor.ok()) {
                return node;
            }
        }
        return null;
    }

    @NotNull
    public static List<Edge> getSelectedEdges(@NotNull Graph2D graph) {
        if (graph == null) {
            GraphViewUtil.$$$reportNull$$$0(8);
        }
        ArrayList<Edge> result = new ArrayList<Edge>();
        EdgeCursor cursor = graph.selectedEdges();
        while (cursor.ok()) {
            result.add(cursor.edge());
            cursor.next();
        }
        ArrayList<Edge> arrayList = result;
        if (arrayList == null) {
            GraphViewUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static NodeRealizer createNodeRealizer(@NonNls String configuration, NodeCellRenderer nodeCellRenderer) {
        GenericNodeRealizer nodeRealizer = GraphManager.getGraphManager().createGenericNodeRealizer();
        GenericNodeRealizer.Factory factory = GenericNodeRealizer.Statics.getFactory();
        Map map = factory.createDefaultConfigurationMap();
        map.put(GenericNodeRealizer.Painter.class, GraphManager.getGraphManager().createFastNodeCellRendererPainter(nodeCellRenderer, NodeCellRendererPainter.USER_DATA_MAP));
        factory.addConfiguration(configuration, map);
        nodeRealizer.setConfiguration(configuration);
        nodeRealizer.setUserData(nodeCellRenderer);
        return nodeRealizer;
    }

    public static void setRenderedNodeSizes(Graph2D graph, Graph2DView view, Node node) {
        NodeLabel nodeLabel;
        GroupNodeRealizer groupNodeRealizer;
        GenericNodeRealizer realizer;
        Object o;
        NodeRealizer nodeRealizer = graph.getRealizer(node);
        if (nodeRealizer instanceof GenericNodeRealizer && (o = (realizer = (GenericNodeRealizer)nodeRealizer).getUserData()) instanceof NodeCellRenderer) {
            Dimension size = ((NodeCellRenderer)o).getNodeCellRendererComponent(view, nodeRealizer, null, false).getPreferredSize();
            graph.setSize(nodeRealizer.getNode(), GraphManager.getGraphManager().createYDimension(size.width, size.height));
        }
        if (nodeRealizer instanceof GroupNodeRealizer && (groupNodeRealizer = (GroupNodeRealizer)nodeRealizer).isGroupClosed() && (nodeLabel = groupNodeRealizer.getLabel()) != null) {
            graph.setSize(node, nodeLabel.getWidth(), groupNodeRealizer.getHeight());
        }
    }

    @Deprecated
    public static DefaultActionGroup getBasicToolbar(GraphBuilder builder) {
        return GraphViewUtil.getCommonToolbarActions();
    }

    public static DefaultActionGroup getCommonToolbarActions() {
        return (DefaultActionGroup)ActionManager.getInstance().getAction("Graph.DefaultGraphToolbar");
    }

    public static AnAction getCommonPopupActions() {
        return ActionManager.getInstance().getAction("Graph.DefaultGraphPopup");
    }

    public static void updateWorldRect(Graph2DView view) {
        Rectangle rectangle = GraphViewUtil.getActualSize(view);
        int x = (int)rectangle.getX() - 20;
        int y = (int)rectangle.getY() - 20;
        int width = (int)rectangle.getWidth() + 40;
        int hight = (int)rectangle.getHeight() + 40;
        view.setWorldRect(x, y, width, hight);
    }

    public static Rectangle getActualSize(Graph2DView view) {
        return view.getGraph2D().getBoundingBox();
    }

    public static StructureViewBuilder createStructureViewBuilder(final Overview overview) {
        DefaultBackgroundRenderer renderer = GraphManager.getGraphManager().createDefaultBackgroundRenderer(overview);
        renderer.setColor(UIUtil.getListBackground());
        overview.setBackgroundRenderer(renderer);
        overview.getJComponent().putClientProperty("Overview.FogColor", new JBColor(new Color(0.0f, 0.0f, 0.0f, 0.15f), new Color(1.0f, 1.0f, 1.0f, 0.1f)));
        return new StructureViewBuilder(){

            @NotNull
            public StructureView createStructureView(final FileEditor fileEditor, @NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new StructureView(){

                    public FileEditor getFileEditor() {
                        return fileEditor;
                    }

                    public boolean navigateToSelectedElement(boolean requestFocus) {
                        return false;
                    }

                    public JComponent getComponent() {
                        return overview.getJComponent();
                    }

                    public void dispose() {
                    }

                    public void centerSelectedRow() {
                    }

                    public void restoreState() {
                    }

                    public void storeState() {
                    }

                    @NotNull
                    public StructureViewModel getTreeModel() {
                        StructureViewModel structureViewModel = DUMMY_MODEL;
                        if (structureViewModel == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return structureViewModel;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1$1", "getTreeModel"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1", "createStructureView"));
            }
        };
    }

    public static void navigateTo(Object node, GraphBuilder builder) {
        for (Object o : builder.getGraphDataModel().getNodes()) {
            if (!o.equals(node)) continue;
            Node n = builder.getNode(node);
            if (n == null) {
                return;
            }
            for (Node nn : builder.getGraph().getNodeArray()) {
                builder.getGraph().setSelected(nn, nn.equals(n));
            }
            builder.getView().setCenter(builder.getGraph().getCenterX(n), builder.getGraph().getCenterY(n));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/util/GraphViewUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/util/GraphViewUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEdges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addDataProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forEachSelectedNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEachSelectedEdge";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSingleSelectedNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEdges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DummyStructureViewModel
    implements StructureViewModel {
        private DummyStructureViewModel() {
        }

        @Nullable
        public Object getCurrentEditorElement() {
            return null;
        }

        public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
            if (listener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(0);
            }
        }

        public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
            if (listener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(1);
            }
        }

        public void addModelListener(@NotNull ModelListener modelListener) {
            if (modelListener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(2);
            }
        }

        public void removeModelListener(@NotNull ModelListener modelListener) {
            if (modelListener == null) {
                DummyStructureViewModel.$$$reportNull$$$0(3);
            }
        }

        @NotNull
        public StructureViewTreeElement getRoot() {
            return new StructureViewTreeElement(){

                public Object getValue() {
                    return null;
                }

                public void navigate(boolean requestFocus) {
                }

                public boolean canNavigate() {
                    return false;
                }

                public boolean canNavigateToSource() {
                    return false;
                }

                @NotNull
                public ItemPresentation getPresentation() {
                    throw new UnsupportedOperationException();
                }

                public TreeElement @NotNull [] getChildren() {
                    if (EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return EMPTY_ARRAY;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$DummyStructureViewModel$1", "getChildren"));
                }
            };
        }

        public void dispose() {
        }

        public boolean shouldEnterElement(Object element) {
            return false;
        }

        public Grouper @NotNull [] getGroupers() {
            if (Grouper.EMPTY_ARRAY == null) {
                DummyStructureViewModel.$$$reportNull$$$0(4);
            }
            return Grouper.EMPTY_ARRAY;
        }

        public Sorter @NotNull [] getSorters() {
            if (Sorter.EMPTY_ARRAY == null) {
                DummyStructureViewModel.$$$reportNull$$$0(5);
            }
            return Sorter.EMPTY_ARRAY;
        }

        public Filter @NotNull [] getFilters() {
            if (Filter.EMPTY_ARRAY == null) {
                DummyStructureViewModel.$$$reportNull$$$0(6);
            }
            return Filter.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelListener";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/util/GraphViewUtil$DummyStructureViewModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/util/GraphViewUtil$DummyStructureViewModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupers";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSorters";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addEditorPositionListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeEditorPositionListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addModelListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeModelListener";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

