/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.layout.AbstractLayoutAction;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyCurrentLayoutAction
extends AbstractGraphAction {
    @Override
    public void actionPerformed(AnActionEvent e, Graph2D graph) {
        GraphBuilder<?, ?> builder = this.getBuilder(e);
        if (builder == null) {
            return;
        }
        Layouter layouter = this.getLayouter(builder);
        if (layouter != null) {
            this.beforeLayoutPerformed(layouter, builder);
            AbstractLayoutAction.doLayout(builder, layouter, builder.getGraphPresentationModel().getSettings());
            this.afterLayoutPerformed(layouter, builder);
        }
    }

    @Override
    public void update(AnActionEvent e, Graph2D graph) {
        Project project = ApplyCurrentLayoutAction.getProject(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(project != null && graph != null && graph.nodeCount() > 0 && this.canLayout(this.getBuilder(e)));
    }

    static boolean areNodesMovingByUserNow(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(0);
        }
        return builder.getEditMode().getMoveSelectionMode().isActive();
    }

    @Nullable
    protected Layouter getLayouter(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(1);
        }
        return builder.getGraphPresentationModel().getSettings().getCurrentLayouter();
    }

    protected boolean canLayout(@Nullable GraphBuilder<?, ?> builder) {
        if (builder == null || ApplyCurrentLayoutAction.areNodesMovingByUserNow(builder)) {
            return false;
        }
        try {
            Layouter layouter = this.getLayouter(builder);
            return layouter != null && layouter.canLayout(builder.getGraph());
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void beforeLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder) {
        if (layouter == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(3);
        }
    }

    protected void afterLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder) {
        if (layouter == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(5);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/layout/ApplyCurrentLayoutAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areNodesMovingByUserNow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLayouter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeLayoutPerformed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "afterLayoutPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

