/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.anim.AnimationFactory;
import com.intellij.openapi.graph.anim.AnimationPlayer;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.actions.AbstractGraphToggleAction;
import com.intellij.openapi.graph.builder.actions.layout.ApplyCurrentLayoutAction;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LayoutMorpher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLayoutAction
extends AbstractGraphToggleAction {
    @Override
    protected boolean isSelected(Graph2D graph, Project project, AnActionEvent event) {
        GraphBuilder<?, ?> builder = this.getBuilder(event);
        if (builder == null) {
            return false;
        }
        return builder.getGraphPresentationModel().getSettings().getCurrentLayouter() == this.getLayouter(project, builder);
    }

    @Override
    protected void setSelected(Graph2D graph, boolean state, Project project, AnActionEvent e) {
        GraphBuilder<?, ?> builder = this.getBuilder(e);
        if (builder == null) {
            return;
        }
        Layouter layouter = this.getLayouter(project, builder);
        GraphSettings settings = builder.getGraphPresentationModel().getSettings();
        settings.setCurrentLayouter(layouter);
        this.beforeLayoutPerformed(layouter, builder);
        AbstractLayoutAction.doLayout(builder, layouter, settings);
        this.afterLayoutPerformed(layouter, builder);
    }

    @Override
    protected String getText(@NotNull Graph2D graph) {
        if (graph == null) {
            AbstractLayoutAction.$$$reportNull$$$0(0);
        }
        return this.getLayoutName();
    }

    public static void doLayout(@NotNull GraphBuilder<?, ?> builder, @NotNull Layouter layouter, @NotNull GraphSettings settings) {
        if (builder == null) {
            AbstractLayoutAction.$$$reportNull$$$0(1);
        }
        if (layouter == null) {
            AbstractLayoutAction.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            AbstractLayoutAction.$$$reportNull$$$0(3);
        }
        Graph2DView view = builder.getView();
        if (settings.isFitContentAfterLayout()) {
            GraphManager.getGraphManager().createBufferedLayouter(layouter).doLayout(view.getGraph2D());
            view.fitContent();
        } else {
            GraphLayout layout = GraphManager.getGraphManager().createBufferedLayouter(layouter).calcLayout(view.getGraph2D());
            LayoutMorpher morpher = GraphManager.getGraphManager().createLayoutMorpher(view, layout);
            morpher.setPreferredDuration(800L);
            morpher.setKeepZoomFactor(true);
            AnimationPlayer player = GraphManager.getGraphManager().createAnimationPlayer();
            player.addAnimationListener(view);
            player.setFps(1200);
            player.animate(AnimationFactory.Statics.createEasedAnimation(morpher));
            GraphViewUtil.updateWorldRect(view);
        }
    }

    @Override
    protected boolean isEnabled(Graph2D graph, Project project, AnActionEvent event) {
        GraphBuilder<?, ?> builder = this.getBuilder(event);
        return builder != null && !ApplyCurrentLayoutAction.areNodesMovingByUserNow(builder) && graph.nodeCount() > 0 && this.getLayouter(project, builder).canLayout(graph);
    }

    protected abstract Layouter getLayouter(Project var1, @NotNull GraphBuilder<?, ?> var2);

    @NlsActions.ActionText
    protected abstract String getLayoutName();

    protected boolean areBridgesPreferred() {
        return true;
    }

    protected void beforeLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder) {
        GraphPresentationModel<?, ?> graphPresentationModel;
        if (layouter == null) {
            AbstractLayoutAction.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            AbstractLayoutAction.$$$reportNull$$$0(5);
        }
        if ((graphPresentationModel = builder.getGraphPresentationModel()) instanceof BasicGraphPresentationModel) {
            ((BasicGraphPresentationModel)graphPresentationModel).setShowBridges(this.areBridgesPreferred());
        }
    }

    protected void afterLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder) {
        if (layouter == null) {
            AbstractLayoutAction.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            AbstractLayoutAction.$$$reportNull$$$0(7);
        }
        builder.getEditMode().setOrthogonalEdgeRouting(GraphSettings.doesImplyOrthogonalEdgeRouting(layouter));
        builder.updateView();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/layout/AbstractLayoutAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doLayout";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeLayoutPerformed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "afterLayoutPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

