/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.util.MathUtil;

public abstract class ZoomAction
extends AbstractGraphAction {
    public static final double DEFAULT_ZOOM_STEP = 0.15;

    protected abstract double getScale();

    @Override
    public void actionPerformed(AnActionEvent e, Graph2D graph) {
        GraphBuilder<?, ?> builder = this.getBuilder(e);
        if (builder != null) {
            builder.setZoom(builder.getZoom() + this.getScale());
        } else {
            Graph2DView graph2DView = ZoomAction.getGraph2DView(graph);
            double zoom = graph2DView.getZoom() + this.getScale();
            graph2DView.setZoom(MathUtil.clamp((double)zoom, (double)0.1, (double)20.0));
        }
    }

    @Override
    public void update(AnActionEvent e, Graph2D graph) {
        GraphBuilder<?, ?> builder = this.getBuilder(e);
        double cur = builder != null ? builder.getZoom() : ZoomAction.getGraph2DView(graph).getZoom();
        double zoom = cur + this.getScale();
        e.getPresentation().setEnabled(zoom > 0.1 && zoom < 20.0);
    }
}

