/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GraphBuilder<N, E>
extends UserDataHolderBase
implements UserDataHolder,
Disposable {
    public static final double MIN_ZOOM = 0.1;
    public static final double MAX_ZOOM = 20.0;

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract Graph2D getGraph();

    @NotNull
    public abstract Graph2DView getView();

    @Nullable
    public Overview getOverview() {
        return null;
    }

    @NotNull
    public abstract GraphDataModel<N, E> getGraphDataModel();

    @NotNull
    public abstract GraphPresentationModel<N, E> getGraphPresentationModel();

    public abstract double getZoom();

    public abstract void setZoom(double var1);

    public abstract void setZoom(double var1, boolean var3);

    public abstract void fitContent();

    public abstract void updateGraph(boolean var1);

    public void updateGraph() {
        this.updateGraph(true);
    }

    public abstract void updateDataModel();

    public abstract void updateView(boolean var1);

    public void updateView() {
        this.updateView(false);
    }

    public abstract void updateRealizers(boolean var1);

    public abstract void queueUpdate();

    public abstract void initialize();

    @Nullable
    public abstract String getNodeName(@Nullable N var1);

    @Nullable
    public abstract String getEdgeName(@Nullable E var1);

    @Nullable
    public abstract Node getNode(@Nullable N var1);

    @Nullable
    public abstract Edge getEdge(@Nullable E var1);

    @Nullable
    public abstract N getNodeObject(@Nullable Node var1);

    @Nullable
    public abstract E getEdgeObject(@Nullable Edge var1);

    public abstract void addCustomUpdater(@NotNull CustomGraphUpdater var1);

    @NotNull
    public abstract EditMode getEditMode();

    @NotNull
    public ViewMode getActiveMode() {
        EditMode editMode = this.getEditMode();
        if (editMode == null) {
            GraphBuilder.$$$reportNull$$$0(0);
        }
        return editMode;
    }

    public abstract boolean isCellEditing();

    @NotNull
    public abstract Collection<N> getNodeObjects();

    @NotNull
    public abstract Collection<E> getEdgeObjects();

    public abstract boolean removeNode(@Nullable N var1);

    public abstract boolean removeEdge(@Nullable E var1);

    public abstract void addGraphBuilderListener(@NotNull GraphBuilderListener var1, @NotNull Disposable var2);

    public abstract void removeGraphBuilderListener(@NotNull GraphBuilderListener var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/GraphBuilder", "getActiveMode"));
    }
}

