/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.sax;

import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.SubParser;
import com.thaiopensource.relaxng.parse.sax.SchemaParser;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXSubParser
implements SubParser {
    final XMLReaderCreator xrc;
    final ErrorHandler eh;

    SAXSubParser(XMLReaderCreator xMLReaderCreator, ErrorHandler errorHandler) {
        this.xrc = xMLReaderCreator;
        this.eh = errorHandler;
    }

    public ParsedPattern parseInclude(String string, SchemaBuilder schemaBuilder, IncludedGrammar includedGrammar) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.xrc.createXMLReader();
            SchemaParser schemaParser = new SchemaParser(xMLReader, this.eh, schemaBuilder, includedGrammar, includedGrammar);
            xMLReader.parse(SAXSubParser.makeInputSource(xMLReader, string));
            return schemaParser.getParsedPattern();
        }
        catch (SAXException sAXException) {
            throw SAXSubParser.toBuildException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public ParsedPattern parseExternal(String string, SchemaBuilder schemaBuilder, Scope scope) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.xrc.createXMLReader();
            SchemaParser schemaParser = new SchemaParser(xMLReader, this.eh, schemaBuilder, null, scope);
            xMLReader.parse(SAXSubParser.makeInputSource(xMLReader, string));
            return schemaParser.getParsedPattern();
        }
        catch (SAXException sAXException) {
            throw SAXSubParser.toBuildException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private static InputSource makeInputSource(XMLReader xMLReader, String string) throws IOException, SAXException {
        InputSource inputSource;
        EntityResolver entityResolver = xMLReader.getEntityResolver();
        if (entityResolver != null && (inputSource = entityResolver.resolveEntity(null, string)) != null) {
            return inputSource;
        }
        return new InputSource(string);
    }

    static BuildException toBuildException(SAXException sAXException) {
        Exception exception = sAXException.getException();
        if (exception instanceof BuildException) {
            throw (BuildException)exception;
        }
        throw new BuildException(sAXException);
    }
}

