/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeception.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.behat.BehatUtil;
import com.jetbrains.php.codeception.CodeceptionFrameworkType;
import com.jetbrains.php.codeception.CodeceptionUtil;
import com.jetbrains.php.codeception.run.CodeceptionLocationProvider;
import com.jetbrains.php.codeception.run.CodeceptionRerunFailedTestsAction;
import com.jetbrains.php.codeception.run.CodeceptionRunConfigurationHandler;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.phpunit.PhpUnitConsoleProperties;
import com.jetbrains.php.phpunit.PhpUnitQualifiedNameLocationProvider;
import com.jetbrains.php.run.PhpCommandLineSettings;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.run.PhpDefaultTestRunnerSettingsValidator;
import com.jetbrains.php.testFramework.run.PhpTestRunConfiguration;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationEditor;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationHandler;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerConfigurationEditor;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettingsValidator;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.EnumMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFileType;

public class CodeceptionRunConfiguration
extends PhpTestRunConfiguration {
    private static final Logger LOG = Logger.getInstance(CodeceptionRunConfiguration.class);
    @NlsSafe
    public static final String ALL_TESTS = "All";
    public static final List<@NlsSafe String> TYPES = ContainerUtil.newArrayList((Object[])new String[]{"All", "acceptance", "functional", "unit"});
    public static final PhpDefaultTestRunnerSettingsValidator VALIDATOR = new PhpDefaultTestRunnerSettingsValidator((List)ContainerUtil.newArrayList((Object[])new FileType[]{PhpFileType.INSTANCE, GherkinFileType.INSTANCE}), TYPES, (file, name) -> {
        if (file instanceof PhpFile) {
            return PhpPsiUtil.findAllClasses((PhpFile)((PhpFile)file)).stream().map(clazz -> clazz.findMethodByName((CharSequence)name)).anyMatch(method -> method != null && CodeceptionUtil.isTestMethod(method));
        }
        return BehatUtil.findScenarioByName((PsiFile)file, (String)name) != null;
    }, false, true);

    public CodeceptionRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name, CodeceptionFrameworkType.getInstance(), (PhpTestRunnerSettingsValidator)VALIDATOR, (PhpTestRunConfigurationHandler)CodeceptionRunConfigurationHandler.getInstance(), (PhpTestFrameworkVersionDetector)CodeceptionFrameworkType.VERSION_DETECTOR);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        PhpTestRunConfigurationEditor editor = this.getConfigurationEditor(new EnumMap(PhpTestRunnerSettings.Scope.class));
        editor.setSupportedTypes(TYPES);
        editor.setRunnerOptionsDocumentation("https://codeception.com/docs/reference/Commands#Run");
        PhpTestRunConfigurationEditor phpTestRunConfigurationEditor = editor;
        if (phpTestRunConfigurationEditor == null) {
            CodeceptionRunConfiguration.$$$reportNull$$$0(0);
        }
        return phpTestRunConfigurationEditor;
    }

    @NotNull
    protected TextFieldCompletionProvider createMethodFieldCompletionProvider(@NotNull PhpTestRunnerConfigurationEditor editor) {
        if (editor == null) {
            CodeceptionRunConfiguration.$$$reportNull$$$0(1);
        }
        TextFieldCompletionProvider textFieldCompletionProvider = this.createMethodFileCompletionProvider(this.getProject(), editor, CodeceptionUtil::isTestMethod);
        if (textFieldCompletionProvider == null) {
            CodeceptionRunConfiguration.$$$reportNull$$$0(2);
        }
        return textFieldCompletionProvider;
    }

    @Nullable
    protected String getWorkingDirectory(@NotNull Project project, @NotNull PhpTestRunConfigurationSettings settings, @Nullable PhpTestFrameworkConfiguration config) {
        VirtualFile dir;
        VirtualFile file;
        PhpCommandLineSettings cli;
        if (project == null) {
            CodeceptionRunConfiguration.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            CodeceptionRunConfiguration.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)(cli = settings.getCommandLineSettings()).getWorkingDirectory())) {
            return cli.getWorkingDirectory();
        }
        String configurationFilePath = CodeceptionRunConfiguration.getConfigurationFile((PhpTestRunnerSettings)settings.getRunnerSettings(), (PhpTestFrameworkConfiguration)config);
        if (!StringUtil.isEmptyOrSpaces((String)configurationFilePath) && (file = PhpRunUtil.findFile((String)configurationFilePath)) != null && (dir = file.getParent()) != null) {
            return file.getParent().getPath();
        }
        return super.getWorkingDirectory(project, settings, config);
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            CodeceptionRunConfiguration.$$$reportNull$$$0(5);
        }
        PhpCommandLinePathProcessor pathProcessor = this.createPathMapper();
        PhpPathMapper mapper = pathProcessor.createPathMapper(this.getProject());
        CodeceptionLocationProvider locationProvider = new CodeceptionLocationProvider(mapper);
        return new PhpUnitConsoleProperties((PhpRunConfiguration)this, executor, (PhpUnitQualifiedNameLocationProvider)locationProvider, false);
    }

    @NotNull
    private PhpCommandLinePathProcessor createPathMapper() {
        PhpRemoteInterpreterManager manager;
        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance((Project)this.getProject()).getInterpreter();
        if (interpreter != null && interpreter.isRemote() && (manager = PhpRemoteInterpreterManager.getInstance()) != null) {
            PhpCommandLinePathProcessor phpCommandLinePathProcessor;
            try {
                phpCommandLinePathProcessor = manager.createPathMapper(this.getProject(), interpreter.getPhpSdkAdditionalData());
            }
            catch (ExecutionException e) {
                LOG.warn("Can not detect path mappings for '" + interpreter.getName() + "' interpreter", (Throwable)e);
            }
            if (phpCommandLinePathProcessor == null) {
                CodeceptionRunConfiguration.$$$reportNull$$$0(6);
            }
            return phpCommandLinePathProcessor;
        }
        PhpCommandLinePathProcessor phpCommandLinePathProcessor = PhpCommandLinePathProcessor.LOCAL;
        if (phpCommandLinePathProcessor == null) {
            CodeceptionRunConfiguration.$$$reportNull$$$0(7);
        }
        return phpCommandLinePathProcessor;
    }

    @Nullable
    protected AbstractRerunFailedTestsAction createRerunAction(@NotNull ConsoleView consoleView, @NotNull SMTRunnerConsoleProperties properties) {
        if (consoleView == null) {
            CodeceptionRunConfiguration.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            CodeceptionRunConfiguration.$$$reportNull$$$0(9);
        }
        return new CodeceptionRerunFailedTestsAction((ComponentContainer)consoleView, properties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeception/run/CodeceptionRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeception/run/CodeceptionRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodFieldCompletionProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFieldCompletionProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRerunAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

