/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeception;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.behat.ContextInterfaceProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeceptionContextInterfaceProvider
implements ContextInterfaceProvider {
    public static final String CODECEPTION_ACTOR = "\\Codeception\\Actor";
    public static final String ACCEPTANCE_TESTER = "AcceptanceTester";
    public static final String SUPPORT = "_support";
    public static final String INCOMPLETE_TEST_ERROR = "IncompleteTestError";

    @Nullable
    public PhpClass getContextInterface(@NotNull Project project) {
        Collection newContextInterfaces;
        if (project == null) {
            CodeceptionContextInterfaceProvider.$$$reportNull$$$0(0);
        }
        return (newContextInterfaces = PhpIndex.getInstance((Project)project).getClassesByFQN(CODECEPTION_ACTOR)).isEmpty() ? null : (PhpClass)newContextInterfaces.iterator().next();
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            CodeceptionContextInterfaceProvider.$$$reportNull$$$0(1);
        }
        return !PhpIndex.getInstance((Project)project).getClassesByFQN(CODECEPTION_ACTOR).isEmpty();
    }

    public int getWeight() {
        return 1;
    }

    @NotNull
    public String getDefaultStepFileName() {
        return ACCEPTANCE_TESTER;
    }

    @NotNull
    public String getStepDefinitionDirName() {
        return SUPPORT;
    }

    @NotNull
    public String getDummyStepException() {
        return INCOMPLETE_TEST_ERROR;
    }

    @NotNull
    public String generateContent(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            CodeceptionContextInterfaceProvider.$$$reportNull$$$0(2);
        }
        if (name == null) {
            CodeceptionContextInterfaceProvider.$$$reportNull$$$0(3);
        }
        StringBuilder content = new StringBuilder();
        content.append("/** empty */\nclass ");
        content.append(name);
        content.append(" extends ");
        content.append(PhpLangUtil.toShortName((String)CODECEPTION_ACTOR));
        content.append(" {\n ");
        Collection actions = PhpIndex.getInstance((Project)project).getTraitsByName("AcceptanceTesterActions");
        if (!actions.isEmpty()) {
            content.append("use ");
            content.append(PhpLangUtil.toShortName((String)((PhpClass)ContainerUtil.getFirstItem((Collection)actions)).getFQN()));
            content.append(";");
        }
        content.append("\n}");
        String string = content.toString();
        if (string == null) {
            CodeceptionContextInterfaceProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void tuneGeneratedContent(@NotNull Project project, @NotNull PsiFile newFile) {
        if (project == null) {
            CodeceptionContextInterfaceProvider.$$$reportNull$$$0(5);
        }
        if (newFile == null) {
            CodeceptionContextInterfaceProvider.$$$reportNull$$$0(6);
        }
        if (newFile instanceof PhpFile) {
            PhpAliasImporter.insertUseStatement((String)CODECEPTION_ACTOR, (PhpPsiElement)((PhpFile)newFile));
            Collection actions = PhpIndex.getInstance((Project)project).getTraitsByName("AcceptanceTesterActions");
            if (!actions.isEmpty()) {
                PhpAliasImporter.insertUseStatement((String)((PhpClass)ContainerUtil.getFirstItem((Collection)actions)).getFQN(), (PhpPsiElement)((PhpFile)newFile));
            }
            Collection classes = PhpPsiUtil.findAllClasses((PhpFile)((PhpFile)newFile));
            assert (classes.size() == 1);
            PhpDocComment comment = ((PhpClass)classes.iterator().next()).getDocComment();
            if (comment != null) {
                comment.delete();
            }
        }
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(newFile.getViewProvider());
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeception/CodeceptionContextInterfaceProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeception/CodeceptionContextInterfaceProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextInterface";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateContent";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tuneGeneratedContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

