/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.io.Murmur3_32Hash;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.IntObjectHashMap;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.zip.ImmutableZipEntry;
import com.intellij.util.zip.ImmutableZipFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ZipResourceFile
implements ResourceFile {
    private static final int MANIFEST_HASH_CODE = Murmur3_32Hash.MURMUR3_32.hashString((CharSequence)"META-INF/MANIFEST.MF", 0, "META-INF/MANIFEST.MF".length());
    private final ImmutableZipFile zipFile;

    public ZipResourceFile(@NotNull Path file) {
        if (file == null) {
            ZipResourceFile.$$$reportNull$$$0(0);
        }
        try {
            this.zipFile = ImmutableZipFile.load((Path)file, buffer -> {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.getInt();
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void processResources(@NotNull String dir, @NotNull Predicate<? super String> nameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        if (dir == null) {
            ZipResourceFile.$$$reportNull$$$0(1);
        }
        if (nameFilter == null) {
            ZipResourceFile.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            ZipResourceFile.$$$reportNull$$$0(3);
        }
        int minNameLength = dir.length() + 2;
        for (ImmutableZipEntry entry : this.zipFile.getEntries()) {
            String name = entry.getName();
            if (name.length() < minNameLength || !name.startsWith(dir) || name.charAt(dir.length()) != '/' || !nameFilter.test(name)) continue;
            try (InputStream stream = entry.getInputStream(this.zipFile);){
                consumer.accept(name, stream);
            }
        }
    }

    @Nullable
    public Attributes loadManifestAttributes() throws IOException {
        ImmutableZipEntry entry = this.zipFile.getEntry("META-INF/MANIFEST.MF", MANIFEST_HASH_CODE);
        if (entry != null) {
            return new Manifest(new ByteArrayInputStream(entry.getData(this.zipFile))).getMainAttributes();
        }
        return null;
    }

    @NotNull
    public ClasspathCache.IndexRegistrar buildClassPathCacheData() throws IOException {
        ImmutableZipEntry packageIndex = this.zipFile.getEntry("__packageIndex__");
        if (packageIndex == null) {
            return this.computePackageIndex();
        }
        ByteBuffer buffer = packageIndex.getByteBuffer(this.zipFile);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int[] classPackages = new int[buffer.getInt()];
        int[] resourcePackages = new int[buffer.getInt()];
        IntBuffer intBuffer = buffer.asIntBuffer();
        intBuffer.get(classPackages);
        intBuffer.get(resourcePackages);
        ClasspathCache.IndexRegistrar indexRegistrar = (classMap, resourceMap, loader) -> {
            ClasspathCache.addResourceEntries((int[])classPackages, (IntObjectHashMap)classMap, (Loader)loader);
            ClasspathCache.addResourceEntries((int[])resourcePackages, (IntObjectHashMap)resourceMap, (Loader)loader);
        };
        if (indexRegistrar == null) {
            ZipResourceFile.$$$reportNull$$$0(4);
        }
        return indexRegistrar;
    }

    @NotNull
    private ClasspathCache.LoaderDataBuilder computePackageIndex() {
        ClasspathCache.LoaderDataBuilder builder = new ClasspathCache.LoaderDataBuilder(false);
        for (ImmutableZipEntry entry : this.zipFile.getRawNameSet()) {
            if (entry == null) continue;
            String name = entry.getName();
            if (name.endsWith(".class")) {
                builder.addClassPackageFromName(name);
                continue;
            }
            builder.addResourcePackageFromName(name);
        }
        ClasspathCache.LoaderDataBuilder loaderDataBuilder = builder;
        if (loaderDataBuilder == null) {
            ZipResourceFile.$$$reportNull$$$0(5);
        }
        return loaderDataBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Class<?> findClass(String fileName, String className, JarLoader jarLoader, ClassPath.ClassDataConsumer classConsumer) throws IOException {
        ImmutableZipEntry entry = this.zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        if (classConsumer.isByteBufferSupported(className, null)) {
            ByteBuffer buffer = entry.getByteBuffer(this.zipFile);
            try {
                Class clazz = classConsumer.consumeClassData(className, buffer, (Loader)jarLoader, null);
                return clazz;
            }
            finally {
                entry.releaseBuffer(buffer);
            }
        }
        return classConsumer.consumeClassData(className, entry.getData(this.zipFile), (Loader)jarLoader, null);
    }

    @Nullable
    public Resource getResource(@NotNull String name, @NotNull JarLoader jarLoader) throws IOException {
        ImmutableZipEntry entry;
        if (name == null) {
            ZipResourceFile.$$$reportNull$$$0(6);
        }
        if (jarLoader == null) {
            ZipResourceFile.$$$reportNull$$$0(7);
        }
        if ((entry = this.zipFile.getEntry(name)) == null) {
            return null;
        }
        return new ZipFileResource(jarLoader.url, entry, this.zipFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/ZipResourceFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/ZipResourceFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClassPathCacheData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computePackageIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyURLConnection
    extends URLConnection {
        private final ImmutableZipEntry entry;
        private final ImmutableZipFile file;
        private byte[] data;

        MyURLConnection(@NotNull URL url, @NotNull ImmutableZipEntry entry, @NotNull ImmutableZipFile file) {
            if (url == null) {
                MyURLConnection.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                MyURLConnection.$$$reportNull$$$0(1);
            }
            if (file == null) {
                MyURLConnection.$$$reportNull$$$0(2);
            }
            super(url);
            this.entry = entry;
            this.file = file;
        }

        private byte[] getData() throws IOException {
            byte[] result = this.data;
            if (result == null) {
                this.data = result = this.entry.getData(this.file);
            }
            return result;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public Object getContent() throws IOException {
            return this.getData();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.entry.getInputStream(this.file);
        }

        @Override
        public int getContentLength() {
            return this.entry.getUncompressedSize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "url";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/ZipResourceFile$MyURLConnection";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyURLStreamHandler
    extends URLStreamHandler {
        @NotNull
        private final ImmutableZipEntry entry;
        @NotNull
        private final ImmutableZipFile file;

        private MyURLStreamHandler(@NotNull ImmutableZipEntry entry, @NotNull ImmutableZipFile file) {
            if (entry == null) {
                MyURLStreamHandler.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyURLStreamHandler.$$$reportNull$$$0(1);
            }
            this.entry = entry;
            this.file = file;
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new MyURLConnection(url, this.entry, this.file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/ZipResourceFile$MyURLStreamHandler";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ZipFileResource
    implements Resource {
        private final URL baseUrl;
        private URL url;
        private final ImmutableZipEntry entry;
        private final ImmutableZipFile file;

        private ZipFileResource(@NotNull URL baseUrl, @NotNull ImmutableZipEntry entry, @NotNull ImmutableZipFile file) {
            if (baseUrl == null) {
                ZipFileResource.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ZipFileResource.$$$reportNull$$$0(1);
            }
            if (file == null) {
                ZipFileResource.$$$reportNull$$$0(2);
            }
            this.baseUrl = baseUrl;
            this.entry = entry;
            this.file = file;
        }

        public String toString() {
            return "ZipFileResource(name=" + this.entry.getName() + ", file=" + this.file + ")";
        }

        @NotNull
        public URL getURL() {
            URL result = this.url;
            if (result == null) {
                try {
                    result = new URL(this.baseUrl, this.entry.getName(), new MyURLStreamHandler(this.entry, this.file));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                this.url = result;
            }
            URL uRL = result;
            if (uRL == null) {
                ZipFileResource.$$$reportNull$$$0(3);
            }
            return uRL;
        }

        @NotNull
        public InputStream getInputStream() throws IOException {
            InputStream inputStream = this.entry.getInputStream(this.file);
            if (inputStream == null) {
                ZipFileResource.$$$reportNull$$$0(4);
            }
            return inputStream;
        }

        public byte @NotNull [] getBytes() throws IOException {
            byte[] byArray = this.entry.getData(this.file);
            if (byArray == null) {
                ZipFileResource.$$$reportNull$$$0(5);
            }
            return byArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseUrl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/ZipResourceFile$ZipFileResource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/ZipResourceFile$ZipFileResource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

