/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.BytecodeTransformer;
import com.intellij.idea.Main;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.lang.PathClassLoader;
import com.intellij.util.lang.UrlClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BootstrapClassLoaderUtil {
    @NonNls
    public static final String CLASSPATH_ORDER_FILE = "classpath.txt";
    private static final String PROPERTY_IGNORE_CLASSPATH = "ignore.classpath";
    private static final String PROPERTY_ALLOW_BOOTSTRAP_RESOURCES = "idea.allow.bootstrap.resources";
    private static final String PROPERTY_ADDITIONAL_CLASSPATH = "idea.additional.classpath";
    @NonNls
    private static final String MARKETPLACE_PLUGIN_DIR = "marketplace";
    private static final String MARKETPLACE_BOOTSTRAP_JAR = "marketplace-bootstrap.jar";

    private BootstrapClassLoaderUtil() {
    }

    private static Logger getLogger() {
        return Logger.getInstance(BootstrapClassLoaderUtil.class);
    }

    @NotNull
    public static PathClassLoader initClassLoader() throws IOException {
        Path marketplaceImpl;
        boolean installMarketplace;
        Path distDir = Path.of(PathManager.getHomePath(), new String[0]);
        if (Boolean.getBoolean("idea.use.dev.build.server")) {
            ClassLoader classLoader = BootstrapClassLoaderUtil.class.getClassLoader();
            if (!(classLoader instanceof PathClassLoader)) {
                System.err.println("Please run with VM option -Djava.system.class.loader=com.intellij.util.lang.PathClassLoader");
                System.exit(1);
            }
            List<Path> paths = BootstrapClassLoaderUtil.loadClassPathFromDevBuildServer(distDir);
            PathClassLoader result = (PathClassLoader)((Object)classLoader);
            result.getClassPath().appendFiles(paths);
            PathClassLoader pathClassLoader = result;
            if (pathClassLoader == null) {
                BootstrapClassLoaderUtil.$$$reportNull$$$0(0);
            }
            return pathClassLoader;
        }
        LinkedHashSet<Path> classpath = new LinkedHashSet<Path>();
        BootstrapClassLoaderUtil.parseClassPathString(System.getProperty("java.class.path"), classpath);
        BootstrapClassLoaderUtil.addIdeaLibraries(distDir, classpath);
        BootstrapClassLoaderUtil.parseClassPathString(System.getProperty(PROPERTY_ADDITIONAL_CLASSPATH), classpath);
        Path pluginDir = Path.of(PathManager.getPluginsPath(), new String[0]);
        Path marketPlaceBootDir = BootstrapClassLoaderUtil.findMarketplaceBootDir(pluginDir);
        Path mpBoot = marketPlaceBootDir.resolve(MARKETPLACE_BOOTSTRAP_JAR);
        if (!Files.exists(mpBoot, new LinkOption[0])) {
            pluginDir = Path.of(PathManager.getPreInstalledPluginsPath(), new String[0]);
            marketPlaceBootDir = BootstrapClassLoaderUtil.findMarketplaceBootDir(pluginDir);
            mpBoot = marketPlaceBootDir.resolve(MARKETPLACE_BOOTSTRAP_JAR);
        }
        if ((installMarketplace = BootstrapClassLoaderUtil.shouldInstallMarketplace(distDir, mpBoot)) && Files.exists(marketplaceImpl = marketPlaceBootDir.resolve("marketplace-impl.jar"), new LinkOption[0])) {
            classpath.add(marketplaceImpl);
        }
        UrlClassLoader.Builder builder = UrlClassLoader.build().files(BootstrapClassLoaderUtil.filterClassPath(classpath)).usePersistentClasspathIndexForLocalClassDirectories().autoAssignUrlsWithProtectionDomain().parent(ClassLoader.getPlatformClassLoader()).useCache();
        if (Boolean.parseBoolean(System.getProperty(PROPERTY_ALLOW_BOOTSTRAP_RESOURCES, "true"))) {
            builder.allowBootstrapResources();
        }
        if (installMarketplace) {
            try {
                PathClassLoader spiLoader = new PathClassLoader(UrlClassLoader.build().files(Collections.singletonList(mpBoot)).parent(BootstrapClassLoaderUtil.class.getClassLoader()));
                Iterator<BytecodeTransformer> transformers = ServiceLoader.load(BytecodeTransformer.class, (ClassLoader)((Object)spiLoader)).iterator();
                return new PathClassLoader(builder, transformers.hasNext() ? transformers.next() : null);
            }
            catch (Throwable e) {
                String path = pluginDir.resolve(MARKETPLACE_PLUGIN_DIR).toString();
                String message = "As a workaround, you may uninstall or update JetBrains Marketplace Support plugin at " + path;
                Main.showMessage(BootstrapBundle.message("bootstrap.error.title.jetbrains.marketplace.boot.failure", new Object[0]), new Exception(message, e));
            }
        }
        return new PathClassLoader(builder);
    }

    @NotNull
    private static Path findMarketplaceBootDir(Path pluginDir) {
        Path path = pluginDir.resolve(MARKETPLACE_PLUGIN_DIR).resolve("lib/boot");
        if (path == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(1);
        }
        return path;
    }

    private static List<Path> loadClassPathFromDevBuildServer(@NotNull Path distDir) throws IOException {
        int responseCode;
        if (distDir == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(2);
        }
        String platformPrefix = System.getProperty("idea.platform.prefix", "idea");
        URL serverUrl = new URL("http://127.0.0.1:20854/build?platformPrefix=" + platformPrefix);
        System.out.println("Waiting for " + serverUrl + " (first launch can take up to 1-2 minute)");
        HttpURLConnection connection = (HttpURLConnection)serverUrl.openConnection();
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(300000);
        try {
            responseCode = connection.getResponseCode();
        }
        catch (ConnectException e) {
            throw new RuntimeException("Please run Dev Build Server", e);
        }
        connection.disconnect();
        if (responseCode != 200) {
            throw new RuntimeException("Dev Build server not able to handle build request, see server's log for details");
        }
        ArrayList<Path> result = new ArrayList<Path>();
        FileSystem fs = FileSystems.getDefault();
        Path excludedModuleListPath = distDir.resolve("out/dev-run/" + platformPrefix + "/libClassPath.txt");
        try (Stream<String> lineStream = Files.lines(excludedModuleListPath);){
            lineStream.forEach(s -> {
                if (!s.isEmpty()) {
                    result.add(fs.getPath((String)s, new String[0]));
                }
            });
        }
        return result;
    }

    private static boolean shouldInstallMarketplace(@NotNull Path homePath, @NotNull Path mpBoot) {
        block30: {
            if (homePath == null) {
                BootstrapClassLoaderUtil.$$$reportNull$$$0(3);
            }
            if (mpBoot == null) {
                BootstrapClassLoaderUtil.$$$reportNull$$$0(4);
            }
            if (!Files.exists(mpBoot, new LinkOption[0])) {
                return false;
            }
            try {
                BufferedReader reader2;
                SimpleVersion ideVersion = null;
                try {
                    reader2 = Files.newBufferedReader(homePath.resolve("build.txt"));
                    try {
                        ideVersion = SimpleVersion.parse(reader2.readLine());
                    }
                    finally {
                        if (reader2 != null) {
                            reader2.close();
                        }
                    }
                }
                catch (IOException reader2) {
                    // empty catch block
                }
                if (ideVersion == null && SystemInfoRt.isMac) {
                    reader2 = Files.newBufferedReader(homePath.resolve("Resources/build.txt"));
                    try {
                        ideVersion = SimpleVersion.parse(reader2.readLine());
                    }
                    finally {
                        if (reader2 != null) {
                            reader2.close();
                        }
                    }
                }
                if (ideVersion == null) break block30;
                SimpleVersion sinceVersion = null;
                SimpleVersion untilVersion = null;
                try (BufferedReader reader3 = Files.newBufferedReader(Paths.get(PathManager.getPluginsPath(), new String[0]).resolve(MARKETPLACE_PLUGIN_DIR).resolve("platform-build.txt"));){
                    sinceVersion = SimpleVersion.parse(reader3.readLine());
                    untilVersion = SimpleVersion.parse(reader3.readLine());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return ideVersion.isCompatible(sinceVersion, untilVersion);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    private static void addIdeaLibraries(@NotNull Path distDir, @NotNull Collection<Path> classpath) throws IOException {
        if (distDir == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(5);
        }
        if (classpath == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(6);
        }
        Path classPathFile = (SystemInfoRt.isMac ? distDir.resolve("Resources") : distDir).resolve(CLASSPATH_ORDER_FILE);
        try (Stream<String> stream2 = Files.lines(classPathFile);){
            stream2.forEach(jarName -> {
                if (!jarName.isEmpty()) {
                    classpath.add(distDir.resolve((String)jarName));
                }
            });
            return;
        }
        catch (NoSuchFileException stream2) {
        }
        catch (Exception e) {
            BootstrapClassLoaderUtil.getLogger().error("Cannot read " + classPathFile + ": ", (Throwable)e);
        }
        Class<BootstrapClassLoaderUtil> aClass = BootstrapClassLoaderUtil.class;
        String selfRootPath = PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
        assert (selfRootPath != null);
        Path selfRoot = Paths.get(selfRootPath, new String[0]);
        classpath.add(selfRoot);
        Path libFolder = Paths.get(PathManager.getLibPath(), new String[0]);
        BootstrapClassLoaderUtil.addLibraries(classpath, libFolder, selfRoot);
        BootstrapClassLoaderUtil.addLibraries(classpath, libFolder.resolve("ant/lib"), null);
    }

    private static void addLibraries(Collection<Path> classPath, Path fromDir, @Nullable Path selfRoot) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(fromDir);){
            for (Path file : dirStream) {
                String path = file.toString();
                int lastDotIndex = path.length() - 4;
                if (lastDotIndex <= 0 || path.charAt(lastDotIndex) != '.' || !path.regionMatches(true, lastDotIndex + 1, "jar", 0, 3) && !path.regionMatches(true, lastDotIndex + 1, "zip", 0, 3) || selfRoot != null && selfRoot.equals(file)) continue;
                classPath.add(file);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private static void parseClassPathString(@Nullable String pathString, @NotNull Collection<Path> classpath) {
        if (classpath == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(7);
        }
        if (pathString == null || pathString.isEmpty()) {
            return;
        }
        String libPath = PathManager.getLibPath();
        StringTokenizer tokenizer = new StringTokenizer(pathString, File.pathSeparator + ",", false);
        while (tokenizer.hasMoreTokens()) {
            String pathItem = tokenizer.nextToken();
            if (pathItem.startsWith(libPath)) continue;
            classpath.add(Paths.get(pathItem, new String[0]));
        }
    }

    @NotNull
    private static List<Path> filterClassPath(@NotNull Collection<Path> classpath) {
        String ignoreProperty;
        if (classpath == null) {
            BootstrapClassLoaderUtil.$$$reportNull$$$0(8);
        }
        if ((ignoreProperty = System.getProperty(PROPERTY_IGNORE_CLASSPATH)) != null) {
            Pattern pattern = Pattern.compile(ignoreProperty);
            Iterator<Path> i = classpath.iterator();
            while (i.hasNext()) {
                String url = i.next().toString();
                if (!pattern.matcher(url).matches()) continue;
                i.remove();
            }
        }
        return new ArrayList<Path>(classpath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/BootstrapClassLoaderUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mpBoot";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findMarketplaceBootDir";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/BootstrapClassLoaderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadClassPathFromDevBuildServer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldInstallMarketplace";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addIdeaLibraries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseClassPathString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterClassPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SimpleVersion
    implements Comparable<SimpleVersion> {
        private final int myMajor;
        private final int myMinor;

        SimpleVersion(int major, int minor) {
            this.myMajor = major;
            this.myMinor = minor;
        }

        public boolean isAtLeast(@NotNull Comparable<? super SimpleVersion> ver) {
            if (ver == null) {
                SimpleVersion.$$$reportNull$$$0(0);
            }
            return ver.compareTo(this) <= 0;
        }

        public boolean isCompatible(@Nullable SimpleVersion since, @Nullable SimpleVersion until) {
            if (since != null && until != null) {
                return this.compareTo(since) >= 0 && this.compareTo(until) <= 0;
            }
            if (since != null) {
                return this.isAtLeast(since);
            }
            if (until != null) {
                return until.isAtLeast(this);
            }
            return true;
        }

        @Override
        public int compareTo(@NotNull SimpleVersion ver) {
            if (ver == null) {
                SimpleVersion.$$$reportNull$$$0(1);
            }
            return this.myMajor != ver.myMajor ? Integer.compare(this.myMajor, ver.myMajor) : Integer.compare(this.myMinor, ver.myMinor);
        }

        @Nullable
        public static SimpleVersion parse(@Nullable String text) {
            if (text == null || text.isEmpty()) {
                return null;
            }
            try {
                int dot;
                text = text.trim();
                int dash = text.lastIndexOf(45);
                if (dash >= 0) {
                    text = text.substring(dash + 1);
                }
                if ((dot = text.indexOf(46)) >= 0) {
                    return new SimpleVersion(Integer.parseInt(text.substring(0, dot)), SimpleVersion.parseMinor(text.substring(dot + 1)));
                }
                return new SimpleVersion(Integer.parseInt(text), 0);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        private static int parseMinor(String text) {
            try {
                if ("*".equals(text) || "SNAPSHOT".equals(text)) {
                    return Integer.MAX_VALUE;
                }
                int dot = text.indexOf(46);
                return Integer.parseInt(dot >= 0 ? text.substring(0, dot) : text);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "ver";
            objectArray2[1] = "com/intellij/ide/BootstrapClassLoaderUtil$SimpleVersion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAtLeast";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

