/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.DynamicBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.maddyhome.idea.copyright.CopyrightProfileKt;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.options.Options;
import com.maddyhome.idea.copyright.pattern.EntityUtil;
import com.maddyhome.idea.copyright.pattern.VelocityHelper;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import com.maddyhome.idea.copyright.ui.TemplateOptionsPanelListener;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateCommentPanel
implements SearchableConfigurable {
    @Nullable
    private final FileType fileType;
    private final TemplateCommentPanel parentPanel;
    private final Project myProject;
    private JRadioButton[] fileLocations = null;
    private JTextArea preview;
    private JPanel mainPanel;
    private JRadioButton rbBefore;
    private JRadioButton rbAfter;
    private JPanel fileLocationPanel;
    private JRadioButton myUseDefaultSettingsRadioButton;
    private JRadioButton myUseCustomFormattingOptionsRadioButton;
    private JRadioButton myNoCopyright;
    private JRadioButton rbLineComment;
    private JCheckBox cbPrefixLines;
    private JRadioButton rbBlockComment;
    private JPanel myCommentTypePanel;
    private JCheckBox cbSeparatorBefore;
    private JTextField txtLengthBefore;
    private JTextField txtLengthAfter;
    private JCheckBox cbAddBlank;
    private JCheckBox cbSeparatorAfter;
    private JCheckBox cbBox;
    private JTextField txtFiller;
    private JPanel myBorderPanel;
    private JLabel lblLengthBefore;
    private JLabel lblLengthAfter;
    private JLabel mySeparatorCharLabel;
    private JPanel myRelativeLocationPanel;
    private final EventListenerList listeners;
    private final boolean allowBlock;

    private void updateBox() {
        boolean enable = true;
        if (!this.cbSeparatorBefore.isSelected() || !this.cbSeparatorAfter.isSelected()) {
            enable = false;
        } else if (!this.txtLengthBefore.getText().equals(this.txtLengthAfter.getText())) {
            enable = false;
        }
        boolean either = this.cbSeparatorBefore.isSelected() || this.cbSeparatorAfter.isSelected();
        this.cbBox.setEnabled(enable);
        this.txtFiller.setEnabled(either);
    }

    public TemplateCommentPanel(FileType fileType, TemplateCommentPanel parentPanel, String @NlsContexts.RadioButton [] locations, Project project) {
        this.$$$setupUI$$$();
        this.listeners = new EventListenerList();
        this.parentPanel = parentPanel;
        this.myProject = project;
        if (fileType == null) {
            this.myUseDefaultSettingsRadioButton.setVisible(false);
            this.myUseCustomFormattingOptionsRadioButton.setVisible(false);
            this.myNoCopyright.setVisible(false);
        }
        this.fileType = fileType != null ? fileType : StdFileTypes.JAVA;
        this.allowBlock = FileTypeUtil.hasBlockComment(this.fileType);
        if (parentPanel != null) {
            parentPanel.addOptionChangeListener(new TemplateOptionsPanelListener(){

                @Override
                public void optionChanged() {
                    TemplateCommentPanel.this.updateOverride();
                }
            });
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbBefore);
        group.add(this.rbAfter);
        if (locations == null) {
            this.fileLocationPanel.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.fileLocations = new JRadioButton[locations.length];
            group = new ButtonGroup();
            for (int i = 0; i < this.fileLocations.length; ++i) {
                this.fileLocations[i] = new JRadioButton(locations[i]);
                group.add(this.fileLocations[i]);
                this.fileLocationPanel.add((Component)this.fileLocations[i], new GridConstraints(i, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            }
        }
        this.addOptionChangeListener(new TemplateOptionsPanelListener(){

            @Override
            public void optionChanged() {
                TemplateCommentPanel.this.showPreview(TemplateCommentPanel.this.getOptions());
            }
        });
        this.preview.setFont(EditorFontType.getGlobalPlainFont());
        this.myUseDefaultSettingsRadioButton.setSelected(true);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateCommentPanel.this.updateOverride();
            }
        };
        this.myUseDefaultSettingsRadioButton.addActionListener(listener);
        this.myUseCustomFormattingOptionsRadioButton.addActionListener(listener);
        this.myNoCopyright.addActionListener(listener);
        this.txtLengthBefore.setText("80");
        this.txtLengthAfter.setText("80");
        this.rbBlockComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateCommentPanel.this.cbPrefixLines.setEnabled(TemplateCommentPanel.this.rbBlockComment.isSelected());
                TemplateCommentPanel.this.fireChangeEvent();
            }
        });
        this.rbLineComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateCommentPanel.this.cbPrefixLines.setEnabled(TemplateCommentPanel.this.rbBlockComment.isSelected());
                TemplateCommentPanel.this.fireChangeEvent();
            }
        });
        this.cbPrefixLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateCommentPanel.this.fireChangeEvent();
            }
        });
        this.cbSeparatorBefore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateCommentPanel.this.lblLengthBefore.setEnabled(TemplateCommentPanel.this.cbSeparatorBefore.isSelected());
                TemplateCommentPanel.this.txtLengthBefore.setEnabled(TemplateCommentPanel.this.cbSeparatorBefore.isSelected());
                TemplateCommentPanel.this.fireChangeEvent();
                TemplateCommentPanel.this.updateBox();
            }
        });
        this.cbSeparatorAfter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateCommentPanel.this.lblLengthAfter.setEnabled(TemplateCommentPanel.this.cbSeparatorAfter.isSelected());
                TemplateCommentPanel.this.txtLengthAfter.setEnabled(TemplateCommentPanel.this.cbSeparatorAfter.isSelected());
                TemplateCommentPanel.this.fireChangeEvent();
                TemplateCommentPanel.this.updateBox();
            }
        });
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                TemplateCommentPanel.this.fireChangeEvent();
                TemplateCommentPanel.this.updateBox();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/maddyhome/idea/copyright/ui/TemplateCommentPanel$9", "textChanged"));
            }
        };
        this.txtLengthBefore.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.txtLengthAfter.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.txtFiller.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.cbBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TemplateCommentPanel.this.fireChangeEvent();
            }
        });
    }

    public LanguageOptions getOptions() {
        LanguageOptions res = new LanguageOptions();
        res.setBlock(this.rbBlockComment.isSelected());
        res.setPrefixLines(!this.allowBlock || this.cbPrefixLines.isSelected());
        res.setSeparateAfter(this.cbSeparatorAfter.isSelected());
        res.setSeparateBefore(this.cbSeparatorBefore.isSelected());
        try {
            res.setLenBefore(Integer.parseInt(this.txtLengthBefore.getText()));
            res.setLenAfter(Integer.parseInt(this.txtLengthAfter.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        res.setBox(this.cbBox.isSelected());
        String filler = this.txtFiller.getText();
        if (filler.length() > 0) {
            res.setFiller(filler);
        } else {
            res.setFiller(" ");
        }
        res.setFileTypeOverride(this.getOverrideChoice());
        res.setRelativeBefore(this.rbBefore.isSelected());
        res.setAddBlankAfter(this.cbAddBlank.isSelected());
        if (this.fileLocations != null) {
            for (int i = 0; i < this.fileLocations.length; ++i) {
                if (!this.fileLocations[i].isSelected()) continue;
                res.setFileLocation(i + 1);
            }
        }
        return res;
    }

    private int getOverrideChoice() {
        return this.myUseDefaultSettingsRadioButton.isSelected() ? 2 : (this.myNoCopyright.isSelected() ? 1 : 3);
    }

    private void updateOverride() {
        int choice = this.getOverrideChoice();
        LanguageOptions parentOpts = this.parentPanel != null ? this.parentPanel.getOptions() : null;
        switch (choice) {
            case 1: {
                this.enableFormattingOptions(false);
                this.showPreview(this.getOptions());
                this.myRelativeLocationPanel.setEnabled(false);
                this.rbBefore.setEnabled(false);
                this.rbAfter.setEnabled(false);
                this.cbAddBlank.setEnabled(false);
                if (this.fileLocations == null) break;
                for (JRadioButton fileLocation : this.fileLocations) {
                    fileLocation.setEnabled(false);
                }
                break;
            }
            case 2: {
                boolean isTemplate = this.parentPanel == null;
                this.enableFormattingOptions(isTemplate);
                this.showPreview(parentOpts != null ? parentOpts : this.getOptions());
                this.myRelativeLocationPanel.setEnabled(isTemplate);
                this.rbBefore.setEnabled(isTemplate);
                this.rbAfter.setEnabled(isTemplate);
                this.cbAddBlank.setEnabled(isTemplate);
                if (this.fileLocations == null) break;
                for (JRadioButton fileLocation : this.fileLocations) {
                    fileLocation.setEnabled(true);
                }
                break;
            }
            case 3: {
                this.enableFormattingOptions(true);
                this.showPreview(this.getOptions());
                this.myRelativeLocationPanel.setEnabled(true);
                this.rbBefore.setEnabled(true);
                this.rbAfter.setEnabled(true);
                this.cbAddBlank.setEnabled(true);
                if (this.fileLocations == null) break;
                for (JRadioButton fileLocation : this.fileLocations) {
                    fileLocation.setEnabled(true);
                }
                break;
            }
        }
    }

    private void enableFormattingOptions(boolean enable) {
        if (enable) {
            this.myCommentTypePanel.setEnabled(true);
            this.myBorderPanel.setEnabled(true);
            this.rbBlockComment.setEnabled(true);
            this.rbLineComment.setEnabled(true);
            this.cbPrefixLines.setEnabled(this.allowBlock);
            this.cbSeparatorBefore.setEnabled(true);
            this.cbSeparatorAfter.setEnabled(true);
            this.lblLengthBefore.setEnabled(this.cbSeparatorBefore.isSelected());
            this.txtLengthBefore.setEnabled(this.cbSeparatorBefore.isSelected());
            this.lblLengthAfter.setEnabled(this.cbSeparatorAfter.isSelected());
            this.txtLengthAfter.setEnabled(this.cbSeparatorAfter.isSelected());
            this.mySeparatorCharLabel.setEnabled(true);
            this.updateBox();
        } else {
            UIUtil.setEnabled((Component)this.myCommentTypePanel, (boolean)false, (boolean)true);
            UIUtil.setEnabled((Component)this.myBorderPanel, (boolean)false, (boolean)true);
        }
    }

    private void showPreview(LanguageOptions options) {
        String defaultCopyrightText = this.myNoCopyright.isSelected() ? "" : FileTypeUtil.buildComment(this.fileType, VelocityHelper.evaluate(null, null, null, EntityUtil.decode(CopyrightProfileKt.DEFAULT_COPYRIGHT_NOTICE)), options);
        SwingUtilities.invokeLater(() -> this.preview.setText(defaultCopyrightText));
    }

    public FileType getFileType() {
        return this.fileType;
    }

    @Nls
    public String getDisplayName() {
        return this.fileType instanceof LanguageFileType ? ((LanguageFileType)this.fileType).getLanguage().getDisplayName() : this.fileType.getDisplayName();
    }

    @NotNull
    public String getHelpTopic() {
        return "copyright.filetypes";
    }

    public JComponent createComponent() {
        return this.mainPanel;
    }

    public boolean isModified() {
        if (this.parentPanel == null) {
            return !this.getCopyrightOptions().getTemplateOptions().equals(this.getOptions());
        }
        return !this.getCopyrightOptions().getOptions(this.fileType.getName()).equals(this.getOptions());
    }

    @NotNull
    private Options getCopyrightOptions() {
        Options options = CopyrightManager.getInstance(this.myProject).getOptions();
        if (options == null) {
            TemplateCommentPanel.$$$reportNull$$$0(0);
        }
        return options;
    }

    public void apply() throws ConfigurationException {
        Options options = this.getCopyrightOptions();
        if (this.parentPanel == null) {
            options.setTemplateOptions(this.getOptions());
        } else {
            options.setOptions(this.fileType.getName(), this.getOptions());
        }
    }

    public void reset() {
        LanguageOptions options = this.parentPanel == null ? this.getCopyrightOptions().getTemplateOptions() : this.getCopyrightOptions().getOptions(this.fileType.getName());
        boolean isBlock = options.isBlock();
        if (isBlock) {
            this.rbBlockComment.setSelected(true);
        } else {
            this.rbLineComment.setSelected(true);
        }
        this.cbPrefixLines.setSelected(!this.allowBlock || options.isPrefixLines());
        this.cbSeparatorAfter.setSelected(options.isSeparateAfter());
        this.cbSeparatorBefore.setSelected(options.isSeparateBefore());
        this.txtLengthBefore.setText(String.valueOf(options.getLenBefore()));
        this.txtLengthAfter.setText(String.valueOf(options.getLenAfter()));
        this.txtFiller.setText(options.getFiller() == " " ? "" : options.getFiller());
        this.cbBox.setSelected(options.isBox());
        int fileTypeOverride = options.getFileTypeOverride();
        this.myUseDefaultSettingsRadioButton.setSelected(fileTypeOverride == 2);
        this.myUseCustomFormattingOptionsRadioButton.setSelected(fileTypeOverride == 3);
        this.myNoCopyright.setSelected(fileTypeOverride == 1);
        if (options.isRelativeBefore()) {
            this.rbBefore.setSelected(true);
        } else {
            this.rbAfter.setSelected(true);
        }
        this.cbAddBlank.setSelected(options.isAddBlankAfter());
        if (this.fileLocations != null) {
            int choice = options.getFileLocation() - 1;
            choice = Math.max(0, Math.min(choice, this.fileLocations.length - 1));
            this.fileLocations[choice].setSelected(true);
        }
        this.updateOverride();
    }

    public void addOptionChangeListener(TemplateOptionsPanelListener listener) {
        this.listeners.add(TemplateOptionsPanelListener.class, listener);
    }

    private void fireChangeEvent() {
        Object[] fires = this.listeners.getListenerList();
        for (int i = fires.length - 2; i >= 0; i -= 2) {
            if (fires[i] != TemplateOptionsPanelListener.class) continue;
            ((TemplateOptionsPanelListener)fires[i + 1]).optionChanged();
        }
    }

    @NotNull
    public String getId() {
        Object object = this.fileType != null ? this.getHelpTopic() + "." + this.fileType.getName() : this.getHelpTopic();
        if (object == null) {
            TemplateCommentPanel.$$$reportNull$$$0(1);
        }
        return object;
    }

    @NotNull
    public Class<?> getOriginalClass() {
        UpdateCopyrightsProvider provider = this.fileType != null ? (UpdateCopyrightsProvider)CopyrightUpdaters.INSTANCE.forFileType(this.fileType) : null;
        Class<?> clazz = provider != null ? provider.getClass() : super.getClass();
        if (clazz == null) {
            TemplateCommentPanel.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/maddyhome/idea/copyright/ui/TemplateCommentPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyrightOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalClass";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JTextField jTextField2;
        JTextField jTextField3;
        JLabel jLabel2;
        JLabel jLabel3;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel2;
        JCheckBox jCheckBox5;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel3;
        JRadioButton jRadioButton5;
        JPanel jPanel4;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JTextArea jTextArea;
        JPanel jPanel5;
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(6, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel7.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.preview = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jBScrollPane.setViewportView(jTextArea);
        this.myUseDefaultSettingsRadioButton = jRadioButton7 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton7, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.use.default.settings"));
        jPanel5.add((Component)jRadioButton7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseCustomFormattingOptionsRadioButton = jRadioButton6 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton6, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.use.custom.formatting.options"));
        jPanel5.add((Component)jRadioButton6, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.fileLocationPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel4, new GridConstraints(5, 0, 1, 2, 1, 1, 4, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.location.in.file"), (int)0, (int)0, null, null));
        this.myNoCopyright = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.no.copyright"));
        jPanel5.add((Component)jRadioButton5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCommentTypePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.comment.type"), (int)0, (int)0, null, null));
        this.rbBlockComment = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.use.block.comment"));
        jPanel3.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.rbLineComment = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.use.line.comment"));
        jPanel3.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.cbPrefixLines = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.prefix.each.line"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myBorderPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel2, new GridConstraints(3, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.borders"), (int)0, (int)0, null, null));
        this.cbSeparatorBefore = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.separator.before"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.cbSeparatorAfter = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.separator.after"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.lblLengthBefore = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.length"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.lblLengthAfter = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.length"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.txtLengthBefore = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 3, 1, 1, 8, 0, 6, 0, null, new Dimension(50, -1), null));
        this.txtLengthAfter = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 3, 1, 1, 8, 0, 6, 0, null, new Dimension(50, -1), null));
        this.cbAddBlank = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.add.blank.line.after"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.mySeparatorCharLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.separator"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.cbBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.box"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.txtFiller = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(50, -1), null));
        this.myRelativeLocationPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.relative.location"), (int)0, (int)0, null, null));
        this.rbBefore = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.before.other.comments"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.rbAfter = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/CopyrightBundle", TemplateCommentPanel.class).getString("settings.copyright.formatting.after.other.comments"));
        jPanel.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel3.setLabelFor(jTextField3);
        jLabel2.setLabelFor(jTextField2);
        jLabel.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton7);
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton5);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

