/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.internal.statistic.eventLog.DeviceConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogInternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogInternalRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.connection.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.connection.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.connection.EventLogUploadSettingsService;
import com.intellij.internal.statistic.eventLog.connection.StatisticsService;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class StatisticsUploadAssistant {
    private static final String IDEA_HEADLESS_ENABLE_STATISTICS = "idea.headless.enable.statistics";
    private static final String IDEA_SUPPRESS_REPORT_STATISTICS = "idea.suppress.statistics.report";
    private static final String ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT = "idea.local.statistics.without.report";
    public static final Object LOCK = new Object();

    private StatisticsUploadAssistant() {
    }

    public static boolean isSendAllowed() {
        if (StatisticsUploadAssistant.isSuppressStatisticsReport() || StatisticsUploadAssistant.isLocalStatisticsWithoutReport()) {
            return false;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return StatisticsUploadAssistant.isHeadlessStatisticsEnabled();
        }
        UsageStatisticsPersistenceComponent settings = UsageStatisticsPersistenceComponent.getInstance();
        return settings != null && settings.isAllowed();
    }

    public static boolean isCollectAllowed() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return StatisticsUploadAssistant.isHeadlessStatisticsEnabled();
        }
        UsageStatisticsPersistenceComponent settings = UsageStatisticsPersistenceComponent.getInstance();
        return settings != null && settings.isAllowed() || StatisticsUploadAssistant.isLocalStatisticsWithoutReport();
    }

    private static boolean isHeadlessStatisticsEnabled() {
        return Boolean.getBoolean(IDEA_HEADLESS_ENABLE_STATISTICS);
    }

    public static boolean isTestStatisticsEnabled() {
        return StatisticsUploadAssistant.isLocalStatisticsWithoutReport() || StatisticsUploadAssistant.isTeamcityDetected();
    }

    @NotNull
    public static StatisticsService getEventLogStatisticsService(final @NotNull String recorderId) {
        if (recorderId == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(0);
        }
        EventLogSendListener listener = new EventLogSendListener(){

            @Override
            public void onLogsSend(@NotNull List<String> successfullySentFiles, @NotNull List<Integer> errors, int totalLocalFiles) {
                if (successfullySentFiles == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (errors == null) {
                    1.$$$reportNull$$$0(1);
                }
                int success = successfullySentFiles.size();
                int failed = errors.size();
                EventLogSystemLogger.logFilesSend(recorderId, totalLocalFiles, success, failed, false, successfullySentFiles, errors);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "successfullySentFiles";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "errors";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/utils/StatisticsUploadAssistant$1";
                objectArray[2] = "onLogsSend";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        EventLogRecorderConfiguration configuration = EventLogConfiguration.INSTANCE.getOrCreate(recorderId);
        return new EventLogStatisticsService(new DeviceConfiguration(configuration.getDeviceId(), configuration.getBucket()), (EventLogRecorderConfig)new EventLogInternalRecorderConfig(recorderId), new EventLogInternalApplicationInfo(recorderId, false), listener);
    }

    public static EventLogUploadSettingsService createExternalSettings(@NotNull String recorderId, boolean isTest, long cacheTimeoutMs) {
        if (recorderId == null) {
            StatisticsUploadAssistant.$$$reportNull$$$0(1);
        }
        return new EventLogUploadSettingsService(recorderId, new EventLogInternalApplicationInfo(recorderId, isTest), cacheTimeoutMs);
    }

    public static boolean isTeamcityDetected() {
        return StringUtil.isNotEmpty((String)System.getenv("TEAMCITY_VERSION"));
    }

    public static boolean isSuppressStatisticsReport() {
        return Boolean.getBoolean(IDEA_SUPPRESS_REPORT_STATISTICS);
    }

    public static boolean isLocalStatisticsWithoutReport() {
        return Boolean.getBoolean(ENABLE_LOCAL_STATISTICS_WITHOUT_REPORT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "recorderId";
        objectArray2[1] = "com/intellij/internal/statistic/utils/StatisticsUploadAssistant";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventLogStatisticsService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createExternalSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

