/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetector;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\f\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0010\u0010\u0014\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0003\"\u0011\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0003\u00a8\u0006\u0017"}, d2={"builtFromSources", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "getBuiltFromSources", "()Lcom/intellij/internal/statistic/utils/PluginInfo;", "notListedPlugin", "platformPlugin", "getPlatformPlugin", "unknownPlugin", "getUnknownPlugin", "findPluginTypeByValue", "Lcom/intellij/internal/statistic/utils/PluginType;", "value", "", "getPluginInfo", "clazz", "Ljava/lang/Class;", "className", "getPluginInfoByDescriptor", "plugin", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getPluginInfoById", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "intellij.platform.statistics"})
public final class PluginInfoDetectorKt {
    @NotNull
    private static final PluginInfo platformPlugin = new PluginInfo(PluginType.PLATFORM, null, null);
    @NotNull
    private static final PluginInfo unknownPlugin = new PluginInfo(PluginType.UNKNOWN, null, null);
    private static final PluginInfo notListedPlugin = new PluginInfo(PluginType.NOT_LISTED, null, null);
    @NotNull
    private static final PluginInfo builtFromSources = new PluginInfo(PluginType.FROM_SOURCES, null, null);

    @NotNull
    public static final PluginInfo getPluginInfo(@NotNull Class<?> clazz) {
        PluginInfo pluginInfo;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof PluginAwareClassLoader) {
            PluginDescriptor pluginDescriptor = ((PluginAwareClassLoader)classLoader).getPluginDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"classLoader.pluginDescriptor");
            pluginInfo = PluginInfoDetectorKt.getPluginInfoByDescriptor(pluginDescriptor);
        } else if (PluginManagerCore.isRunningFromSources() && !PluginManagerCore.isUnitTestMode) {
            pluginInfo = builtFromSources;
        } else {
            String string = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.name");
            pluginInfo = PluginInfoDetectorKt.getPluginInfo(string);
        }
        return pluginInfo;
    }

    @NotNull
    public static final PluginInfo getPluginInfo(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (StringsKt.startsWith$default((String)className, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"javax.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"kotlin.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"groovy.", (boolean)false, (int)2, null)) {
            return platformPlugin;
        }
        PluginDescriptor pluginDescriptor = PluginManagerCore.getPluginDescriptorOrPlatformByClassName((String)className);
        if (pluginDescriptor == null) {
            return unknownPlugin;
        }
        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"PluginManagerCore.getPlu\u2026) ?: return unknownPlugin");
        PluginDescriptor plugin = pluginDescriptor;
        return PluginInfoDetectorKt.getPluginInfoByDescriptor(plugin);
    }

    @NotNull
    public static final PluginInfo getPluginInfoById(@Nullable PluginId pluginId) {
        if (pluginId == null) {
            return unknownPlugin;
        }
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)pluginId);
        if (plugin == null) {
            return PluginInfoDetector.INSTANCE.isPluginFromOfficialJbPluginRepo$intellij_platform_statistics(pluginId) ? new PluginInfo(PluginType.LISTED, pluginId.getIdString(), null) : unknownPlugin;
        }
        return PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)plugin);
    }

    @NotNull
    public static final PluginInfo getPluginInfoByDescriptor(@NotNull PluginDescriptor plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        if (Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)plugin.getPluginId())) {
            return platformPlugin;
        }
        PluginId pluginId = plugin.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"plugin.pluginId");
        String string = pluginId.getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.pluginId.idString");
        String id = string;
        String version = plugin.getVersion();
        if (PluginManager.getInstance().isDevelopedByJetBrains(plugin)) {
            PluginType pluginType = plugin.isBundled() ? PluginType.JB_BUNDLED : (PluginManagerCore.isUpdatedBundledPlugin((PluginDescriptor)plugin) ? PluginType.JB_UPDATED_BUNDLED : PluginType.JB_NOT_BUNDLED);
            return new PluginInfo(pluginType, id, version);
        }
        boolean listed = !plugin.isBundled() && !PluginManagerCore.isUpdatedBundledPlugin((PluginDescriptor)plugin) && PluginInfoDetector.INSTANCE.isSafeToReportFrom$intellij_platform_statistics(plugin);
        return listed ? new PluginInfo(PluginType.LISTED, id, version) : notListedPlugin;
    }

    @Nullable
    public static final PluginType findPluginTypeByValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        for (PluginType type : PluginType.values()) {
            if (!Intrinsics.areEqual((Object)type.name(), (Object)value)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static final PluginInfo getPlatformPlugin() {
        return platformPlugin;
    }

    @NotNull
    public static final PluginInfo getUnknownPlugin() {
        return unknownPlugin;
    }

    @NotNull
    public static final PluginInfo getBuiltFromSources() {
        return builtFromSources;
    }
}

