/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.ValidationRuleStorage;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.eventLog.validator.storage.IntellijValidationRulesStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationRulesStorageProvider;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijSensitiveDataValidator
extends SensitiveDataValidator<IntellijValidationRulesStorage> {
    private static final ConcurrentMap<String, IntellijSensitiveDataValidator> ourInstances = new ConcurrentHashMap<String, IntellijSensitiveDataValidator>();
    private final String myRecorderId;

    @NotNull
    public static IntellijSensitiveDataValidator getInstance(@NotNull String recorderId) {
        if (recorderId == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(0);
        }
        IntellijSensitiveDataValidator intellijSensitiveDataValidator = ourInstances.computeIfAbsent(recorderId, id -> {
            IntellijValidationRulesStorage storage = ValidationRulesStorageProvider.newStorage(recorderId);
            return ApplicationManager.getApplication().isUnitTestMode() ? new BlindSensitiveDataValidator(storage, recorderId) : new IntellijSensitiveDataValidator(storage, recorderId);
        });
        if (intellijSensitiveDataValidator == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(1);
        }
        return intellijSensitiveDataValidator;
    }

    @Nullable
    public static IntellijSensitiveDataValidator getIfInitialized(@NotNull String recorderId) {
        if (recorderId == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(2);
        }
        return (IntellijSensitiveDataValidator)((Object)ourInstances.get(recorderId));
    }

    protected IntellijSensitiveDataValidator(@NotNull IntellijValidationRulesStorage storage, @NotNull String recorderId) {
        if (storage == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(3);
        }
        if (recorderId == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(4);
        }
        super((ValidationRuleStorage)storage);
        this.myRecorderId = recorderId;
    }

    public boolean isGroupAllowed(@NotNull EventLogGroup group) {
        if (group == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(5);
        }
        if (StatisticsRecorderUtil.isTestModeEnabled(this.myRecorderId)) {
            return true;
        }
        IntellijValidationRulesStorage storage = (IntellijValidationRulesStorage)this.getValidationRulesStorage();
        if (storage.isUnreachable()) {
            return true;
        }
        return storage.getGroupRules(group.getId()) != null;
    }

    @NotNull
    public Map<String, Object> guaranteeCorrectEventData(@NotNull EventContext context, EventGroupRules groupRules) {
        if (context == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(6);
        }
        if (this.isTestModeEnabled(groupRules)) {
            Map map = context.eventData;
            if (map == null) {
                IntellijSensitiveDataValidator.$$$reportNull$$$0(7);
            }
            return map;
        }
        Map validatedData = super.guaranteeCorrectEventData(context, groupRules);
        boolean containsPluginInfo = validatedData.containsKey("plugin") || validatedData.containsKey("plugin_type") || validatedData.containsKey("plugin_version");
        PluginInfo pluginInfo = (PluginInfo)context.getPayload(CustomValidationRule.PLUGIN_INFO);
        if (pluginInfo != null && !containsPluginInfo) {
            StatisticsUtilKt.addPluginInfoTo(pluginInfo, validatedData);
        }
        Map map = validatedData;
        if (map == null) {
            IntellijSensitiveDataValidator.$$$reportNull$$$0(8);
        }
        return map;
    }

    private boolean isTestModeEnabled(@Nullable EventGroupRules rule) {
        return StatisticsRecorderUtil.isTestModeEnabled(this.myRecorderId) && rule != null && ContainerUtil.exists((Object[])rule.getEventIdRules(), r -> r instanceof TestModeValidationRule);
    }

    public void update() {
        ((IntellijValidationRulesStorage)this.getValidationRulesStorage()).update();
    }

    public void reload() {
        ((IntellijValidationRulesStorage)this.getValidationRulesStorage()).reload();
    }

    static {
        CustomValidationRule.EP_NAME.addChangeListener(ourInstances::clear, null);
        CustomWhiteListRule.EP_NAME.addChangeListener(ourInstances::clear, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/IntellijSensitiveDataValidator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/IntellijSensitiveDataValidator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "guaranteeCorrectEventData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIfInitialized";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isGroupAllowed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "guaranteeCorrectEventData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BlindSensitiveDataValidator
    extends IntellijSensitiveDataValidator {
        protected BlindSensitiveDataValidator(@NotNull IntellijValidationRulesStorage storage, @NotNull String recorderId) {
            if (storage == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(0);
            }
            if (recorderId == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(1);
            }
            super(storage, recorderId);
        }

        @NotNull
        public String guaranteeCorrectEventId(@NotNull EventContext context, @Nullable EventGroupRules groupRules) {
            if (context == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(2);
            }
            String string = context.eventId;
            if (string == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public Map<String, Object> guaranteeCorrectEventData(@NotNull EventContext context, EventGroupRules groupRules) {
            if (context == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(4);
            }
            Map map = context.eventData;
            if (map == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(5);
            }
            return map;
        }

        @Override
        public boolean isGroupAllowed(@NotNull EventLogGroup group) {
            if (group == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(6);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recorderId";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/IntellijSensitiveDataValidator$BlindSensitiveDataValidator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/IntellijSensitiveDataValidator$BlindSensitiveDataValidator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "guaranteeCorrectEventId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "guaranteeCorrectEventData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "guaranteeCorrectEventId";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "guaranteeCorrectEventData";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isGroupAllowed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

