/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.fus;

import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.StatisticsFileEventLogger;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageStateEventTrackerKt;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ*\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001dJ\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ0\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001dJ\u0006\u0010 \u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/intellij/internal/statistic/eventLog/fus/FeatureUsageLogger;", "", "()V", "configVersion", "", "getConfigVersion$annotations", "getConfigVersion", "()I", "<set-?>", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "loggerProvider", "getLoggerProvider$intellij_platform_statistics", "()Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "setLoggerProvider$intellij_platform_statistics", "(Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;)V", "cleanup", "", "flush", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "getConfig", "isEnabled", "", "log", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "action", "", "data", "", "groupId", "logState", "rollOver", "intellij.platform.statistics"})
public final class FeatureUsageLogger {
    @NotNull
    private static StatisticsEventLoggerProvider loggerProvider;
    @NotNull
    public static final FeatureUsageLogger INSTANCE;

    @NotNull
    public final StatisticsEventLoggerProvider getLoggerProvider$intellij_platform_statistics() {
        return loggerProvider;
    }

    @TestOnly
    public final void setLoggerProvider$intellij_platform_statistics(@NotNull StatisticsEventLoggerProvider statisticsEventLoggerProvider) {
        Intrinsics.checkNotNullParameter((Object)statisticsEventLoggerProvider, (String)"<set-?>");
        loggerProvider = statisticsEventLoggerProvider;
    }

    @NotNull
    public final CompletableFuture<Void> log(@NotNull EventLogGroup group, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return loggerProvider.getLogger().logAsync(group, action, false);
    }

    public final void log(@NotNull EventLogGroup group, @NotNull String action, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        loggerProvider.getLogger().logAsync(group, action, data, false);
    }

    @NotNull
    public final CompletableFuture<Void> logState(@NotNull EventLogGroup group, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return loggerProvider.getLogger().logAsync(group, action, true);
    }

    @NotNull
    public final CompletableFuture<Void> logState(@NotNull EventLogGroup group, @NotNull String action, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return loggerProvider.getLogger().logAsync(group, action, data, true);
    }

    public final void log(@NotNull String groupId, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        loggerProvider.getLogger().logAsync(new EventLogGroup(groupId, 1), action, true);
    }

    public final void cleanup() {
        loggerProvider.getLogger().cleanup();
    }

    public final void rollOver() {
        loggerProvider.getLogger().rollOver();
    }

    @NotNull
    public final CompletableFuture<Void> flush() {
        StatisticsEventLogger logger2 = loggerProvider.getLogger();
        if (logger2 instanceof StatisticsFileEventLogger) {
            return ((StatisticsFileEventLogger)logger2).flush();
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
        return completableFuture;
    }

    @NotNull
    public final StatisticsEventLoggerProvider getConfig() {
        return loggerProvider;
    }

    public final boolean isEnabled() {
        return !(loggerProvider.getLogger() instanceof EmptyStatisticsEventLogger);
    }

    @JvmStatic
    public static /* synthetic */ void getConfigVersion$annotations() {
    }

    public static final int getConfigVersion() {
        return INSTANCE.getConfig().getVersion();
    }

    private FeatureUsageLogger() {
    }

    static {
        FeatureUsageLogger featureUsageLogger;
        INSTANCE = featureUsageLogger = new FeatureUsageLogger();
        loggerProvider = StatisticsEventLogProviderUtil.getEventLogProvider("FUS");
        if (featureUsageLogger.isEnabled()) {
            FeatureUsageStateEventTrackerKt.initStateEventTrackers();
        }
    }
}

