/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.ObjectEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectListEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u001f !\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J&\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004H\u0002J/\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\r2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder;", "", "()V", "buildEventsScheme", "", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$GroupDescriptor;", "buildFields", "Ljava/util/HashSet;", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDescriptor;", "Lkotlin/collections/HashSet;", "events", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "buildObjectEvenScheme", "", "fieldName", "", "fields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "(Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;)Ljava/util/Set;", "collectGroupsFromExtensions", "", "groupType", "collectors", "", "Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "fieldSchema", "field", "validateGroupId", "", "collector", "EventDescriptor", "EventsScheme", "FieldDescriptor", "GroupDescriptor", "intellij.platform.statistics"})
public final class EventsSchemeBuilder {
    @NotNull
    public static final EventsSchemeBuilder INSTANCE;

    private final Set<FieldDescriptor> fieldSchema(EventField<?> field, String fieldName) {
        Set set;
        if (Intrinsics.areEqual(field, EventFields.PluginInfo) || Intrinsics.areEqual(field, EventFields.PluginInfoFromInstance)) {
            return SetsKt.hashSetOf((Object[])new FieldDescriptor[]{new FieldDescriptor("plugin", SetsKt.hashSetOf((Object[])new String[]{"{util#plugin}"})), new FieldDescriptor("plugin_type", SetsKt.hashSetOf((Object[])new String[]{"{util#plugin_type}"})), new FieldDescriptor("plugin_version", SetsKt.hashSetOf((Object[])new String[]{"{util#plugin_version}"}))});
        }
        EventField<?> eventField = field;
        if (eventField instanceof ObjectEventField) {
            set = this.buildObjectEvenScheme(fieldName, ((ObjectEventField)field).getFields());
        } else if (eventField instanceof ObjectListEventField) {
            set = this.buildObjectEvenScheme(fieldName, ((ObjectListEventField)field).getFields());
        } else if (eventField instanceof PrimitiveEventField) {
            set = SetsKt.hashSetOf((Object[])new FieldDescriptor[]{new FieldDescriptor(fieldName, CollectionsKt.toHashSet((Iterable)((PrimitiveEventField)field).getValidationRule()))});
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    private final Set<FieldDescriptor> buildObjectEvenScheme(String fieldName, EventField<?>[] fields) {
        boolean bl = false;
        HashSet fieldsDescriptors = new HashSet();
        for (EventField<?> eventField : fields) {
            fieldsDescriptors.addAll(this.fieldSchema(eventField, fieldName + "." + eventField.getName()));
        }
        return fieldsDescriptors;
    }

    @JvmStatic
    @NotNull
    public static final List<GroupDescriptor> buildEventsScheme() {
        boolean bl = false;
        List result = new ArrayList();
        List<FeatureUsagesCollector> list = FUCounterUsageLogger.instantiateCounterCollectors();
        Intrinsics.checkNotNullExpressionValue(list, (String)"FUCounterUsageLogger.ins\u2026ntiateCounterCollectors()");
        result.addAll((Collection)INSTANCE.collectGroupsFromExtensions("counter", (Collection<? extends FeatureUsagesCollector>)list));
        ExtensionPointName<ApplicationUsagesCollector> extensionPointName = ApplicationUsagesCollector.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"ApplicationUsagesCollector.EP_NAME");
        List list2 = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ApplicationUsagesCollector.EP_NAME.extensionList");
        result.addAll((Collection)INSTANCE.collectGroupsFromExtensions("state", list2));
        ExtensionPointName<ProjectUsagesCollector> extensionPointName2 = ProjectUsagesCollector.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName2, (String)"ProjectUsagesCollector.EP_NAME");
        List list3 = extensionPointName2.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"ProjectUsagesCollector.EP_NAME.extensionList");
        result.addAll((Collection)INSTANCE.collectGroupsFromExtensions("state", list3));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GroupDescriptor> collectGroupsFromExtensions(@NotNull String groupType, @NotNull Collection<? extends FeatureUsagesCollector> collectors) {
        Intrinsics.checkNotNullParameter((Object)groupType, (String)"groupType");
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        boolean bl = false;
        List result = new ArrayList();
        for (FeatureUsagesCollector featureUsagesCollector : collectors) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object answer$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            EventLogGroup group;
            Class<?> collectorClass = featureUsagesCollector.getClass().getEnclosingClass() != null ? featureUsagesCollector.getClass().getEnclosingClass() : featureUsagesCollector.getClass();
            this.validateGroupId(featureUsagesCollector);
            if (featureUsagesCollector.getGroup() == null) {
                continue;
            }
            Object $this$groupBy$iv = group.getEvents();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                BaseEventId it = (BaseEventId)element$iv$iv;
                boolean bl2 = false;
                key$iv$iv = it.getEventId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv;
            boolean bl4 = false;
            for (Map.Entry item$iv$iv : iterator.entrySet()) {
                void name;
                void $dstr$name$events;
                key$iv$iv = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl5 = false;
                void var20_25 = $dstr$name$events;
                boolean bl6 = false;
                answer$iv$iv$iv = (String)var20_25.getKey();
                var20_25 = $dstr$name$events;
                bl6 = false;
                List events = (List)var20_25.getValue();
                EventDescriptor eventDescriptor = new EventDescriptor((String)name, (Set<FieldDescriptor>)INSTANCE.buildFields(events));
                object.add(eventDescriptor);
            }
            HashSet eventsDescriptors = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            String string = group.getId();
            int n = group.getVersion();
            Set set = eventsDescriptors;
            Class<?> clazz = collectorClass;
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"collectorClass");
            String string2 = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"collectorClass.name");
            GroupDescriptor groupDescriptor = new GroupDescriptor(string, groupType, n, set, string2);
            result.add(groupDescriptor);
        }
        return result;
    }

    private final void validateGroupId(FeatureUsagesCollector collector) {
        try {
            collector.getGroupId();
        }
        catch (IllegalStateException e) {
            throw (Throwable)new IllegalStateException(e.getMessage() + " in " + collector.getClass().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final HashSet<FieldDescriptor> buildFields(List<? extends BaseEventId> events) {
        void $this$mapTo$iv$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = events;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (BaseEventId)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((BaseEventId)it).getFields();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            EventField field = (EventField)element$iv$iv;
            boolean bl = false;
            list$iv$iv = INSTANCE.fieldSchema(field, field.getName());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            it = (FieldDescriptor)element$iv$iv;
            boolean bl = false;
            key$iv$iv = ((FieldDescriptor)it).getPath();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv;
        boolean bl = false;
        for (Map.Entry item$iv$iv : iterator.entrySet()) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            void name;
            void $dstr$name$values;
            key$iv$iv = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl3 = false;
            Iterable $i$f$getOrPut = $dstr$name$values;
            boolean value$iv$iv$iv = false;
            answer$iv$iv$iv = (String)$i$f$getOrPut.getKey();
            $i$f$getOrPut = $dstr$name$values;
            value$iv$iv$iv = false;
            List values = (List)$i$f$getOrPut.getValue();
            $i$f$getOrPut = values;
            void var17_23 = name;
            boolean $i$f$flatMap2 = false;
            void var20_24 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                FieldDescriptor it2 = (FieldDescriptor)element$iv$iv;
                boolean bl4 = false;
                Iterable list$iv$iv2 = it2.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            Set set = CollectionsKt.toHashSet((Iterable)list);
            void var31_35 = var17_23;
            FieldDescriptor fieldDescriptor = new FieldDescriptor((String)var31_35, set);
            object.add(fieldDescriptor);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    private EventsSchemeBuilder() {
    }

    static {
        EventsSchemeBuilder eventsSchemeBuilder;
        INSTANCE = eventsSchemeBuilder = new EventsSchemeBuilder();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDescriptor;", "", "path", "", "value", "", "(Ljava/lang/String;Ljava/util/Set;)V", "getPath", "()Ljava/lang/String;", "getValue", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class FieldDescriptor {
        @NotNull
        private final String path;
        @NotNull
        private final Set<String> value;

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final Set<String> getValue() {
            return this.value;
        }

        public FieldDescriptor(@NotNull String path, @NotNull Set<String> value) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.path = path;
            this.value = value;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final Set<String> component2() {
            return this.value;
        }

        @NotNull
        public final FieldDescriptor copy(@NotNull String path, @NotNull Set<String> value) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new FieldDescriptor(path, value);
        }

        public static /* synthetic */ FieldDescriptor copy$default(FieldDescriptor fieldDescriptor, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = fieldDescriptor.path;
            }
            if ((n & 2) != 0) {
                set = fieldDescriptor.value;
            }
            return fieldDescriptor.copy(string, set);
        }

        @NotNull
        public String toString() {
            return "FieldDescriptor(path=" + this.path + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.path;
            Set<String> set = this.value;
            return (string != null ? string.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FieldDescriptor)) break block3;
                    FieldDescriptor fieldDescriptor = (FieldDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)fieldDescriptor.path) || !Intrinsics.areEqual(this.value, fieldDescriptor.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$EventDescriptor;", "", "event", "", "fields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDescriptor;", "(Ljava/lang/String;Ljava/util/Set;)V", "getEvent", "()Ljava/lang/String;", "getFields", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class EventDescriptor {
        @NotNull
        private final String event;
        @NotNull
        private final Set<FieldDescriptor> fields;

        @NotNull
        public final String getEvent() {
            return this.event;
        }

        @NotNull
        public final Set<FieldDescriptor> getFields() {
            return this.fields;
        }

        public EventDescriptor(@NotNull String event, @NotNull Set<FieldDescriptor> fields) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            this.event = event;
            this.fields = fields;
        }

        @NotNull
        public final String component1() {
            return this.event;
        }

        @NotNull
        public final Set<FieldDescriptor> component2() {
            return this.fields;
        }

        @NotNull
        public final EventDescriptor copy(@NotNull String event, @NotNull Set<FieldDescriptor> fields) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            return new EventDescriptor(event, fields);
        }

        public static /* synthetic */ EventDescriptor copy$default(EventDescriptor eventDescriptor, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = eventDescriptor.event;
            }
            if ((n & 2) != 0) {
                set = eventDescriptor.fields;
            }
            return eventDescriptor.copy(string, set);
        }

        @NotNull
        public String toString() {
            return "EventDescriptor(event=" + this.event + ", fields=" + this.fields + ")";
        }

        public int hashCode() {
            String string = this.event;
            Set<FieldDescriptor> set = this.fields;
            return (string != null ? string.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EventDescriptor)) break block3;
                    EventDescriptor eventDescriptor = (EventDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.event, (Object)eventDescriptor.event) || !Intrinsics.areEqual(this.fields, eventDescriptor.fields)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003JA\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$GroupDescriptor;", "", "id", "", "type", "version", "", "schema", "", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$EventDescriptor;", "className", "(Ljava/lang/String;Ljava/lang/String;ILjava/util/Set;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getId", "getSchema", "()Ljava/util/Set;", "getType", "getVersion", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.statistics"})
    public static final class GroupDescriptor {
        @NotNull
        private final String id;
        @NotNull
        private final String type;
        private final int version;
        @NotNull
        private final Set<EventDescriptor> schema;
        @NotNull
        private final String className;

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final int getVersion() {
            return this.version;
        }

        @NotNull
        public final Set<EventDescriptor> getSchema() {
            return this.schema;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        public GroupDescriptor(@NotNull String id, @NotNull String type, int version, @NotNull Set<EventDescriptor> schema, @NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.id = id;
            this.type = type;
            this.version = version;
            this.schema = schema;
            this.className = className;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        public final int component3() {
            return this.version;
        }

        @NotNull
        public final Set<EventDescriptor> component4() {
            return this.schema;
        }

        @NotNull
        public final String component5() {
            return this.className;
        }

        @NotNull
        public final GroupDescriptor copy(@NotNull String id, @NotNull String type, int version, @NotNull Set<EventDescriptor> schema, @NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            return new GroupDescriptor(id, type, version, schema, className);
        }

        public static /* synthetic */ GroupDescriptor copy$default(GroupDescriptor groupDescriptor, String string, String string2, int n, Set set, String string3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = groupDescriptor.id;
            }
            if ((n2 & 2) != 0) {
                string2 = groupDescriptor.type;
            }
            if ((n2 & 4) != 0) {
                n = groupDescriptor.version;
            }
            if ((n2 & 8) != 0) {
                set = groupDescriptor.schema;
            }
            if ((n2 & 0x10) != 0) {
                string3 = groupDescriptor.className;
            }
            return groupDescriptor.copy(string, string2, n, set, string3);
        }

        @NotNull
        public String toString() {
            return "GroupDescriptor(id=" + this.id + ", type=" + this.type + ", version=" + this.version + ", schema=" + this.schema + ", className=" + this.className + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.type;
            Set<EventDescriptor> set = this.schema;
            String string3 = this.className;
            return ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Integer.hashCode(this.version)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GroupDescriptor)) break block3;
                    GroupDescriptor groupDescriptor = (GroupDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)groupDescriptor.id) || !Intrinsics.areEqual((Object)this.type, (Object)groupDescriptor.type) || this.version != groupDescriptor.version || !Intrinsics.areEqual(this.schema, groupDescriptor.schema) || !Intrinsics.areEqual((Object)this.className, (Object)groupDescriptor.className)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J%\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$EventsScheme;", "", "commitHash", "", "scheme", "", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$GroupDescriptor;", "(Ljava/lang/String;Ljava/util/List;)V", "getCommitHash", "()Ljava/lang/String;", "getScheme", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class EventsScheme {
        @Nullable
        private final String commitHash;
        @NotNull
        private final List<GroupDescriptor> scheme;

        @Nullable
        public final String getCommitHash() {
            return this.commitHash;
        }

        @NotNull
        public final List<GroupDescriptor> getScheme() {
            return this.scheme;
        }

        public EventsScheme(@Nullable String commitHash, @NotNull List<GroupDescriptor> scheme) {
            Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
            this.commitHash = commitHash;
            this.scheme = scheme;
        }

        @Nullable
        public final String component1() {
            return this.commitHash;
        }

        @NotNull
        public final List<GroupDescriptor> component2() {
            return this.scheme;
        }

        @NotNull
        public final EventsScheme copy(@Nullable String commitHash, @NotNull List<GroupDescriptor> scheme) {
            Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
            return new EventsScheme(commitHash, scheme);
        }

        public static /* synthetic */ EventsScheme copy$default(EventsScheme eventsScheme, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = eventsScheme.commitHash;
            }
            if ((n & 2) != 0) {
                list = eventsScheme.scheme;
            }
            return eventsScheme.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "EventsScheme(commitHash=" + this.commitHash + ", scheme=" + this.scheme + ")";
        }

        public int hashCode() {
            String string = this.commitHash;
            List<GroupDescriptor> list = this.scheme;
            return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EventsScheme)) break block3;
                    EventsScheme eventsScheme = (EventsScheme)object;
                    if (!Intrinsics.areEqual((Object)this.commitHash, (Object)eventsScheme.commitHash) || !Intrinsics.areEqual(this.scheme, eventsScheme.scheme)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

