/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import com.intellij.internal.statistic.config.EventLogConfigParserException;
import com.intellij.internal.statistic.config.EventLogExternalSendSettings;
import com.intellij.internal.statistic.config.EventLogExternalSettings;
import com.intellij.internal.statistic.config.bean.EventLogSendConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.connection.StatisticsCachingSupplier;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpRequests;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsConnectionService {
    @Nullable
    private final String myConfigUrl;
    @NotNull
    private final EventLogApplicationInfo myApplicationInfo;
    @NotNull
    private final Supplier<EventLogExternalSendSettings> myCachedExternalSettings;

    protected SettingsConnectionService(@Nullable String settingsUrl, @NotNull EventLogApplicationInfo appInfo, long settingsCacheTimeoutMs) {
        if (appInfo == null) {
            SettingsConnectionService.$$$reportNull$$$0(0);
        }
        this.myConfigUrl = settingsUrl;
        this.myApplicationInfo = appInfo;
        this.myCachedExternalSettings = new StatisticsCachingSupplier<EventLogExternalSendSettings>(() -> this.myConfigUrl != null ? this.loadSettings(this.myConfigUrl, this.myApplicationInfo.getProductVersion()) : null, settingsCacheTimeoutMs);
    }

    @Nullable
    protected EventLogSendConfiguration getConfiguration(@NotNull EventLogBuildType type) {
        EventLogExternalSendSettings settings;
        if (type == null) {
            SettingsConnectionService.$$$reportNull$$$0(1);
        }
        return (settings = this.getExternalSettings()) != null ? settings.getConfiguration(type) : null;
    }

    @Nullable
    protected String getEndpointValue(@NotNull String attribute) {
        EventLogExternalSendSettings settings;
        if (attribute == null) {
            SettingsConnectionService.$$$reportNull$$$0(2);
        }
        return (settings = this.getExternalSettings()) != null ? settings.getEndpoint(attribute) : null;
    }

    @Nullable
    public String getOptionValue(@NotNull String attribute) {
        EventLogExternalSendSettings settings;
        if (attribute == null) {
            SettingsConnectionService.$$$reportNull$$$0(3);
        }
        return (settings = this.getExternalSettings()) != null ? settings.getOption(attribute) : null;
    }

    @Nullable
    protected synchronized EventLogExternalSendSettings getExternalSettings() {
        return this.myCachedExternalSettings.get();
    }

    @Nullable
    public EventLogExternalSendSettings loadSettings(@NotNull String configUrl, @NotNull String appVersion) {
        if (configUrl == null) {
            SettingsConnectionService.$$$reportNull$$$0(4);
        }
        if (appVersion == null) {
            SettingsConnectionService.$$$reportNull$$$0(5);
        }
        try {
            return StatsHttpRequests.request(configUrl, this.myApplicationInfo.getConnectionSettings()).send(r -> {
                try {
                    InputStream content = r.read();
                    if (content != null) {
                        InputStreamReader reader = new InputStreamReader(content, StandardCharsets.UTF_8);
                        return EventLogExternalSettings.parseSendSettings(reader, appVersion);
                    }
                    return null;
                }
                catch (EventLogConfigParserException e) {
                    throw new StatsResponseException(e);
                }
            }).getResult();
        }
        catch (StatsResponseException | IOException e) {
            this.logError(e);
            return null;
        }
    }

    private void logError(Exception e) {
        String message = e.getMessage();
        this.myApplicationInfo.getLogger().warn(message != null ? message : "", e);
        this.myApplicationInfo.getEventLogger().logErrorEvent("loading.config.failed", e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appVersion";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/SettingsConnectionService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEndpointValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

