/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.DefaultEventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogFileAppender;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogFileWriter;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogWriter;", "recorderId", "", "maxFileSize", "isEap", "", "prefix", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "eventLogger", "Lorg/apache/log4j/Logger;", "fileAppender", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogFileAppender;", "cleanup", "", "dispose", "getActiveFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getEventLogDir", "Ljava/nio/file/Path;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "log", "logEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "rollOver", "intellij.platform.statistics"})
public final class StatisticsEventLogFileWriter
implements StatisticsEventLogWriter {
    private StatisticsEventLogFileAppender fileAppender;
    private final Logger eventLogger;
    private final String recorderId;
    private final String maxFileSize;

    private final Path getEventLogDir() {
        Path path = EventLogConfiguration.INSTANCE.getEventLogDataPath().resolve("logs").resolve(this.recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"EventLogConfiguration.ge\u2026ogs\").resolve(recorderId)");
        return path;
    }

    @Override
    public void log(@NotNull LogEvent logEvent) {
        Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
        this.eventLogger.info((Object)LogEventSerializer.INSTANCE.toString(logEvent));
    }

    @Override
    @Nullable
    public EventLogFile getActiveFile() {
        Object object = this.fileAppender;
        if (object == null || (object = object.getActiveLogName()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fileAppender?.activeLogName ?: return null");
        Object activeLog = object;
        return new EventLogFile(new File(new File(this.getEventLogDir().toUri()), (String)activeLog));
    }

    @Override
    @NotNull
    public EventLogFilesProvider getLogFilesProvider() {
        return new DefaultEventLogFilesProvider(this.getEventLogDir(), (Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ StatisticsEventLogFileWriter this$0;

            @Nullable
            public final String invoke() {
                StatisticsEventLogFileAppender statisticsEventLogFileAppender = StatisticsEventLogFileWriter.access$getFileAppender$p(this.this$0);
                return statisticsEventLogFileAppender != null ? statisticsEventLogFileAppender.getActiveLogName() : null;
            }
            {
                this.this$0 = statisticsEventLogFileWriter;
                super(0);
            }
        }));
    }

    @Override
    public void cleanup() {
        block0: {
            StatisticsEventLogFileAppender statisticsEventLogFileAppender = this.fileAppender;
            if (statisticsEventLogFileAppender == null) break block0;
            statisticsEventLogFileAppender.cleanUp();
        }
    }

    @Override
    public void rollOver() {
        block0: {
            StatisticsEventLogFileAppender statisticsEventLogFileAppender = this.fileAppender;
            if (statisticsEventLogFileAppender == null) break block0;
            statisticsEventLogFileAppender.rollOver();
        }
    }

    public void dispose() {
    }

    public StatisticsEventLogFileWriter(@NotNull String recorderId, @NotNull String maxFileSize, boolean isEap, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)maxFileSize, (String)"maxFileSize");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.recorderId = recorderId;
        this.maxFileSize = maxFileSize;
        Logger logger2 = Logger.getLogger((String)("event.logger." + this.recorderId));
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getLogger(\"event.logger.$recorderId\")");
        this.eventLogger = logger2;
        this.eventLogger.setLevel(Level.INFO);
        this.eventLogger.setAdditivity(false);
        PatternLayout pattern = new PatternLayout("%m\n");
        try {
            Path dir = this.getEventLogDir();
            StatisticsEventLogFileAppender statisticsEventLogFileAppender = this.fileAppender = StatisticsEventLogFileAppender.create((Layout)pattern, dir, prefix, isEap);
            if (statisticsEventLogFileAppender != null) {
                StatisticsEventLogFileAppender statisticsEventLogFileAppender2 = statisticsEventLogFileAppender;
                boolean bl = false;
                boolean bl2 = false;
                StatisticsEventLogFileAppender appender = statisticsEventLogFileAppender2;
                boolean bl3 = false;
                appender.setMaxFileSize(this.maxFileSize);
                this.eventLogger.addAppender((Appender)appender);
            }
        }
        catch (IOException e) {
            System.err.println("Unable to initialize logging for feature usage: " + e.getLocalizedMessage());
        }
    }

    public static final /* synthetic */ StatisticsEventLogFileAppender access$getFileAppender$p(StatisticsEventLogFileWriter $this) {
        return $this.fileAppender;
    }

    public static final /* synthetic */ void access$setFileAppender$p(StatisticsEventLogFileWriter $this, StatisticsEventLogFileAppender statisticsEventLogFileAppender) {
        $this.fileAppender = statisticsEventLogFileAppender;
    }
}

