/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUpdateError;
import com.intellij.internal.statistic.eventLog.uploader.EventLogUploadException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class EventLogSystemLogger {
    public static final String DEFAULT_RECORDER = "FUS";
    public static final String GROUP = "event.log";

    public static void logMetadataLoad(@NotNull String recorderId, @Nullable String version) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(0);
        }
        FeatureUsageData data = new FeatureUsageData().addVersionByString(version);
        EventLogSystemLogger.logEvent(recorderId, "metadata.loaded", data);
    }

    public static void logMetadataUpdated(@NotNull String recorderId, @Nullable String version) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(1);
        }
        FeatureUsageData data = new FeatureUsageData().addVersionByString(version);
        EventLogSystemLogger.logEvent(recorderId, "metadata.updated", data);
    }

    public static void logMetadataErrorOnLoad(@NotNull String recorderId, @NotNull EventLogMetadataUpdateError error) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(2);
        }
        if (error == null) {
            EventLogSystemLogger.$$$reportNull$$$0(3);
        }
        EventLogSystemLogger.logMetadataError(recorderId, "metadata.load.failed", error);
    }

    public static void logMetadataErrorOnUpdate(@NotNull String recorderId, @NotNull EventLogMetadataUpdateError error) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(4);
        }
        if (error == null) {
            EventLogSystemLogger.$$$reportNull$$$0(5);
        }
        EventLogSystemLogger.logMetadataError(recorderId, "metadata.update.failed", error);
    }

    private static void logMetadataError(@NotNull String recorderId, @NotNull String eventId, @NotNull EventLogMetadataUpdateError error) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(6);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(7);
        }
        if (error == null) {
            EventLogSystemLogger.$$$reportNull$$$0(8);
        }
        FeatureUsageData data = new FeatureUsageData().addData("stage", error.getUpdateStage().name()).addData("error", error.getErrorType());
        int code = error.getErrorCode();
        if (code != -1) {
            data.addData("code", code);
        }
        EventLogSystemLogger.logEvent(recorderId, eventId, data);
    }

    public static void logFilesSend(@NotNull String recorderId, int total, int succeed, int failed, boolean external, @NotNull List<String> successfullySentFiles, @NotNull List<Integer> errors) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(9);
        }
        if (successfullySentFiles == null) {
            EventLogSystemLogger.$$$reportNull$$$0(10);
        }
        if (errors == null) {
            EventLogSystemLogger.$$$reportNull$$$0(11);
        }
        EventLogRecorderConfiguration config = EventLogConfiguration.INSTANCE.getOrCreate(recorderId);
        FeatureUsageData data = new FeatureUsageData().addData("total", total).addData("send", succeed + failed).addData("succeed", succeed).addData("failed", failed).addData("errors", ContainerUtil.map(errors, error -> String.valueOf(error))).addData("external", external).addData("paths", ContainerUtil.map(successfullySentFiles, path -> config.anonymize((String)path)));
        EventLogSystemLogger.logEvent(recorderId, "logs.send", data);
    }

    public static void logStartingExternalSend(@NotNull String recorderId, long time) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(12);
        }
        FeatureUsageData data = new FeatureUsageData().addData("send_ts", time);
        EventLogSystemLogger.logEvent(recorderId, "external.send.started", data);
    }

    public static void logFinishedExternalSend(@NotNull String recorderId, @Nullable String error, long time) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(13);
        }
        boolean succeed = StringUtil.isEmpty((String)error);
        FeatureUsageData data = new FeatureUsageData().addData("succeed", succeed).addData("send_ts", time);
        if (!succeed) {
            data.addData("error", error);
        }
        EventLogSystemLogger.logEvent(recorderId, "external.send.finished", data);
    }

    public static void logCreatingExternalSendCommand(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(14);
        }
        EventLogSystemLogger.logEvent(recorderId, "external.send.command.creation.started");
    }

    public static void logFinishedCreatingExternalSendCommand(@NotNull String recorderId, @Nullable EventLogUploadException.EventLogUploadErrorType errorType) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(15);
        }
        boolean succeed = errorType == null;
        FeatureUsageData data = new FeatureUsageData().addData("succeed", succeed);
        if (!succeed) {
            data.addData("error", errorType.name());
        }
        EventLogSystemLogger.logEvent(recorderId, "external.send.command.creation.finished", data);
    }

    public static void logSystemError(@NotNull String recorderId, @NotNull String eventId, @NotNull String errorClass, long time) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(16);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(17);
        }
        if (errorClass == null) {
            EventLogSystemLogger.$$$reportNull$$$0(18);
        }
        FeatureUsageData data = new FeatureUsageData().addData("error", errorClass);
        if (time != -1L) {
            data.addData("error_ts", time);
        }
        EventLogSystemLogger.logEvent(recorderId, eventId, data);
    }

    private static void logEvent(@NotNull String recorderId, @NotNull String eventId, @NotNull FeatureUsageData data) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(19);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(20);
        }
        if (data == null) {
            EventLogSystemLogger.$$$reportNull$$$0(21);
        }
        StatisticsEventLoggerProvider provider2 = StatisticsEventLogProviderUtil.getEventLogProvider(recorderId);
        String groupId = EventLogSystemLogger.getGroupId(recorderId);
        provider2.getLogger().logAsync(new EventLogGroup(groupId, provider2.getVersion()), eventId, data.build(), false);
    }

    private static void logEvent(@NotNull String recorderId, @NotNull String eventId) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(22);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(23);
        }
        StatisticsEventLoggerProvider provider2 = StatisticsEventLogProviderUtil.getEventLogProvider(recorderId);
        String groupId = EventLogSystemLogger.getGroupId(recorderId);
        provider2.getLogger().logAsync(new EventLogGroup(groupId, provider2.getVersion()), eventId, false);
    }

    private static String getGroupId(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(24);
        }
        if (DEFAULT_RECORDER.equals(recorderId)) {
            return GROUP;
        }
        return StringUtil.toLowerCase((String)recorderId) + ".event.log";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successfullySentFiles";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogSystemLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logMetadataLoad";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "logMetadataUpdated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "logMetadataErrorOnLoad";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logMetadataErrorOnUpdate";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "logMetadataError";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "logFilesSend";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "logStartingExternalSend";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "logFinishedExternalSend";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "logCreatingExternalSendCommand";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "logFinishedCreatingExternalSendCommand";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "logSystemError";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "logEvent";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

