/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.application.Topics;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.MachineIdConfiguration;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.messages.Topic;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\f\u0010\u001f\u001a\u00020\b*\u00020\u0003H\u0002J\f\u0010 \u001a\u00020\u0003*\u00020\u0003H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\r\u00a8\u0006!"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;", "", "recorderId", "", "(Ljava/lang/String;)V", "anonymizedCache", "Ljava/util/HashMap;", "bucket", "", "getBucket", "()I", "deviceId", "getDeviceId", "()Ljava/lang/String;", "machineIdConfiguration", "Lcom/intellij/internal/statistic/eventLog/MachineIdConfiguration;", "getMachineIdConfiguration", "()Lcom/intellij/internal/statistic/eventLog/MachineIdConfiguration;", "machineIdConfigurationReference", "Ljava/util/concurrent/atomic/AtomicReference;", "salt", "", "sessionId", "getSessionId", "anonymize", "data", "generateSessionId", "getNonNegative", "value", "getOrGenerateDeviceId", "getOrGenerateSalt", "asBucket", "shortedUUID", "intellij.platform.statistics"})
public final class EventLogRecorderConfiguration {
    @NotNull
    private final String sessionId;
    @NotNull
    private final String deviceId;
    private final int bucket;
    private final byte[] salt;
    private final HashMap<String, String> anonymizedCache;
    private final AtomicReference<MachineIdConfiguration> machineIdConfigurationReference;
    private final String recorderId;

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final String getDeviceId() {
        return this.deviceId;
    }

    public final int getBucket() {
        return this.bucket;
    }

    @NotNull
    public final MachineIdConfiguration getMachineIdConfiguration() {
        MachineIdConfiguration machineIdConfiguration = this.machineIdConfigurationReference.get();
        Intrinsics.checkNotNullExpressionValue((Object)machineIdConfiguration, (String)"machineIdConfigurationReference.get()");
        return machineIdConfiguration;
    }

    @NotNull
    public final String anonymize(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        if (this.anonymizedCache.containsKey(data)) {
            String string = this.anonymizedCache.get(data);
            if (string == null) {
                string = "";
            }
            return string;
        }
        String result = EventLogConfiguration.INSTANCE.hashSha256(this.salt, data);
        ((Map)this.anonymizedCache).put(data, result);
        return result;
    }

    private final int getNonNegative(int value) {
        return value >= 0 ? value : 0;
    }

    private final String shortedUUID(String $this$shortedUUID) {
        int start = StringsKt.lastIndexOf$default((CharSequence)$this$shortedUUID, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start > 0 && start + 1 < $this$shortedUUID.length()) {
            String string = $this$shortedUUID;
            int n = start + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return $this$shortedUUID;
    }

    private final int asBucket(String $this$asBucket) {
        return MathUtil.nonNegativeAbs((int)$this$asBucket.hashCode()) % 256;
    }

    private final String generateSessionId() {
        String presentableHour = StatisticsUtil.getCurrentHourInUTC$default(StatisticsUtil.INSTANCE, null, 1, null);
        StringBuilder stringBuilder = new StringBuilder().append(presentableHour).append('-');
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        return stringBuilder.append(this.shortedUUID(string)).toString();
    }

    private final String getOrGenerateDeviceId() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String property = EventLogConfiguration.INSTANCE.getHeadlessDeviceIdProperty$intellij_platform_statistics(this.recorderId);
            String string = System.getProperty(property);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                return it;
            }
        }
        try {
            String string = DeviceIdManager.getOrGenerateId(new DeviceIdManager.DeviceIdToken(){}, this.recorderId);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DeviceIdManager.getOrGen\u2026ceIdToken {}, recorderId)");
            return string;
        }
        catch (DeviceIdManager.InvalidDeviceIdTokenException e) {
            EventLogConfiguration.INSTANCE.getLOG$intellij_platform_statistics().warn("Failed retrieving device id for " + this.recorderId);
            return "000000000000000-0000-0000-0000-000000000000";
        }
    }

    private final byte[] getOrGenerateSalt() {
        String string;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String property = EventLogConfiguration.INSTANCE.getHeadlessSaltProperty$intellij_platform_statistics(this.recorderId);
            String string2 = System.getProperty(property);
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                String string4 = it;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string5.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                return byArray;
            }
        }
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"ApplicationInfoImpl.getShadowInstance()");
        String companyName = applicationInfoEx.getShortCompanyName();
        if (StringUtil.isEmptyOrSpaces((String)companyName)) {
            string = "jetbrains";
        } else {
            String string6 = companyName;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"companyName");
            String string7 = string6;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean it = false;
            String string8 = string7;
            boolean bl = false;
            String string9 = string8;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.toLowerCase(locale2);
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toLowerCase(locale)");
        }
        String name = string;
        Preferences prefs = Preferences.userRoot().node(name);
        String saltKey = EventLogConfiguration.INSTANCE.getSaltPropertyKey$intellij_platform_statistics(this.recorderId);
        byte[] salt = prefs.getByteArray(saltKey, null);
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
            prefs.putByteArray(saltKey, salt);
            EventLogConfiguration.INSTANCE.getLOG$intellij_platform_statistics().info("Generating new salt for " + this.recorderId);
        }
        return salt;
    }

    public EventLogRecorderConfiguration(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        this.recorderId = recorderId;
        this.sessionId = this.generateSessionId();
        this.deviceId = this.getOrGenerateDeviceId();
        this.bucket = this.asBucket(this.deviceId);
        this.salt = this.getOrGenerateSalt();
        this.anonymizedCache = new HashMap();
        EventLogConfigOptionsService configOptionsService = EventLogConfigOptionsService.getInstance();
        String string = configOptionsService.getMachineIdSalt(this.recorderId);
        if (string == null) {
            string = "";
        }
        this.machineIdConfigurationReference = new AtomicReference<MachineIdConfiguration>(new MachineIdConfiguration(string, this.getNonNegative(configOptionsService.getMachineIdRevision(this.recorderId))));
        Topic<EventLogConfigOptionsListener> topic = EventLogConfigOptionsService.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"EventLogConfigOptionsService.TOPIC");
        Topics.subscribe(topic, null, (Object)new EventLogRecorderConfigOptionsListener(this.recorderId){

            @Override
            public void onMachineIdConfigurationChanged(@Nullable String salt, int revision) {
                machineIdConfigurationReference.updateAndGet((UnaryOperator)new UnaryOperator<MachineIdConfiguration>(salt, revision){
                    final /* synthetic */ String $salt;
                    final /* synthetic */ int $revision;

                    public final MachineIdConfiguration apply(MachineIdConfiguration prevValue) {
                        return this.$salt != null && this.$revision != -1 && this.$revision > prevValue.getRevision() ? new MachineIdConfiguration(this.$salt, this.$revision) : prevValue;
                    }
                    {
                        this.$salt = string;
                        this.$revision = n;
                    }
                });
            }
        });
    }
}

