/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0005J\"\u0010\u000e\u001a\u00020\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\r\u001a\u00020\u0005J\"\u0010\u0010\u001a\u00020\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\r\u001a\u00020\u0005RG\u0010\u0003\u001a;\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t \u0006*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogNotificationService;", "", "()V", "subscribers", "Lcom/intellij/util/containers/MultiMap;", "", "kotlin.jvm.PlatformType", "Lkotlin/Function1;", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "", "Lorg/jetbrains/annotations/NotNull;", "notifySubscribers", "logEvent", "recorderId", "subscribe", "subscriber", "unsubscribe", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class EventLogNotificationService {
    private static final MultiMap<String, Function1<LogEvent, Unit>> subscribers;
    @NotNull
    public static final EventLogNotificationService INSTANCE;

    public final void notifySubscribers(@NotNull LogEvent logEvent, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Collection collection = subscribers.get((Object)recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"subscribers[recorderId]");
        Collection copyOnWriteArraySet = collection;
        for (Function1 onLogEvent : copyOnWriteArraySet) {
            onLogEvent.invoke((Object)logEvent);
        }
    }

    public final void subscribe(@NotNull Function1<? super LogEvent, Unit> subscriber, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        if (!PluginInfoDetectorKt.getPluginInfo(subscriber.getClass()).isDevelopedByJetBrains()) {
            return;
        }
        subscribers.putValue((Object)recorderId, subscriber);
    }

    public final void unsubscribe(@NotNull Function1<? super LogEvent, Unit> subscriber, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        subscribers.remove((Object)recorderId, subscriber);
    }

    private EventLogNotificationService() {
    }

    static {
        EventLogNotificationService eventLogNotificationService;
        INSTANCE = eventLogNotificationService = new EventLogNotificationService();
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"MultiMap.createConcurren\u2026ng, (LogEvent) -> Unit>()");
        subscribers = multiMap;
    }
}

