/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.validator.storage.EventLogMetadataLoader;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.Topic;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogConfigOptionsService {
    public static final Topic<EventLogConfigOptionsListener> TOPIC = Topic.create((String)"EventLogExternalConfigOptionsListener", EventLogConfigOptionsListener.class);
    private static final String DATA_THRESHOLD = "dataThreshold";
    private static final String GROUP_THRESHOLD = "groupDataThreshold";
    private static final String GROUP_ALERT_THRESHOLD = "groupAlertThreshold";
    public static final String MACHINE_ID_SALT = "id_salt";
    public static final String MACHINE_ID_SALT_REVISION = "id_salt_revision";
    private static final String[] ourOptions = new String[]{"dataThreshold", "groupDataThreshold", "groupAlertThreshold", "id_salt_revision", "id_salt"};

    public static EventLogConfigOptionsService getInstance() {
        return (EventLogConfigOptionsService)ApplicationManager.getApplication().getService(EventLogConfigOptionsService.class);
    }

    public void updateOptions(@NotNull String recorderId, @NotNull EventLogMetadataLoader loader) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(0);
        }
        if (loader == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(1);
        }
        EventLogMetadataSettingsPersistence persisted = EventLogMetadataSettingsPersistence.getInstance();
        HashMap<String, String> changedOptions = new HashMap<String, String>();
        for (String option : ourOptions) {
            String value = persisted.getOptionValue(recorderId, option);
            String newValue = loader.getOptionValue(option);
            if (newValue == null || StringUtil.equals((CharSequence)value, (CharSequence)newValue)) continue;
            persisted.setOptionValue(recorderId, option, newValue);
            changedOptions.put(option, newValue);
        }
        if (!changedOptions.isEmpty()) {
            ((EventLogConfigOptionsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).optionsChanged(recorderId, changedOptions);
        }
    }

    public int getThreshold(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(2);
        }
        return EventLogConfigOptionsService.getPersistedOptionAsInt(recorderId, DATA_THRESHOLD);
    }

    public int getGroupThreshold(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(3);
        }
        return EventLogConfigOptionsService.getPersistedOptionAsInt(recorderId, GROUP_THRESHOLD);
    }

    public int getGroupAlertThreshold(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(4);
        }
        return EventLogConfigOptionsService.getPersistedOptionAsInt(recorderId, GROUP_ALERT_THRESHOLD);
    }

    public String getMachineIdSalt(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(5);
        }
        return EventLogConfigOptionsService.getPersistedOptionAsString(recorderId);
    }

    public int getMachineIdRevision(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(6);
        }
        return EventLogConfigOptionsService.getPersistedOptionAsInt(recorderId, MACHINE_ID_SALT_REVISION);
    }

    @Nullable
    private static String getPersistedOptionAsString(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(7);
        }
        return EventLogMetadataSettingsPersistence.getInstance().getOptionValue(recorderId, MACHINE_ID_SALT);
    }

    private static int getPersistedOptionAsInt(@NotNull String recorderId, @NotNull String name) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(8);
        }
        if (name == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(9);
        }
        return EventLogConfigOptionsService.tryParseInt(EventLogMetadataSettingsPersistence.getInstance().getOptionValue(recorderId, name));
    }

    static int tryParseInt(@Nullable String value) {
        try {
            if (StringUtil.isNotEmpty((String)value)) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogConfigOptionsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getThreshold";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupThreshold";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupAlertThreshold";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getMachineIdSalt";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getMachineIdRevision";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPersistedOptionAsString";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getPersistedOptionAsInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class EventLogThresholdConfigOptionsListener
    implements EventLogConfigOptionsListener {
        private final String myRecorderId;

        protected EventLogThresholdConfigOptionsListener(@NotNull String recorderId) {
            if (recorderId == null) {
                EventLogThresholdConfigOptionsListener.$$$reportNull$$$0(0);
            }
            this.myRecorderId = recorderId;
        }

        @Override
        public void optionsChanged(@NotNull String recorderId, @NotNull Map<String, String> options) {
            if (recorderId == null) {
                EventLogThresholdConfigOptionsListener.$$$reportNull$$$0(1);
            }
            if (options == null) {
                EventLogThresholdConfigOptionsListener.$$$reportNull$$$0(2);
            }
            if (StringUtil.equals((CharSequence)this.myRecorderId, (CharSequence)recorderId)) {
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    if (StringUtil.equals((CharSequence)name, (CharSequence)EventLogConfigOptionsService.DATA_THRESHOLD)) {
                        this.onThresholdChanged(EventLogConfigOptionsService.tryParseInt(value));
                    }
                    if (StringUtil.equals((CharSequence)name, (CharSequence)EventLogConfigOptionsService.GROUP_THRESHOLD)) {
                        this.onGroupThresholdChanged(EventLogConfigOptionsService.tryParseInt(value));
                    }
                    if (!StringUtil.equals((CharSequence)name, (CharSequence)EventLogConfigOptionsService.GROUP_ALERT_THRESHOLD)) continue;
                    this.onGroupAlertThresholdChanged(EventLogConfigOptionsService.tryParseInt(value));
                }
            }
        }

        public abstract void onThresholdChanged(int var1);

        public abstract void onGroupThresholdChanged(int var1);

        public abstract void onGroupAlertThresholdChanged(int var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recorderId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogConfigOptionsService$EventLogThresholdConfigOptionsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "optionsChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

