/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.meexplorer.navigator;

import com.genuitec.eclipse.meexplorer.MEExplorerPlugin;
import com.genuitec.eclipse.meexplorer.navigator.IElementHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ElementHandlerManager {
    private List<IElementHandler> elementHandlerList = new ArrayList<IElementHandler>();
    private static ElementHandlerManager instance;
    private static final String ELEMENTHANDLERS_EXTENSION_ID = "elementhandlers";
    private static final String ELEMENTHANDLER_ELEMENT_NAME = "element-handler";
    private static final String ATTRIBUTE_CLASS_NAME = "class";

    private ElementHandlerManager() {
    }

    public static ElementHandlerManager getInstance() {
        if (instance == null) {
            instance = new ElementHandlerManager();
        }
        return instance;
    }

    public void initialize() {
        IConfigurationElement[] elements;
        this.elementHandlerList = new ArrayList<IElementHandler>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.genuitec.eclipse.meexplorer", ELEMENTHANDLERS_EXTENSION_ID);
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals(ELEMENTHANDLER_ELEMENT_NAME)) {
                try {
                    IElementHandler elementHandlerClass = (IElementHandler)el.createExecutableExtension(ATTRIBUTE_CLASS_NAME);
                    this.elementHandlerList.add(elementHandlerClass);
                }
                catch (CoreException ex) {
                    MEExplorerPlugin.getDefault().log("Failed while loading filename filter extensions", ex, 4);
                }
            }
            ++n2;
        }
    }

    public List<IElementHandler> getElementHandlerList() {
        return this.elementHandlerList;
    }
}

