/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.util;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.ui.editors.TemporaryFileEditorInput;
import com.genuitec.eclipse.core.util.PlatformEditorUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class EditorUtil
extends PlatformEditorUtil {
    public static IContentType getContentType(IEditorInput editorInput) {
        try {
            IContentDescription contentDescription;
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            IContentType type = null;
            if (file != null && (contentDescription = file.getContentDescription()) != null) {
                type = contentDescription.getContentType();
            }
            if (editorInput instanceof TemporaryFileEditorInput) {
                type = ((TemporaryFileEditorInput)editorInput).getContentType();
            }
            IPath path = EditorUtil.getEditorInputPath(editorInput);
            if (type == null && path != null) {
                type = EditorUtil.getContentType(path);
            }
            return type;
        }
        catch (CoreException e) {
            CommonUI.getDefault().log(e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static IContentType getContentType(IPath resource) {
        IFileStore store = EFS.getLocalFileSystem().getStore(resource);
        return EditorUtil.getContentType(store);
    }

    public static IContentType getContentType(IFileStore fileStore) {
        if (fileStore == null) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = fileStore.openInputStream(0, null);
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(stream, fileStore.getName());
            return iContentType;
        }
        catch (IOException x) {
            EditorsPlugin.log((Throwable)x);
            return null;
        }
        catch (CoreException x) {
            if (!(x.getStatus().getException() instanceof FileNotFoundException)) {
                EditorsPlugin.log((Throwable)x);
            }
            return null;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException x) {
                EditorsPlugin.log((Throwable)x);
            }
        }
    }

    public static IPath getEditorInputPath(IEditorInput input) {
        return EditorUtil.getEditorInputPath(input, true);
    }

    public static IPath getEditorInputPath(IEditorInput input, boolean ignoreUnnamedFiles) {
        if (ignoreUnnamedFiles && input instanceof TemporaryFileEditorInput) {
            return null;
        }
        if (input instanceof IPathEditorInput) {
            return ((IPathEditorInput)input).getPath();
        }
        IPathEditorInput pathEditorInput = (IPathEditorInput)input.getAdapter(IPathEditorInput.class);
        if (pathEditorInput != null) {
            return pathEditorInput.getPath();
        }
        return null;
    }
}

