/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.wizard;

import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.portability.wizard.ComboDialogField;
import com.genuitec.eclipse.core.portability.wizard.IDialogFieldListener;
import com.genuitec.eclipse.core.portability.wizard.IStringButtonAdapter;
import com.genuitec.eclipse.core.portability.wizard.LayoutUtil;
import com.genuitec.eclipse.core.portability.wizard.SelectionButtonDialogField;
import com.genuitec.eclipse.core.portability.wizard.StatusInfo;
import com.genuitec.eclipse.core.portability.wizard.StringButtonDialogField;
import com.genuitec.eclipse.core.portability.wizard.TypedViewerFilter;
import com.genuitec.eclipse.core.ui.wizard.DialogFieldUtil;
import com.genuitec.eclipse.core.ui.wizard.WizardUtil;
import com.genuitec.eclipse.core.util.JavaMetaUtils;
import com.genuitec.eclipse.core.util.UIUtil;
import com.genuitec.eclipse.core.util.Util;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewPackageCreationWizard;
import org.eclipse.jdt.internal.ui.wizards.NewSourceFolderCreationWizard;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class SrcPackageDialogFieldHelper {
    private SelectionButtonDialogField newSrcFolderDF;
    private ComboDialogField srcFolderDF;
    private IJavaProject javaProject;
    private IDialogFieldListener dialogFieldListener;
    private StringButtonDialogField packageDF;
    private SelectionButtonDialogField newPackageDF;
    private Label javaPackageLabel;
    private boolean showPackage;

    public SrcPackageDialogFieldHelper(IDialogFieldListener listener) {
        this.dialogFieldListener = listener;
        this.showPackage = true;
    }

    public SrcPackageDialogFieldHelper(IDialogFieldListener listener, boolean showPackage) {
        this(listener);
        this.showPackage = showPackage;
    }

    public void doFillIntoGrid(Composite parent) {
        this.srcFolderDF = DialogFieldUtil.createCombo(parent, this.dialogFieldListener, Messages.SrcPackageDialogFieldHelper_combo_srcfolder_label, new String[0], 0, true);
        LayoutUtil.setHorizontalGrabbing((Control)this.srcFolderDF.getComboControl(null));
        this.newSrcFolderDF = new SelectionButtonDialogField(8);
        this.newSrcFolderDF.setLabelText(Messages.SrcPackageDialogFieldHelper_button_new_srcfolder_label);
        Button btn = this.newSrcFolderDF.getSelectionButton(parent);
        btn.setLayoutData((Object)UIUtil.gridDataForButton(btn, 1));
        btn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newSrcFolder = SrcPackageDialogFieldHelper.this.createSourceFolder(SrcPackageDialogFieldHelper.this.getJavaProject().getProject());
                if (!Util.isNullOrEmpty((String)newSrcFolder)) {
                    SrcPackageDialogFieldHelper.this.updateSrcFolderAndSelect(newSrcFolder);
                }
            }
        });
        if (!this.showPackage) {
            return;
        }
        this.javaPackageLabel = new Label(parent, 0);
        this.javaPackageLabel.setText(Messages.SrcPackageDialogFieldHelper_label_java_package);
        Composite temp = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        temp.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        temp.setLayoutData((Object)gd);
        this.packageDF = new StringButtonDialogField((IStringButtonAdapter)this.dialogFieldListener);
        this.packageDF.setButtonLabel(Messages.SrcPackageDialogFieldHelper_button_package_label);
        this.packageDF.getTextControl(temp);
        Button browseButton = this.packageDF.getChangeControl(temp);
        gd = new GridData(768);
        this.packageDF.getTextControl(temp).setLayoutData((Object)gd);
        this.packageDF.getTextControl(null).getParent().layout();
        this.packageDF.setDialogFieldListener(this.dialogFieldListener);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String pName = SrcPackageDialogFieldHelper.this.selectPackage();
                if (pName != null) {
                    SrcPackageDialogFieldHelper.this.packageDF.setText(pName);
                }
            }
        });
        browseButton.setLayoutData((Object)UIUtil.gridDataForButton(browseButton, 1));
        this.newPackageDF = new SelectionButtonDialogField(8);
        this.newPackageDF.setLabelText(Messages.SrcPackageDialogFieldHelper_button_newpackage_label);
        btn = this.newPackageDF.getSelectionButton(temp);
        btn.setLayoutData((Object)UIUtil.gridDataForButton(btn, 1));
        btn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String newPackage = SrcPackageDialogFieldHelper.this.createPackage();
                if (newPackage != null) {
                    SrcPackageDialogFieldHelper.this.packageDF.setText(newPackage);
                }
            }
        });
    }

    public void updateSrcFolderAndSelect(String newSrcFolder) {
        IPath[] srcFolders = JavaMetaUtils.getSourcePackageFragmentRootPaths((IJavaProject)this.getJavaProject());
        ArrayList<String> srcFolderList = new ArrayList<String>(2);
        int i = 0;
        while (i < srcFolders.length) {
            srcFolderList.add(srcFolders[i].toString());
            ++i;
        }
        this.srcFolderDF.setItems(srcFolderList.toArray(new String[srcFolderList.size()]));
        if (newSrcFolder != null) {
            this.srcFolderDF.setText(newSrcFolder);
        } else {
            this.srcFolderDF.selectItem(0);
        }
    }

    public ComboDialogField getSrcFolderDF() {
        return this.srcFolderDF;
    }

    public SelectionButtonDialogField getNewSrcFolderDF() {
        return this.newSrcFolderDF;
    }

    public StringButtonDialogField getPackageDF() {
        return this.packageDF;
    }

    public SelectionButtonDialogField getNewPackageDF() {
        return this.newPackageDF;
    }

    public List getAllDialogFields() {
        ArrayList<Object> dfs = new ArrayList<Object>();
        dfs.add(this.newSrcFolderDF);
        if (this.showPackage) {
            dfs.add(this.newPackageDF);
            dfs.add((Object)this.packageDF);
        }
        dfs.add(this.srcFolderDF);
        return dfs;
    }

    public void setJavaProject(IJavaProject project) {
        if (this.javaProject != project) {
            this.javaProject = project;
            this.updateSrcFolderAndSelect(null);
        }
    }

    public String getSrcFolder() {
        return this.srcFolderDF.getText();
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public String getPackage() {
        return this.packageDF.getText();
    }

    public void enableLabel(boolean enable) {
        this.javaPackageLabel.setEnabled(enable);
    }

    public IStatus validate() {
        return this.validate(true);
    }

    public IStatus validate(boolean showEmptyPackageWarning) {
        IStatus status = Util.getOKStatus();
        if (this.packageDF == null) {
            return status;
        }
        String pFragment = this.packageDF.getText();
        if (Util.isNullOrEmpty((String)pFragment)) {
            if (showEmptyPackageWarning) {
                status = new StatusInfo(2, Messages.SrcPackageDialogFieldHelper_warning_empty_package);
            }
        } else {
            status = JavaConventions.validatePackageName((String)pFragment);
            if (status.getSeverity() != 4) {
                IPath packagePath = this.getPackageFragmentPath();
                IPackageFragment fragment = null;
                try {
                    fragment = this.javaProject.findPackageFragment(packagePath);
                }
                catch (JavaModelException javaModelException) {}
                if (fragment == null) {
                    status = new StatusInfo(4, Messages.SrcPackageDialogFieldHelper_error_package_doesnotexist);
                }
            }
        }
        return status;
    }

    public boolean classExists(String className) {
        IPath classPath = this.getPackageFragmentPath().append((IPath)new Path("/" + className + ".java"));
        IFile file = Util.getWorkspaceRoot().getFile(classPath);
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return true;
        }
        URI location = file.getLocationURI();
        if (location != null) {
            try {
                IFileStore store = EFS.getStore((URI)location);
                return store.fetchInfo().exists();
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    protected String createSourceFolder(IProject project) {
        String result = null;
        NewSourceFolderCreationWizard wiz = new NewSourceFolderCreationWizard();
        StructuredSelection selection = new StructuredSelection((Object)project);
        wiz.init(UIUtil.getActiveWorkbench(), (IStructuredSelection)selection);
        WizardUtil.launchWizard((IWizard)wiz);
        IJavaElement element = wiz.getCreatedElement();
        if (element != null && element.getElementType() == 3) {
            IPath path = element.getPath();
            path = path.removeFirstSegments(1);
            result = path.toPortableString();
        }
        return result;
    }

    protected String createPackage() {
        NewPackageCreationWizard wizard = new NewPackageCreationWizard();
        IContainer folder = this.getSourceContainer();
        StructuredSelection selection = new StructuredSelection((Object)folder);
        wizard.init(UIUtil.getActiveWorkbench(), (IStructuredSelection)selection);
        WizardUtil.launchWizard((IWizard)wizard);
        IJavaElement element = wizard.getCreatedElement();
        if (element != null && element.getElementType() == 4) {
            return element.getElementName();
        }
        return null;
    }

    public IContainer getSourceContainer() {
        String srcFolder = this.srcFolderDF.getText().trim();
        IProject folder = null;
        if (!Util.isNullOrEmpty((String)srcFolder)) {
            try {
                folder = this.javaProject.getProject().getFolder(srcFolder);
            }
            catch (Exception exception) {}
        }
        return folder != null ? folder : this.javaProject.getProject();
    }

    public IPath getPackageFragmentPath() {
        IContainer srcContainer = this.getSourceContainer();
        String pFragment = this.packageDF.getText().trim().replace('.', '/');
        IPath packagePath = srcContainer.getFullPath().append(pFragment);
        return packagePath;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        String srcFolder = this.srcFolderDF.getText();
        try {
            return this.javaProject.findPackageFragmentRoot((IPath)new Path("/" + this.javaProject.getElementName() + "/" + srcFolder));
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot fragmentRoot) {
        if (fragmentRoot != null) {
            this.setJavaProject(fragmentRoot.getJavaProject());
            this.updateSrcFolderAndSelect(fragmentRoot.getPath().removeFirstSegments(1).toString());
        }
    }

    public void setPackage(String packageString) {
        if (packageString != null) {
            this.packageDF.setText(packageString);
        }
    }

    public IPackageFragment getPackageFragment() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        IPackageFragment fragment = null;
        if (root != null) {
            String pfText = this.packageDF.getText();
            fragment = root.getPackageFragment(pfText);
        }
        return fragment;
    }

    protected String selectPackage() {
        Object element;
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(null, (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(Messages.SrcPackageDialogFieldHelper_dialog_package_selection_title);
        dialog.setMessage(Messages.SrcPackageDialogFieldHelper_dialog_package_selection_message);
        dialog.addFilter((ViewerFilter)new TypedViewerFilter(new Class[]{IPackageFragment.class}));
        IContainer folder = this.getSourceContainer();
        IPackageFragmentRoot pfr = this.javaProject.getPackageFragmentRoot((IResource)folder);
        if (pfr != null) {
            dialog.setInput((Object)pfr);
        } else {
            dialog.setInput((Object)this.javaProject);
        }
        if (dialog.open() == 0 && (element = dialog.getFirstResult()) instanceof IPackageFragment) {
            return ((IPackageFragment)element).getElementName();
        }
        return null;
    }
}

