/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.ui.console;

import com.genuitec.eclipse.core.ui.console.ICustomConsoleStreamWriter;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;

public class CustomConsoleStreamMonitor
implements IFlushableStreamMonitor,
ICustomConsoleStreamWriter {
    private StringBuffer fContents = new StringBuffer(256);
    private ListenerList fListeners = new ListenerList();
    private boolean fBuffered = true;

    public synchronized void addListener(IStreamListener listener) {
        this.fListeners.add((Object)listener);
    }

    public String getContents() {
        return this.fContents.toString();
    }

    public synchronized void removeListener(IStreamListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public synchronized void setBuffered(boolean buffer) {
        this.fBuffered = buffer;
    }

    public synchronized void flushContents() {
        this.fContents.setLength(0);
    }

    public synchronized boolean isBuffered() {
        return this.fBuffered;
    }

    @Override
    public synchronized void appendText(String text) {
        if (this.fBuffered) {
            this.fContents.append(text);
        }
        this.getNotifier().notifyAppend(text);
    }

    private ContentNotifier getNotifier() {
        return new ContentNotifier();
    }

    class ContentNotifier
    implements ISafeRunnable {
        private IStreamListener fListener;
        private String fText;

        ContentNotifier() {
        }

        public void handleException(Throwable exception) {
            DebugPlugin.log((Throwable)exception);
        }

        public void run() throws Exception {
            this.fListener.streamAppended(this.fText, (IStreamMonitor)CustomConsoleStreamMonitor.this);
        }

        public void notifyAppend(String text) {
            if (text == null) {
                return;
            }
            this.fText = text;
            Object[] copiedListeners = CustomConsoleStreamMonitor.this.fListeners.getListeners();
            int i = 0;
            while (i < copiedListeners.length) {
                this.fListener = (IStreamListener)copiedListeners[i];
                SafeRunner.run((ISafeRunnable)this);
                ++i;
            }
            this.fListener = null;
            this.fText = null;
        }
    }
}

