/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.deployment;

import com.genuitec.eclipse.core.GenuitecCoreException;
import com.genuitec.eclipse.server.core.ServerCorePlugin;
import com.genuitec.eclipse.server.core.deployment.DeploymentUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public class ModuleFilesDeployer {
    protected final List<IPath> dplEntries;
    protected final File targetDirectory;
    protected final MultiStatus status;

    public ModuleFilesDeployer(List<IPath> dplEntries, File targetDirectory, MultiStatus status) {
        this.dplEntries = dplEntries;
        this.targetDirectory = targetDirectory;
        this.status = status;
    }

    public void removeResources(IModuleResourceDelta[] deltas, SubMonitor subMonitor) throws GenuitecCoreException {
        if (deltas == null) {
            return;
        }
        subMonitor.beginTask("", deltas.length * 100);
        IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
            switch (delta.getKind()) {
                case 3: {
                    this.deleteResource(delta.getModuleRelativePath().append(delta.getModuleResource().getName()));
                    break;
                }
                case 0: 
                case 2: {
                    this.removeResources(delta.getAffectedChildren(), subMonitor.newChild(100));
                }
            }
            ++n2;
        }
    }

    protected void deleteResource(IPath moduleRelativePath) {
        File location = new File(this.targetDirectory, moduleRelativePath.toOSString());
        if (location.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)location);
            }
            catch (IOException iOException) {
                this.status.add(ServerCorePlugin.createStatus(2, "Cannot delete {0} directory.", location.toString()));
            }
        } else if (location.isFile() && !location.delete()) {
            this.status.add(ServerCorePlugin.createStatus(2, "Cannot delete {0} file.", location.toString()));
        }
    }

    public void saveResources(IModuleResourceDelta[] deltas, SubMonitor monitor) throws GenuitecCoreException {
        monitor.beginTask("", deltas.length * 1000);
        IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
            IModuleResource resource = delta.getModuleResource();
            switch (delta.getKind()) {
                case 1: {
                    this.saveResources(new IModuleResource[]{resource}, monitor.newChild(1000));
                    break;
                }
                case 2: {
                    if (resource instanceof IModuleFile) {
                        this.saveResources(new IModuleResource[]{resource}, monitor.newChild(1000));
                        break;
                    }
                }
                case 0: {
                    if (!(resource instanceof IModuleFolder)) break;
                    this.saveResources(delta.getAffectedChildren(), monitor.newChild(1000));
                }
            }
            ++n2;
        }
    }

    public void saveResources(IModuleResource[] resources, SubMonitor monitor) throws GenuitecCoreException {
        monitor.beginTask("", resources.length * 1000);
        int i = 0;
        while (i < resources.length) {
            IModuleResource resource = resources[i];
            IPath entryPath = resource.getModuleRelativePath().append(resource.getName());
            if (resource instanceof IModuleFile) {
                if (this.shouldInclude(entryPath, true)) {
                    monitor.subTask(entryPath.toString());
                    this.copyFile(resource, entryPath, false);
                    monitor.worked(1000);
                    this.dplEntries.add(entryPath);
                }
            } else if (resource instanceof IModuleFolder && this.shouldInclude(entryPath, false)) {
                this.copyFile(resource, entryPath, false);
                this.saveResources(((IModuleFolder)resource).members(), monitor.newChild(1000));
            }
            ++i;
        }
    }

    protected boolean shouldInclude(IPath entryPath, boolean isFile) {
        if (isFile) {
            return !this.dplEntries.contains(entryPath);
        }
        return !entryPath.equals((Object)new Path(".settings"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void copyFile(IModuleResource f, IPath entryPath, boolean checkIfNewer) throws GenuitecCoreException {
        try {
            File parentDir;
            InputStream is;
            File sourceFile;
            IPath path = entryPath;
            if (f instanceof IModuleFolder) {
                if (!path.hasTrailingSeparator()) {
                    path = path.addTrailingSeparator();
                }
                File targetF = new File(this.targetDirectory, path.toOSString());
                DeploymentUtils.createFolder(targetF);
                return;
            }
            File destFile = new File(this.targetDirectory, entryPath.toOSString());
            long lastModified = -1L;
            if (checkIfNewer && (sourceFile = (File)f.getAdapter(File.class)) != null && sourceFile.exists()) {
                lastModified = sourceFile.lastModified();
                if (destFile.exists() && lastModified == destFile.lastModified() && sourceFile.length() == destFile.length()) {
                    return;
                }
            }
            if ((is = (InputStream)f.getAdapter(InputStream.class)) == null) {
                File file = (File)f.getAdapter(File.class);
                if (file != null && file.exists()) {
                    is = new FileInputStream(file);
                } else {
                    String name = null;
                    name = file != null ? file.getAbsolutePath() : f.getModuleRelativePath().append(f.getName()).toString();
                    throw new GenuitecCoreException("Cannot find the file {0} in the file system. Make sure the file exists and try deployment again", (Plugin)ServerCorePlugin.getDefault(), new String[]{name});
                }
            }
            if (!(parentDir = destFile.getParentFile()).isDirectory()) {
                DeploymentUtils.createFolder(parentDir);
            }
            FileOutputStream os = new FileOutputStream(destFile);
            IOException coughtEx = null;
            try {
                try {
                    byte[] buf = new byte[1024];
                    while (true) {
                        int len;
                        if ((len = is.read(buf)) <= 0) {
                            if (!checkIfNewer) {
                            }
                            if (lastModified > 0L) {
                                destFile.setLastModified(lastModified);
                            }
                            break;
                        }
                        os.write(buf, 0, len);
                    }
                }
                catch (IOException e) {
                    block33: {
                        block32: {
                            coughtEx = e;
                            try {
                                is.close();
                            }
                            catch (IOException ex) {
                                if (coughtEx != null) break block32;
                                coughtEx = ex;
                            }
                        }
                        try {
                            os.close();
                        }
                        catch (IOException ex) {
                            if (coughtEx != null) break block33;
                            coughtEx = ex;
                        }
                    }
                    if (coughtEx == null) return;
                    throw coughtEx;
                }
            }
            finally {
                block35: {
                    block34: {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            if (coughtEx != null) break block34;
                            coughtEx = ex;
                        }
                    }
                    try {
                        os.close();
                    }
                    catch (IOException ex) {
                        if (coughtEx != null) break block35;
                        coughtEx = ex;
                    }
                }
                if (coughtEx == null) return;
                throw coughtEx;
            }
        }
        catch (IOException e) {
            throw new GenuitecCoreException((Plugin)ServerCorePlugin.getDefault(), (Throwable)e);
        }
    }
}

