/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.facet.ui;

import com.genuitec.eclipse.j2eedt.core.MavenUtil;
import com.genuitec.eclipse.j2eedt.core.Messages;
import com.genuitec.eclipse.j2eedt.core.version.IJEEVersionInfo;
import com.genuitec.eclipse.j2eedt.core.version.JEE;
import com.genuitec.eclipse.j2eedt.core.version.JEEProjectType;
import com.genuitec.eclipse.j2eedt.facet.IFacetConstants;
import com.genuitec.eclipse.j2eedt.facet.ui.FacetConfigurationCheckBox;
import com.genuitec.eclipse.j2eedt.facet.ui.FacetConfigurationCombo;
import com.genuitec.eclipse.j2eedt.facet.ui.FacetsConfigurationGroup;
import com.genuitec.eclipse.j2eedt.facet.ui.MEDataModelFacetCreationWizardPage;
import com.genuitec.eclipse.j2eedt.facet.ui.internal.FacetedWizardsUtils;
import com.genuitec.eclipse.runtime.ui.RuntimeUIManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public abstract class MEJEEDataModelFacetCreationWizardPage
extends MEDataModelFacetCreationWizardPage
implements IFacetProjectCreationDataModelProperties {
    private boolean mavenSupportPossible = true;
    private FacetConfigurationCombo configurationCombo;
    protected Composite wrapper;
    protected JEE selectedJEE;

    protected MEJEEDataModelFacetCreationWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
    }

    @Override
    protected void addFacetSelectionControls(FacetsConfigurationGroup group) {
        this.addJEEVersionSelection(group);
    }

    private void addJEEVersionSelection(FacetsConfigurationGroup group) {
        JEE defaultJEEVersion;
        ArrayList<String> jeeCaptions = new ArrayList<String>();
        ArrayList<IProjectFacetVersion> jeeVersions = new ArrayList<IProjectFacetVersion>();
        JEEProjectType modType = this.getJeeModuleType();
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.getDataModel().getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = map.getFacetDataModel(modType.getFacet().getId());
        this.selectedJEE = defaultJEEVersion = modType.getVersionInfo((IProjectFacetVersion)facetModel.getProperty("IFacetDataModelPropeties.FACET_VERSION")).getDefaultJEE();
        int defaultVersionIndex = -1;
        int i = JEE.values().length - 1;
        while (i > 0) {
            JEE jee = JEE.values()[i];
            IJEEVersionInfo versionInfo = modType.getVersionInfo(jee);
            if (versionInfo != null) {
                IProjectFacetVersion facetVersion = versionInfo.getFacetVersion();
                if (defaultJEEVersion == jee) {
                    defaultVersionIndex = jeeVersions.size();
                }
                jeeCaptions.add(MessageFormat.format("{0} - {1}", jee.toString(), versionInfo.toString()));
                jeeVersions.add(facetVersion);
            }
            --i;
        }
        this.configurationCombo = new FacetConfigurationCombo("Java EE version:", ((IProjectFacetVersion)jeeVersions.get(0)).getProjectFacet().getId(), jeeCaptions.toArray(new String[jeeCaptions.size()]), jeeVersions.toArray(new IProjectFacetVersion[jeeVersions.size()]), defaultVersionIndex){

            @Override
            protected void modified() {
                MEJEEDataModelFacetCreationWizardPage.this.selectedJEE = null;
                super.modified();
                FacetedWizardsUtils.selectBestRuntime(MEJEEDataModelFacetCreationWizardPage.this, false);
                MEJEEDataModelFacetCreationWizardPage.this.updateMavenOption();
            }
        };
        group.addFacetControl(this.configurationCombo);
    }

    @Override
    protected void addMavenSupportSelection(FacetsConfigurationGroup group) {
        final boolean isMavenSupportAvailable = MavenUtil.isMavenSupportAvailable();
        if (this.mavenSupportPossible && IFacetConstants.MAVEN_10 != null && isMavenSupportAvailable) {
            group.addFacetControl(new FacetConfigurationCheckBox(null, "Add Maven support", IFacetConstants.MAVEN_10, false){

                @Override
                public void createControl(Composite parent) {
                    MEJEEDataModelFacetCreationWizardPage.this.wrapper = new Composite(parent, 0);
                    MEJEEDataModelFacetCreationWizardPage.this.wrapper.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                    MEJEEDataModelFacetCreationWizardPage.this.wrapper.setLayout((Layout)new GridLayout(2, false));
                    if (isMavenSupportAvailable) {
                        super.createSelectionControl(MEJEEDataModelFacetCreationWizardPage.this.wrapper);
                    }
                    Link link = new Link(MEJEEDataModelFacetCreationWizardPage.this.wrapper, 0);
                    link.setText("<a>" + Messages.NewJ2EEProjectDetailsWithSpecWizardPage_text_learn_maven + "</a>");
                    link.setLayoutData((Object)new GridData(131072, 4, true, false));
                    link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("https://www.genuitec.com/products/myeclipse/learning-center/maven/using-maven-in-myeclipse-maven4myeclipse/");
                        }
                    });
                    MEJEEDataModelFacetCreationWizardPage.this.updateMavenOption();
                }

                @Override
                public IProjectFacetVersion getSelectedFacetVersion() {
                    return MEJEEDataModelFacetCreationWizardPage.this.isJavaEE8OrAbove() ? IFacetConstants.MAVEN_10 : super.getSelectedFacetVersion();
                }
            });
        }
    }

    protected abstract JEEProjectType getJeeModuleType();

    public boolean isMavenSupportPossible() {
        return this.mavenSupportPossible;
    }

    public void setMavenSupportPossible(boolean mavenSupportPossible) {
        this.mavenSupportPossible = mavenSupportPossible;
    }

    @Override
    public IRuntime chooseBestRuntime(List<IRuntime> runtimes) {
        for (IRuntime runtime : runtimes) {
            if (!runtime.getName().equals("com.genuitec.runtime.generic.java")) continue;
            return runtime;
        }
        if (this.getSelectedJEE() != null) {
            for (IRuntime runtime : runtimes) {
                if (!runtime.getName().equals(this.getSelectedJEE().getRuntimeId())) continue;
                return runtime;
            }
        }
        for (IRuntime runtime : runtimes) {
            if (!runtime.getName().startsWith("com.genuitec.runtime.generic.")) continue;
            return runtime;
        }
        return null;
    }

    @Override
    protected boolean shouldAddNewRuntimeBtn() {
        return true;
    }

    @Override
    public boolean invokeAddNewRuntimeDialog() {
        IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        return RuntimeUIManager.openNewRuntimeDialog((Set)(fpjwc != null ? fpjwc.getProjectFacets() : null));
    }

    protected boolean isJavaEE8OrAbove() {
        return JEE.isJavaEE8OrAbove((JEE)this.getSelectedJEE());
    }

    public JEE getSelectedJEE() {
        if (this.selectedJEE == null && this.configurationCombo != null) {
            JEE[] values;
            int length;
            int count = this.configurationCombo.combo.getItemCount();
            if (count == (length = (values = JEE.values()).length - 1)) {
                int index = this.configurationCombo.getSelectionIndex();
                if (index != -1) {
                    this.selectedJEE = values[length - index];
                    return this.selectedJEE;
                }
            } else {
                JEEProjectType type = this.getJeeModuleType();
                if (type != null) {
                    IJEEVersionInfo versionInfo;
                    IProjectFacetVersion selectedVersion = this.configurationCombo.getSelectedFacetVersion();
                    IJEEVersionInfo iJEEVersionInfo = versionInfo = selectedVersion != null ? type.getVersionInfo(selectedVersion) : null;
                    if (selectedVersion != null) {
                        this.selectedJEE = versionInfo.getDefaultJEE();
                        return this.selectedJEE;
                    }
                }
            }
        }
        return this.selectedJEE;
    }

    private void updateMavenOption() {
        if (this.wrapper != null && !this.wrapper.isDisposed()) {
            boolean isJavaEE8Plus = this.isJavaEE8OrAbove();
            this.wrapper.setVisible(!isJavaEE8Plus);
            ((GridData)this.wrapper.getLayoutData()).exclude = isJavaEE8Plus;
            this.wrapper.getParent().layout();
            this.wrapper.layout();
        }
    }

    @Override
    protected void handleFacetedProjectEvent(IFacetedProjectEvent event) {
        if (event.getType() == IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED) {
            this.selectedJEE = null;
            this.updateMavenOption();
        }
        super.handleFacetedProjectEvent(event);
    }
}

