/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.core;

import com.genuitec.eclipse.j2eedt.core.J2EEProjectUtil;
import com.genuitec.eclipse.j2eedt.core.Messages;
import com.genuitec.eclipse.j2eedt.core.version.JEEProjectType;
import com.genuitec.eclipse.j2eedt.ui.J2EEUICore;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;

public class J2EEProjectUIUtil {
    public static void addJar2ProjectClasspath(final IJavaProject theJavaProject, final IPath[] theJarPaths, final IProgressMonitor theMonitor) throws CoreException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IClasspathEntry[] newEntries = new IClasspathEntry[theJarPaths.length];
                IClasspathEntry[] oldEntries = theJavaProject.getRawClasspath();
                int i = 0;
                while (i < theJarPaths.length) {
                    newEntries[i] = JavaCore.newLibraryEntry((IPath)theJarPaths[i], null, null);
                    oldEntries = J2EEProjectUtil.removeClasspathEntry((IClasspathEntry[])oldEntries, (String)theJarPaths[i].toString());
                    ++i;
                }
                try {
                    newEntries = J2EEProjectUtil.appendClasspathEntries((IClasspathEntry[])oldEntries, (IClasspathEntry[])newEntries);
                    if (newEntries != null) {
                        theJavaProject.setRawClasspath(newEntries, theMonitor);
                    }
                }
                catch (JavaModelException ex) {
                    J2EEUICore.getDefault().log("Error adding webproject classpath entry", ex);
                }
            }
        };
        WorkspaceOperationRunner runner = new WorkspaceOperationRunner();
        try {
            runner.run(true, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            throw new CoreException((IStatus)new Status(4, "com.genuitec.eclipse.j2eedt.ui", 0, Messages.WebClasspathBuilder_error_updating, (Throwable)e));
        }
        catch (InterruptedException interruptedException) {}
    }

    public static Image getProjectTypeImage(JEEProjectType type) {
        return J2EEUICore.getDefault().getImage("icons/" + type.name().toLowerCase() + "_project.gif");
    }
}

