/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core;

import com.genuitec.eclipse.core.activation.ActivationCode;
import com.genuitec.eclipse.core.activation.InvalidSystemDataException;
import com.genuitec.eclipse.core.activation.SystemIdFactory;
import com.genuitec.eclipse.core.gsdc.GSDCController;
import com.genuitec.eclipse.core.util.PlatformUtil;
import com.genuitec.eclipse.core.util.StatusInfo;
import org.eclipse.core.runtime.IStatus;

public class ActivationValidator {
    public static final int ACT_VALIDATE_DATA_ERROR = 101;
    public static final int ACT_VALIDATE_LICENSEMATCH_ERROR = 102;
    public static final int ACT_VALIDATE_SYSTEMID_ERROR = 103;
    public static final int ACT_VALIDATE_EXPIRED_ERROR = 104;
    private String A;
    private ActivationCode D;
    private boolean C;
    private boolean B;
    private boolean E;

    public ActivationValidator(String string, String string2) {
        this.A = string2;
        if (!PlatformUtil.isNullOrEmpty((String)string)) {
            try {
                this.D = ActivationCode.fromCode(string);
            }
            catch (InvalidSystemDataException invalidSystemDataException) {
                this.C = true;
            }
        } else {
            this.C = true;
        }
        this.A();
    }

    public ActivationValidator(ActivationCode activationCode, String string) {
        this.A = string;
        this.D = activationCode;
        this.A();
    }

    private void A() {
        if (this.D == null) {
            this.C = true;
        }
        if (!this.isDecodeFailed()) {
            this.B = GSDCController.getInstance().isActive() || this.D.getLicenseCode().equals(this.A);
            this.E = SystemIdFactory.matches(this.D.getSystemId());
        }
    }

    public ActivationCode getActivationCode() {
        return this.D;
    }

    public boolean isDecodeFailed() {
        return this.C;
    }

    public boolean isExpired() {
        return this.D.isExpired();
    }

    public boolean isValidForLicense() {
        return this.B;
    }

    public boolean isValidForSystemId() {
        return this.E;
    }

    public boolean isValid() {
        return this.validate().isOK();
    }

    public IStatus validate() {
        IStatus iStatus = PlatformUtil.getOKStatus();
        if (this.isDecodeFailed()) {
            iStatus = new StatusInfo(4, "Invalid activation code", 101);
        } else if (this.isExpired()) {
            iStatus = new StatusInfo(4, "Activation code expired", 104);
        } else if (!this.isValidForSystemId()) {
            iStatus = new StatusInfo(4, "Activation code invalid for system", 103);
        } else if (!this.isValidForLicense()) {
            iStatus = new StatusInfo(4, "Activation code invalid for license key", 102);
        }
        return iStatus;
    }
}

