/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active;

import com.crack.me.active.Hex;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MACAddressUtil {
    String macAddress = null;
    String computeMacAddress = null;
    private static final Pattern HARDWARE_PATTERN = Pattern.compile("(.*wireless.*)|(.*tunnel.*)|(.*atapi.*)|(.*bluetooth.*)|(.*vnic.*)|(.*vmnet.*)", 2);

    public String getMacAddressWithNetworkInterface() {
        String computeMacAddress = null;
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                Matcher matcher;
                String hardwareName;
                byte[] hardwareAddress;
                NetworkInterface ni = networkInterfaces.nextElement();
                if (ni == null || ni.isVirtual() || ni.isLoopback() || !ni.isUp() || (hardwareAddress = ni.getHardwareAddress()) == null || hardwareAddress.length == 2) continue;
                boolean isMacAddressLegal = false;
                byte[] byArray = hardwareAddress;
                int n2 = hardwareAddress.length;
                int n3 = 0;
                while (n3 < n2) {
                    byte b2 = byArray[n3];
                    if (b2 <= 0) {
                        isMacAddressLegal = true;
                        break;
                    }
                    ++n3;
                }
                if (!isMacAddressLegal || (hardwareName = ni.getDisplayName()) == null || hardwareName.length() == 0 || (matcher = HARDWARE_PATTERN.matcher(hardwareName)).lookingAt()) continue;
                computeMacAddress = String.format("%02x%02x", hardwareAddress[hardwareAddress.length - 2], hardwareAddress[hardwareAddress.length - 1]);
                this.macAddress = this.buildMacAddress(hardwareAddress);
            }
        }
        catch (SocketException e2) {
            e2.printStackTrace();
        }
        return computeMacAddress == null ? "0000" : computeMacAddress;
    }

    public String buildMacAddress(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        if (bytes != null) {
            byte[] byArray = bytes;
            int n2 = bytes.length;
            int n3 = 0;
            while (n3 < n2) {
                byte b2 = byArray[n3];
                sb.append(String.valueOf(String.format("%02x", b2)) + ":");
                ++n3;
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String executeCommand(String[] commands) {
        String returnValue;
        block26: {
            Process process = null;
            BufferedReader br = null;
            returnValue = null;
            try {
                try {
                    process = Runtime.getRuntime().exec(commands);
                    br = new BufferedReader(new InputStreamReader(process.getInputStream()), 128);
                    returnValue = br.readLine();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    if (process == null) break block26;
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    try {
                        process.getErrorStream().close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                    try {
                        process.getOutputStream().close();
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                }
            }
            finally {
                if (process != null) {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e6) {
                        e6.printStackTrace();
                    }
                    try {
                        process.getErrorStream().close();
                    }
                    catch (IOException e7) {
                        e7.printStackTrace();
                    }
                    try {
                        process.getOutputStream().close();
                    }
                    catch (IOException e8) {
                        e8.printStackTrace();
                    }
                }
            }
        }
        return returnValue;
    }

    public String getMacAddressWithOS() {
        int length;
        String macAddress;
        block39: {
            Process process = null;
            macAddress = null;
            BufferedReader br = null;
            String osName = System.getProperty("os.name");
            if (osName != null) {
                block38: {
                    try {
                        try {
                            if (osName.startsWith("Windows")) {
                                process = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
                            } else if (osName.startsWith("Solaris") || osName.startsWith("SunOS")) {
                                String hostName = this.executeCommand(new String[]{"uname", "-n"});
                                if (hostName != null) {
                                    process = Runtime.getRuntime().exec(new String[]{"/usr/sbin/arp", hostName}, null);
                                }
                            } else if (new File("/usr/sbin/lanscan").exists()) {
                                process = Runtime.getRuntime().exec(new String[]{"/usr/sbin/lanscan"}, null);
                            } else if (new File("/sbin/ifconfig").exists()) {
                                process = Runtime.getRuntime().exec(new String[]{"/sbin/ifconfig", "-a"}, null);
                            }
                            if (process == null) break block38;
                            br = new BufferedReader(new InputStreamReader(process.getInputStream()), 128);
                            String line = null;
                            while ((line = br.readLine()) != null) {
                                macAddress = this.macAddressParser(line);
                                if (macAddress == null || Hex.parseShort(macAddress) == 255) continue;
                                this.macAddress = macAddress;
                                break;
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            if (process == null) break block39;
                            try {
                                if (br != null) {
                                    br.close();
                                }
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                            try {
                                process.getErrorStream().close();
                            }
                            catch (IOException e4) {
                                e4.printStackTrace();
                            }
                            try {
                                process.getOutputStream().close();
                            }
                            catch (IOException e5) {
                                e5.printStackTrace();
                            }
                            break block39;
                        }
                    }
                    catch (Throwable throwable) {
                        if (process != null) {
                            try {
                                if (br != null) {
                                    br.close();
                                }
                            }
                            catch (IOException e6) {
                                e6.printStackTrace();
                            }
                            try {
                                process.getErrorStream().close();
                            }
                            catch (IOException e7) {
                                e7.printStackTrace();
                            }
                            try {
                                process.getOutputStream().close();
                            }
                            catch (IOException e8) {
                                e8.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                }
                if (process != null) {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e9) {
                        e9.printStackTrace();
                    }
                    try {
                        process.getErrorStream().close();
                    }
                    catch (IOException e10) {
                        e10.printStackTrace();
                    }
                    try {
                        process.getOutputStream().close();
                    }
                    catch (IOException e11) {
                        e11.printStackTrace();
                    }
                }
            }
        }
        String computeMacAddress = null;
        int n2 = length = macAddress != null ? macAddress.length() : 0;
        if (length >= 5) {
            computeMacAddress = String.valueOf(macAddress.substring(length - 5, length - 3)) + macAddress.substring(length - 2, length);
        }
        return computeMacAddress != null ? computeMacAddress : "0000";
    }

    public String macAddressParser(String line) {
        String out = line;
        int hexStart = out.indexOf("0x");
        if (hexStart != -1 && out.indexOf("ETHER") != -1) {
            int hexEnd = out.indexOf(32, hexStart);
            if (hexEnd > hexStart + 2) {
                out = out.substring(hexStart, hexEnd);
            }
        } else {
            int lastIndex;
            int octets = 0;
            if (out.indexOf(45) > -1) {
                out = out.replace('-', ':');
            }
            if ((lastIndex = out.lastIndexOf(58)) > out.length() - 2) {
                out = null;
            } else {
                int end = Math.min(out.length(), lastIndex + 3);
                ++octets;
                int old = lastIndex;
                while (octets != 5 && lastIndex != -1 && lastIndex > 1) {
                    --lastIndex;
                    if (old - (lastIndex = out.lastIndexOf(58, lastIndex)) != 3 && old - lastIndex != 2) continue;
                    ++octets;
                    old = lastIndex;
                }
                out = octets == 5 && lastIndex > 1 ? out.substring(lastIndex - 2, end).trim() : null;
            }
        }
        if (out != null && out.startsWith("0x")) {
            out = out.substring(2);
        }
        return out;
    }

    public String getMacAddress() {
        if (this.computeMacAddress != null) {
            return this.computeMacAddress;
        }
        String macAddr = this.getMacAddressWithNetworkInterface();
        if (macAddr == null || "0000".equals(macAddr)) {
            macAddr = this.getMacAddressWithOS();
        }
        this.computeMacAddress = macAddr;
        return macAddr;
    }
}

