#!/system/bin/sh
usbPath=$(getprop persist.sys.yst.autolog.pos)
logType=$(getprop persist.sys.yst.autolog.type)
cfName="config.ini"
filePath=${usbPath}"/"${cfName}
state=true

function __readINI() {
	INIFILE=$1;	SECTION=$2;	ITEM=$3
	_readIni=`busybox awk -F '=' '/\['$SECTION'\]/{a=1}a==1&&$1~/'$ITEM'/{print $2;exit}' $INIFILE`
	echo ${_readIni}
}

function _startLog(){
	echo "start Log"
	rm -f $usbPath/yst_logcat.log
	logcat -v threadtime > $usbPath/yst_logcat.log &
}

function _stopLog(){
	echo "stop Log"
#	logcatID=`busybox ps | busybox grep logcat | busybox grep -v "$0" | busybox grep -v "grep" | busybox awk '{print $1}'`
#	for id in $logcatID
#	do
#		echo "stopLogID:"${id}
#		kill -9 $id
#	done
	logIDArr=$(ps logcat)
	stopLogCount=0
	for item in $logIDArr
	do
		logIDlist[$stopLogCount]=$item
		((stopLogCount++))
	done
	logID=${logIDlist[9]}
	kill -9 $logID
}

function _startNetLog(){
	echo "start NetLog"
	rm -f $usbPath/yst_net.pcap
	tcpdump -U -n -s 0 -vv -w $usbPath/yst_net.pcap &
}

function _stopNetLog(){
	echo "stop NetLog"
#	tcpdumpID=`busybox ps | busybox grep tcpdump | busybox grep -v "$0" | busybox grep -v "grep" | busybox awk '{print $1}'`
#	for id in $tcpdumpID
#	do
#		echo "stopNetLogID:"${id}
#		kill -9 $id
#	done
	netIDArr=$(ps tcpdump)
	stopNetCount=0
	for item in $netIDArr
	do
		netIDlist[$stopNetCount]=$item
		((stopNetCount++))
	done
	netID=${netIDlist[9]}
	kill -9 $netID
}

function _startKernelLog(){
	echo "start KernelLog"
	rm -f $usbPath/yst_kernel.log
	cat /proc/kmsg >> $usbPath/yst_kernel.log &
}

function _stopKernelLog(){
#	echo "stop KernelLog"
#	catID=`busybox ps | busybox grep cat | busybox grep -v "$0" | busybox grep -v "grep" | busybox awk '{print $1}'`
#	for id in $catID
#	do
#		echo "stopKernelLog:"${id}
#		kill -9 $id
#	done
	kernelIDArr=$(ps cat)
	stopKerCount=0
	for item in $kernelIDArr
	do
		kernelIDlist[$stopKerCount]=$item
		((stopKerCount++))
	done
	kernelID=${kernelIDlist[9]}
	kill $kernelID
}
if [ $logType = "1" ]
then
	if [ ! -f "$filePath" ]
	then
		_stopLog
		_stopNetLog
#		_stopKernelLog
		$state=false
		exit
	else
		LogReadRes=( $( __readINI $filePath Log YSTEN_CONFIG_LOGCAT ) )
		NetReadRes=( $( __readINI $filePath Log YSTEN_CONFIG_NET ) )
		KernelReadRes=( $( __readINI $filePath Log YSTEN_CONFIG_KERNEL ) )

		if [ $LogReadRes = "true" ]
		then
			_startLog
#		rm -f $usbPath/yst_logcat.log
#		logcat -v threadtime > $usbPath/yst_logcat.log &
		else
			_stopLog
		fi

		if [ $NetReadRes = "true" ]
		then
			_startNetLog
#		rm -f $usbPath/yst_net.pcap
#		tcpdump -U -n -s 0 -vv -w $usbPath/yst_net.pcap &
		else
			_stopNetLog
		fi

		if [ $KernelReadRes = "true" ]
		then
			_startKernelLog
#		rm -f $usbPath/yst_kernel.log
#		cat /proc/kmsg >> $usbPath/yst_kernel.log &
#       else
#           _stopKernelLog
		fi

		while $state
		do
			sync
			sleep 5
		done
	fi
elif [ $logType = "2" ]
then
	_stopLog
	_stopNetLog
#	_stopKernelLog
fi
exit
