/*
 * Decompiled with CFR 0.152.
 */
package com.janetfilter.core;

import com.janetfilter.core.Environment;
import com.janetfilter.core.Initializer;
import com.janetfilter.core.attach.VMLauncher;
import com.janetfilter.core.attach.VMSelector;
import com.janetfilter.core.commons.DebugInfo;
import com.janetfilter.core.utils.WhereIsUtils;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.net.URI;
import java.util.jar.JarFile;

public class Launcher {
    public static final String ATTACH_ARG = "--attach";
    public static final String VERSION = "v2.2.2";
    private static boolean loaded = false;

    public static void main(String[] args) {
        URI jarURI;
        try {
            jarURI = WhereIsUtils.getJarURI();
        }
        catch (Throwable e) {
            DebugInfo.error("Can not locate `ja-netfilter` jar file.", e);
            return;
        }
        String jarPath = jarURI.getPath();
        if (args.length > 1 && args[0].equals(ATTACH_ARG)) {
            VMLauncher.attachVM(jarPath, args[1], args.length > 2 ? args[2] : null);
            return;
        }
        Launcher.printUsage();
        try {
            new VMSelector(new File(jarPath)).select();
        }
        catch (Throwable e) {
            System.err.println("  ERROR: Select virtual machine failed.");
            e.printStackTrace(System.err);
        }
    }

    public static void premain(String args, Instrumentation inst) {
        URI jarURI;
        if (loaded) {
            DebugInfo.warn("You have multiple `ja-netfilter` as javaagent.");
            return;
        }
        Launcher.printUsage();
        try {
            loaded = true;
            jarURI = WhereIsUtils.getJarURI();
        }
        catch (Throwable e) {
            DebugInfo.error("Can not locate `ja-netfilter` jar file.", e);
            return;
        }
        File agentFile = new File(jarURI.getPath());
        try {
            inst.appendToBootstrapClassLoaderSearch(new JarFile(agentFile));
        }
        catch (Throwable e) {
            DebugInfo.error("Can not access `ja-netfilter` jar file.", e);
            return;
        }
        Initializer.init(inst, new Environment(agentFile, args));
    }

    public static void agentmain(String args, Instrumentation inst) {
        Launcher.premain(args, inst);
    }

    private static void printUsage() {
        String content = "\n  ============================================================================  \n\n    ja-netfilter-v2.2.2\n\n    A javaagent framework :)\n\n    https://github.com/ja-netfilter/ja-netfilter\n\n  ============================================================================  \n\n";
        System.out.print(content);
    }
}

