/*
 * Decompiled with CFR 0.152.
 */
package com.janetfilter.core;

import com.janetfilter.core.commons.DebugInfo;
import com.janetfilter.core.plugin.MyTransformer;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class Dispatcher
implements ClassFileTransformer {
    private final Set<String> classSet = new TreeSet<String>();
    private final Map<String, List<MyTransformer>> transformerMap = new HashMap<String, List<MyTransformer>>();
    private final List<MyTransformer> globalTransformers = new ArrayList<MyTransformer>();

    public synchronized void addTransformer(MyTransformer transformer) {
        String className = transformer.getHookClassName();
        if (null == className) {
            this.globalTransformers.add(transformer);
            return;
        }
        this.classSet.add(className.replace('/', '.'));
        List transformers = this.transformerMap.computeIfAbsent(className, k -> new ArrayList());
        transformers.add(transformer);
    }

    public void addTransformers(List<MyTransformer> transformers) {
        if (null == transformers) {
            return;
        }
        for (MyTransformer transformer : transformers) {
            this.addTransformer(transformer);
        }
    }

    public void addTransformers(MyTransformer[] transformers) {
        if (null == transformers) {
            return;
        }
        this.addTransformers(Arrays.asList(transformers));
    }

    public Set<String> getHookClassNames() {
        return this.classSet;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) throws IllegalClassFormatException {
        List<MyTransformer> transformers;
        if (null != className && null != (transformers = this.transformerMap.get(className))) {
            int order = 0;
            try {
                for (MyTransformer transformer : this.globalTransformers) {
                    transformer.before(className, classFileBuffer);
                }
                for (MyTransformer transformer : this.globalTransformers) {
                    classFileBuffer = transformer.preTransform(className, classFileBuffer, order++);
                }
                for (MyTransformer transformer : transformers) {
                    classFileBuffer = transformer.transform(className, classFileBuffer, order++);
                }
                for (MyTransformer transformer : this.globalTransformers) {
                    classFileBuffer = transformer.postTransform(className, classFileBuffer, order++);
                }
                for (MyTransformer transformer : this.globalTransformers) {
                    transformer.after(className, classFileBuffer);
                }
            }
            catch (Throwable e) {
                DebugInfo.error("Transform class failed: " + className, e);
            }
        }
        return classFileBuffer;
    }
}

