// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.toolWindow;

import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ResourceBundle;

/**
 * Provides content tab for Spring toolwindow.
 *
 * @author Yann C&eacute;bron
 */
public final class SpringToolWindowContent extends BaseKeyedLazyInstance<SpringToolWindowContentProvider> {
  private static final Logger LOG = Logger.getInstance(SpringToolWindowContent.class);

  public static final String TOOLWINDOW_ID = "Spring";
  public static final DataKey<SpringToolWindowContentUpdater> CONTENT_UPDATER = DataKey.create("springToolWindowContentUpdater");

  @Attribute("displayName")
  @NlsContexts.TabTitle
  public String displayName;

  @Attribute("icon")
  public String icon;

  @Attribute("bundle")
  public String bundle;

  @Attribute("implementation")
  public String implementation;

  public @NlsContexts.TabTitle @NotNull String getDisplayName() {
    String baseName = bundle != null ? bundle : getPluginDescriptor().getResourceBundleBaseName();
    if (baseName == null) {
      LOG.error("No resource bundle specified for " + getPluginDescriptor());
      return displayName;
    }

    ResourceBundle bundle = DynamicBundle.INSTANCE.getResourceBundle(baseName, getLoaderForClass());
    return BundleBase.messageOrDefault(bundle, displayName, null);
  }

  @Override
  protected @Nullable String getImplementationClassName() {
    return implementation;
  }
}
