// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

/**
 * Provides access to Project-level Spring settings.
 */
public abstract class SpringGeneralSettings implements Disposable {

  public abstract boolean isShowProfilesPanel();
  public abstract void setShowProfilesPanel(boolean showProfilesPanel);

  public abstract boolean isShowMultipleContextsPanel();
  public abstract void setShowMultipleContextsPanel(boolean showMultipleContextsPanel);

  public abstract boolean isAllowAutoConfigurationMode();
  public abstract void setAllowAutoConfigurationMode(boolean allowAutoConfigurationMode);

  public static SpringGeneralSettings getInstance(@NotNull Project project) {
    return project.getService(SpringGeneralSettings.class);
  }
}
