// Copyright 2000-2021 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.profiles;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.model.jam.profile.SpringJamProfile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

/**
 * @author Sergey Vasiliev
 */
public final class SpringProfilesReferenceProvider extends PsiReferenceProvider {

  private final SpringJamProfile.SpringProfileConverter myDelegate = new SpringJamProfile.SpringProfileConverter("", false);

  @Override
  public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element,
                                                         @NotNull final ProcessingContext context) {
    return element instanceof PsiLanguageInjectionHost ?
           myDelegate.createReferences((PsiLanguageInjectionHost)element) :
           PsiReference.EMPTY_ARRAY;
  }
}