// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.profiles;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public abstract class SpringProfilesFactory {
  public static SpringProfilesFactory getInstance() {
    return ApplicationManager.getApplication().getService(SpringProfilesFactory.class);
  }

  @NotNull
  public abstract List<SpringProfileTarget> findProfileTargets(@NotNull Module module, boolean includeTests);

  @Nullable
  public abstract SpringProfileTarget findProfileTarget(@NotNull Module module, boolean includeTests, @NotNull String profileName);

  public abstract PsiReference @NotNull [] getProfilesReferences(@NotNull Module module, @NotNull PsiElement element,
                                                                 @Nullable String value, int valueOffset,
                                                                 @NotNull String delimiters, boolean isDefinition);

  /**
   * @return parsed profiles expressions that can be matched against active profiles
   * @throws SpringProfilesFactory.MalformedProfileExpressionException if profile expression is malformed
   */
  public abstract Predicate<Set<String>> parseProfileExpressions(@NotNull Collection<String> expressions);

  public static class MalformedProfileExpressionException extends RuntimeException {
    MalformedProfileExpressionException(String message) {
      super(message);
    }
  }
}
